/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Long256;
import io.questdb.std.Long256Util;
import io.questdb.std.Numbers;
import io.questdb.std.Rnd;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.NotNull;

public class Long256Impl
implements Long256,
Sinkable {
    public static final Long256Impl NULL_LONG256 = new Long256Impl();
    public static final Long256Impl ZERO_LONG256 = new Long256Impl();
    private long l0;
    private long l1;
    private long l2;
    private long l3;

    public static Long256Impl add(Long256Impl sum, Long256 x, Long256 y) {
        if (x.equals(NULL_LONG256) || y.equals(NULL_LONG256)) {
            return NULL_LONG256;
        }
        sum.copyFrom(x);
        Long256Util.add(sum, y);
        return sum;
    }

    public static boolean isNull(Long256 value) {
        return NULL_LONG256.equals(value);
    }

    public static boolean isNull(long l0, long l1, long l2, long l3) {
        return l0 == Long.MIN_VALUE && l1 == Long.MIN_VALUE && l2 == Long.MIN_VALUE && l3 == Long.MIN_VALUE;
    }

    public static void putNull(long appendPointer) {
        Unsafe.getUnsafe().putLong(appendPointer, NULL_LONG256.getLong0());
        Unsafe.getUnsafe().putLong(appendPointer + 8L, NULL_LONG256.getLong1());
        Unsafe.getUnsafe().putLong(appendPointer + 16L, NULL_LONG256.getLong2());
        Unsafe.getUnsafe().putLong(appendPointer + 24L, NULL_LONG256.getLong3());
    }

    public void copyFrom(Long256 value) {
        this.l0 = value.getLong0();
        this.l1 = value.getLong1();
        this.l2 = value.getLong2();
        this.l3 = value.getLong3();
    }

    public boolean equals(Object obj) {
        Long256Impl that = (Long256Impl)obj;
        return this.l0 == that.l0 && this.l1 == that.l1 && this.l2 == that.l2 && this.l3 == that.l3;
    }

    public void fromRnd(Rnd rnd) {
        this.setAll(rnd.nextLong(), rnd.nextLong(), rnd.nextLong(), rnd.nextLong());
    }

    @Override
    public long getLong0() {
        return this.l0;
    }

    @Override
    public long getLong1() {
        return this.l1;
    }

    @Override
    public long getLong2() {
        return this.l2;
    }

    @Override
    public long getLong3() {
        return this.l3;
    }

    @Override
    public void setAll(long l0, long l1, long l2, long l3) {
        this.l0 = l0;
        this.l1 = l1;
        this.l2 = l2;
        this.l3 = l3;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        Numbers.appendLong256(this.l0, this.l1, this.l2, this.l3, sink);
    }

    public String toString() {
        StringSink sink = new StringSink();
        this.toSink(sink);
        return sink.toString();
    }

    static {
        NULL_LONG256.setAll(Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE);
        ZERO_LONG256.setAll(0L, 0L, 0L, 0L);
    }
}

