/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

public class IntGroupSort {
    private static int compareGroups(int[] array, int i, int j, int n) {
        for (int k = 0; k < n; ++k) {
            int comparison = Integer.compare(array[i * n + k], array[j * n + k]);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    private static int partition(int[] array, int low, int high, int n) {
        int pivotIndex = high - 1;
        int i = low - 1;
        for (int j = low; j < high; ++j) {
            if (IntGroupSort.compareGroups(array, j, pivotIndex, n) >= 0) continue;
            IntGroupSort.swapGroups(array, ++i, j, n);
        }
        IntGroupSort.swapGroups(array, ++i, pivotIndex, n);
        return i;
    }

    private static void quickSortImpl(int[] array, int low, int high, int n) {
        if (low + 1 < high) {
            int pi = IntGroupSort.partition(array, low, high, n);
            IntGroupSort.quickSortImpl(array, low, pi, n);
            IntGroupSort.quickSortImpl(array, pi + 1, high, n);
        }
    }

    private static void swapGroups(int[] array, int i, int j, int n) {
        if (i != j) {
            for (int k = 0; k < n; ++k) {
                int temp = array[i * n + k];
                array[i * n + k] = array[j * n + k];
                array[j * n + k] = temp;
            }
        }
    }

    static void quickSort(int n, int[] array, int groupLo, int groupHi) {
        assert (groupHi >= groupLo);
        IntGroupSort.quickSortImpl(array, groupLo, groupHi, n);
    }
}

