/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.NetworkError;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.StdoutSink;
import java.util.concurrent.atomic.AtomicInteger;

public final class Net {
    public static final int EOTHERDISCONNECT = -2;
    public static final int EPEERDISCONNECT = -1;
    public static final int ERETRY = 0;
    public static final int EWOULDBLOCK;
    public static final long MMSGHDR_BUFFER_ADDRESS_OFFSET;
    public static final long MMSGHDR_BUFFER_LENGTH_OFFSET;
    public static final long MMSGHDR_SIZE;
    public static final int SHUT_WR = 1;
    private static final AtomicInteger ADDR_INFO_COUNTER;
    private static final Log LOG;
    private static final AtomicInteger SOCK_ADDR_COUNTER;
    private static final int TCP_KEEPALIVE_SECONDS;

    private Net() {
    }

    public static int abortAccept(long fd) {
        return Net.abortAccept(Files.toOsFd(fd));
    }

    public static long accept(long serverFd) {
        return Files.createUniqueFd(Net.accept0(Files.toOsFd(serverFd)));
    }

    public static void appendIP4(CharSink<?> sink, long ip) {
        sink.put(ip >> 24 & 0xFFL).putAscii('.').put(ip >> 16 & 0xFFL).putAscii('.').put(ip >> 8 & 0xFFL).putAscii('.').put(ip & 0xFFL);
    }

    public static boolean bindTcp(long fd, int ipv4address, int port) {
        return Net.bindTcp(Files.toOsFd(fd), ipv4address, port);
    }

    public static boolean bindTcp(long fd, CharSequence ipv4address, int port) {
        return Net.bindTcp(fd, Net.parseIPv4(ipv4address), port);
    }

    public static boolean bindUdp(long fd, int ipv4Address, int port) {
        return Net.bindUdp(Files.toOsFd(fd), ipv4Address, port);
    }

    public static int close(long fd) {
        return Files.close(fd);
    }

    public static void configureKeepAlive(long fd) {
        if (TCP_KEEPALIVE_SECONDS < 0 || fd < 0L) {
            return;
        }
        if (Net.setKeepAlive0(Files.toOsFd(fd), TCP_KEEPALIVE_SECONDS) < 0) {
            int errno = Os.errno();
            LOG.error().$("could not set tcp keepalive [fd=").$(fd).$(", errno=").$(errno).I$();
        }
    }

    public static int configureLinger(long fd, int seconds) {
        return Net.configureLinger(Files.toOsFd(fd), seconds);
    }

    public static int configureNoLinger(long fd) {
        return Net.configureLinger(Files.toOsFd(fd), 0);
    }

    public static int configureNonBlocking(long fd) {
        return Net.configureNonBlocking(Files.toOsFd(fd));
    }

    public static int connect(long fd, long sockaddr) {
        return Net.connect(Files.toOsFd(fd), sockaddr);
    }

    public static int connectAddrInfo(long fd, long lpAddrInfo) {
        return Net.connectAddrInfo(Files.toOsFd(fd), lpAddrInfo);
    }

    public static void dump(long buffer, int len) {
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                Numbers.appendHex(StdoutSink.INSTANCE, Unsafe.getUnsafe().getByte(buffer + (long)i) & 0xFF);
            }
            StdoutSink.INSTANCE.put('\n');
            StdoutSink.INSTANCE.flush();
        }
    }

    public static void dumpAscii(long buffer, int len) {
        if (len > 0) {
            block4: for (int i = 0; i < len; ++i) {
                char c = (char)(Unsafe.getUnsafe().getByte(buffer + (long)i) & 0xFF);
                switch (c) {
                    case '\r': {
                        System.out.print("\\r");
                        continue block4;
                    }
                    case '\n': {
                        System.out.print("\\n");
                        System.out.print(c);
                        continue block4;
                    }
                    default: {
                        System.out.print(c);
                    }
                }
            }
        }
    }

    public static void freeAddrInfo(long pAddrInfo) {
        if (pAddrInfo != 0L) {
            ADDR_INFO_COUNTER.decrementAndGet();
        }
        Net.freeAddrInfo0(pAddrInfo);
    }

    public static native void freeMsgHeaders(long var0);

    public static void freeSockAddr(long sockaddr) {
        if (sockaddr != 0L) {
            SOCK_ADDR_COUNTER.decrementAndGet();
        }
        Net.freeSockAddr0(sockaddr);
    }

    public static long getAddrInfo(LPSZ host, int port) {
        return Net.getAddrInfo(host.ptr(), port);
    }

    public static long getAddrInfo(CharSequence host, int port) {
        try (Path p = new Path();){
            long l = Net.getAddrInfo(p.of(host).$(), port);
            return l;
        }
    }

    public static long getAddrInfo(long lpszHost, int port) {
        long addrInfo = Net.getAddrInfo0(lpszHost, port);
        if (addrInfo != -1L) {
            ADDR_INFO_COUNTER.incrementAndGet();
        }
        return addrInfo;
    }

    public static int getAllocatedAddrInfoCount() {
        return ADDR_INFO_COUNTER.get();
    }

    public static int getAllocatedSockAddrCount() {
        return SOCK_ADDR_COUNTER.get();
    }

    public static long getMMsgBuf(long msgPtr) {
        return Unsafe.getUnsafe().getLong(Unsafe.getUnsafe().getLong(msgPtr + MMSGHDR_BUFFER_ADDRESS_OFFSET));
    }

    public static int getMMsgBufLen(long msgPtr) {
        return Unsafe.getUnsafe().getInt(msgPtr + MMSGHDR_BUFFER_LENGTH_OFFSET);
    }

    public static int getPeerIP(long fd) {
        return Net.getPeerIP(Files.toOsFd(fd));
    }

    public static int getRcvBuf(long fd) {
        return Net.getRcvBuf(Files.toOsFd(fd));
    }

    public static int getSndBuf(long fd) {
        return Net.getSndBuf(Files.toOsFd(fd));
    }

    public static int getTcpNoDelay(long fd) {
        return Net.getTcpNoDelay(Files.toOsFd(fd));
    }

    public static void init() {
    }

    public static boolean isDead(long fd) {
        return Net.isDead(Files.toOsFd(fd));
    }

    public static boolean join(long fd, CharSequence bindIPv4Address, CharSequence groupIPv4Address) {
        return Net.join(Files.toOsFd(fd), Net.parseIPv4(bindIPv4Address), Net.parseIPv4(groupIPv4Address));
    }

    public static boolean join(long fd, int bindIPv4Address, int groupIPv4Address) {
        return Net.join(Files.toOsFd(fd), bindIPv4Address, groupIPv4Address);
    }

    public static void listen(long fd, int backlog) {
        Net.listen(Files.toOsFd(fd), backlog);
    }

    public static native long msgHeaders(int var0, int var1);

    public static int parseIPv4(CharSequence ipv4Address) {
        int ip = 0;
        int count = 0;
        int lo = 0;
        try {
            int hi;
            while ((hi = Chars.indexOf(ipv4Address, lo, '.')) > -1) {
                int n = Numbers.parseInt(ipv4Address, lo, hi);
                ip = ip << 8 | n;
                ++count;
                lo = hi + 1;
            }
            if (count != 3) {
                throw NetworkError.instance(0, "invalid address [").put(ipv4Address).put(']');
            }
            return ip << 8 | Numbers.parseInt(ipv4Address, lo, ipv4Address.length());
        }
        catch (NumericException e) {
            throw NetworkError.instance(0, "invalid address [").put(ipv4Address).put(']');
        }
    }

    public static int peek(long fd, long ptr, int len) {
        return Net.peek(Files.toOsFd(fd), ptr, len);
    }

    public static int recv(long fd, long ptr, int len) {
        return Net.recv(Files.toOsFd(fd), ptr, len);
    }

    public static int recvmmsg(long fd, long msgvec, int vlen) {
        return Net.recvmmsg(Files.toOsFd(fd), msgvec, vlen);
    }

    public static int resolvePort(long fd) {
        return Net.resolvePort(Files.toOsFd(fd));
    }

    public static int send(long fd, long ptr, int len) {
        return Net.send(Files.toOsFd(fd), ptr, len);
    }

    public static int sendTo(long fd, long ptr, int len, long sockaddr) {
        return Net.sendTo(Files.toOsFd(fd), ptr, len, sockaddr);
    }

    public static int setMulticastInterface(long fd, int ipv4address) {
        return Net.setMulticastInterface(Files.toOsFd(fd), ipv4address);
    }

    public static int setMulticastLoop(long fd, boolean loop) {
        return Net.setMulticastLoop(Files.toOsFd(fd), loop);
    }

    public static int setMulticastTtl(long fd, int ttl) {
        return Net.setMulticastTtl(Files.toOsFd(fd), ttl);
    }

    public static int setRcvBuf(long fd, int size) {
        return Net.setRcvBuf(Files.toOsFd(fd), size);
    }

    public static int setReuseAddress(long fd) {
        return Net.setReuseAddress(Files.toOsFd(fd));
    }

    public static int setReusePort(long fd) {
        return Net.setReusePort(Files.toOsFd(fd));
    }

    public static int setSndBuf(long fd, int size) {
        return Net.setSndBuf(Files.toOsFd(fd), size);
    }

    public static int setTcpNoDelay(long fd, boolean noDelay) {
        return Net.setTcpNoDelay(Files.toOsFd(fd), noDelay);
    }

    public static int shutdown(long fd, int how) {
        return Net.shutdown(Files.toOsFd(fd), how);
    }

    public static long sockaddr(CharSequence ipv4address, int port) {
        return Net.sockaddr(Net.parseIPv4(ipv4address), port);
    }

    public static long sockaddr(int ipv4address, int port) {
        SOCK_ADDR_COUNTER.incrementAndGet();
        return Net.sockaddr0(ipv4address, port);
    }

    public static long socketTcp(boolean blocking) {
        return Files.createUniqueFd(Net.socketTcp0(blocking));
    }

    public static long socketUdp() {
        return Files.createUniqueFd(Net.socketUdp0());
    }

    private static native int abortAccept(int var0);

    private static native int accept0(int var0);

    private static native boolean bindTcp(int var0, int var1, int var2);

    private static native boolean bindUdp(int var0, int var1, int var2);

    private static native int configureLinger(int var0, int var1);

    private static native int configureNonBlocking(int var0);

    private static native int connect(int var0, long var1);

    private static native int connectAddrInfo(int var0, long var1);

    private static native void freeAddrInfo0(long var0);

    private static native void freeSockAddr0(long var0);

    private static native long getAddrInfo0(long var0, int var2);

    private static native int getEwouldblock();

    private static native long getMsgHeaderBufferAddressOffset();

    private static native long getMsgHeaderBufferLengthOffset();

    private static native long getMsgHeaderSize();

    private static native int getPeerIP(int var0);

    private static native int getPeerPort(int var0);

    private static native int getRcvBuf(int var0);

    private static native int getSndBuf(int var0);

    private static native int getTcpNoDelay(int var0);

    private static native boolean isDead(int var0);

    private static native boolean join(int var0, int var1, int var2);

    private static native void listen(int var0, int var1);

    private static native int peek(int var0, long var1, int var3);

    private static native int recv(int var0, long var1, int var3);

    private static native int recvmmsg(int var0, long var1, int var3);

    private static native int resolvePort(int var0);

    private static native int send(int var0, long var1, int var3);

    private static native int sendTo(int var0, long var1, int var3, long var4);

    private static native int setKeepAlive0(int var0, int var1);

    private static native int setMulticastInterface(int var0, int var1);

    private static native int setMulticastLoop(int var0, boolean var1);

    private static native int setMulticastTtl(int var0, int var1);

    private static native int setRcvBuf(int var0, int var1);

    private static native int setReuseAddress(int var0);

    private static native int setReusePort(int var0);

    private static native int setSndBuf(int var0, int var1);

    private static native int setTcpNoDelay(int var0, boolean var1);

    private static native int shutdown(int var0, int var1);

    private static native long sockaddr0(int var0, int var1);

    private static native int socketTcp0(boolean var0);

    private static native int socketUdp0();

    static {
        ADDR_INFO_COUNTER = new AtomicInteger();
        LOG = LogFactory.getLog(Net.class);
        SOCK_ADDR_COUNTER = new AtomicInteger();
        TCP_KEEPALIVE_SECONDS = Integer.getInteger("questdb.unsupported.tcp.keepalive.seconds", 30);
        Os.init();
        EWOULDBLOCK = Net.getEwouldblock();
        if (Os.isLinux()) {
            MMSGHDR_SIZE = Net.getMsgHeaderSize();
            MMSGHDR_BUFFER_ADDRESS_OFFSET = Net.getMsgHeaderBufferAddressOffset();
            MMSGHDR_BUFFER_LENGTH_OFFSET = Net.getMsgHeaderBufferLengthOffset();
        } else {
            MMSGHDR_SIZE = -1L;
            MMSGHDR_BUFFER_ADDRESS_OFFSET = -1L;
            MMSGHDR_BUFFER_LENGTH_OFFSET = -1L;
        }
    }
}

