/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.Metrics;
import io.questdb.log.Log;
import io.questdb.mp.EagerThreadSetup;
import io.questdb.mp.Job;
import io.questdb.mp.SOCountDownLatch;
import io.questdb.std.ObjHashSet;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public class Worker
extends Thread {
    public static final MicrosecondClock CLOCK_MICROS = MicrosecondClockImpl.INSTANCE;
    public static final int NO_THREAD_AFFINITY = -1;
    private final int affinity;
    private final String criticalErrorLine;
    private final SOCountDownLatch haltLatch;
    private final boolean haltOnError;
    private final AtomicLong jobStartMicros = new AtomicLong();
    private final ObjHashSet<? extends Job> jobs;
    private final AtomicReference<Lifecycle> lifecycle = new AtomicReference<Lifecycle>(Lifecycle.BORN);
    private final Log log;
    private final Metrics metrics;
    private final long napThreshold;
    private final OnHaltAction onHaltAction;
    private final String poolName;
    private final Job.RunStatus runStatus = () -> this.lifecycle.get() == Lifecycle.HALTED;
    private final long sleepMs;
    private final long sleepThreshold;
    private final int workerId;
    private final long yieldThreshold;

    public Worker(String poolName, int workerId, int affinity, ObjHashSet<? extends Job> jobs, SOCountDownLatch haltLatch, @Nullable OnHaltAction onHaltAction, boolean haltOnError, long yieldThreshold, long napThreshold, long sleepThreshold, long sleepMs, Metrics metrics, @Nullable Log log) {
        assert (yieldThreshold > 0L);
        this.setName(poolName + "_" + workerId);
        this.poolName = poolName;
        this.workerId = workerId;
        this.affinity = affinity;
        this.jobs = jobs;
        this.haltLatch = haltLatch;
        this.onHaltAction = onHaltAction;
        this.haltOnError = haltOnError;
        this.criticalErrorLine = "0000-00-00T00:00:00.000000Z C Unhandled exception in worker " + this.getName();
        this.yieldThreshold = yieldThreshold;
        this.napThreshold = napThreshold;
        this.sleepThreshold = sleepThreshold;
        this.sleepMs = sleepMs;
        this.metrics = metrics;
        this.log = log;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public int getWorkerId() {
        return this.workerId;
    }

    public void halt() {
        this.lifecycle.set(Lifecycle.HALTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block41: {
            Throwable ex = null;
            try {
                if (!this.lifecycle.compareAndSet(Lifecycle.BORN, Lifecycle.RUNNING)) break block41;
                String workerName = this.getName();
                if (this.affinity > -1) {
                    if (Os.setCurrentThreadAffinity(this.affinity) == 0) {
                        if (this.log != null) {
                            this.log.info().$("affinity set [cpu=").$(this.affinity).$(", name=").$(workerName).I$();
                        }
                    } else if (this.log != null) {
                        this.log.error().$("could not set affinity [cpu=").$(this.affinity).$(", name=").$(workerName).I$();
                    }
                } else if (this.log != null) {
                    this.log.info().$("os scheduled worker started [name=").$(workerName).I$();
                }
                int n = this.jobs.size();
                for (int i = 0; i < n; ++i) {
                    Unsafe.getUnsafe().loadFence();
                    try {
                        Job job = this.jobs.get(i);
                        if (!(job instanceof EagerThreadSetup)) continue;
                        ((EagerThreadSetup)((Object)job)).setup();
                        continue;
                    }
                    finally {
                        Unsafe.getUnsafe().storeFence();
                    }
                }
                long ticker = 0L;
                while (this.lifecycle.get() == Lifecycle.RUNNING) {
                    boolean runAsap = false;
                    this.jobStartMicros.lazySet(CLOCK_MICROS.getTicks());
                    int n2 = this.jobs.size();
                    for (int i = 0; i < n2; ++i) {
                        Unsafe.getUnsafe().loadFence();
                        try {
                            runAsap |= this.jobs.get(i).run(this.workerId, this.runStatus);
                            continue;
                        }
                        catch (Throwable e) {
                            if (this.metrics.isEnabled()) {
                                try {
                                    this.metrics.healthMetrics().incrementUnhandledErrors();
                                }
                                catch (Throwable t) {
                                    this.stdErrCritical(t);
                                }
                            }
                            if (this.log != null) {
                                this.log.critical().$("unhandled error [job=").$(this.jobs.get(i).toString()).$(", ex=").$(e).I$();
                            } else {
                                this.stdErrCritical(e);
                            }
                            if (!this.haltOnError) continue;
                            throw e;
                        }
                        finally {
                            Unsafe.getUnsafe().storeFence();
                        }
                    }
                    if (runAsap) {
                        ticker = 0L;
                        continue;
                    }
                    if (++ticker < 0L) {
                        ticker = this.sleepThreshold + 1L;
                    }
                    if (ticker > this.sleepThreshold) {
                        Os.sleep(this.sleepMs);
                        continue;
                    }
                    if (ticker > this.napThreshold) {
                        Os.sleep(1L);
                        continue;
                    }
                    if (ticker <= this.yieldThreshold) continue;
                    Os.pause();
                }
            }
            catch (Throwable e) {
                ex = e;
                this.stdErrCritical(e);
            }
            finally {
                if (this.onHaltAction != null) {
                    try {
                        this.onHaltAction.run(ex);
                        if (this.log != null) {
                            this.log.info().$("cleaned worker [name=").$(this.poolName).$(", worker=").$(this.workerId).I$();
                        }
                    }
                    catch (Throwable t) {
                        this.stdErrCritical(t);
                    }
                }
                this.haltLatch.countDown();
                if (this.log != null) {
                    this.log.info().$("os scheduled worker stopped [name=").$(this.getName()).I$();
                }
            }
        }
    }

    private void stdErrCritical(Throwable e) {
        System.err.println(this.criticalErrorLine);
        e.printStackTrace(System.err);
    }

    long getJobStartMicros() {
        return this.jobStartMicros.get();
    }

    private static enum Lifecycle {
        BORN,
        RUNNING,
        HALTED;

    }

    @FunctionalInterface
    public static interface OnHaltAction {
        public void run(Throwable var1);
    }
}

