/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.pool.WriterPool;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import java.util.Iterator;
import java.util.Map;

public final class WriterPoolRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final int LAST_ACCESS_TIMESTAMP_COLUMN_INDEX = 2;
    private static final RecordMetadata METADATA;
    private static final int OWNERSHIP_REASON_COLUMN_INDEX = 3;
    private static final int OWNER_THREAD_COLUMN_INDEX = 1;
    private static final int TABLE_NAME_COLUMN_INDEX = 0;
    private final CairoEngine cairoEngine;

    public WriterPoolRecordCursorFactory(CairoEngine cairoEngine) {
        super(METADATA);
        this.cairoEngine = cairoEngine;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        WriterPoolCursor writerPoolCursor = new WriterPoolCursor();
        writerPoolCursor.of(this.cairoEngine.getWriterPoolEntries());
        return writerPoolCursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("writer_pool");
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(0, new TableColumnMetadata("table_name", 11)).add(1, new TableColumnMetadata("owner_thread_id", 6)).add(2, new TableColumnMetadata("last_access_timestamp", 8)).add(3, new TableColumnMetadata("ownership_reason", 11));
        METADATA = metadata;
    }

    private static class WriterPoolCursor
    implements NoRandomAccessRecordCursor {
        private final ReaderPoolEntryRecord record = new ReaderPoolEntryRecord();
        private Iterator<Map.Entry<CharSequence, WriterPool.Entry>> iterator;
        private long lastAccessTimestamp;
        private long ownerThread;
        private String ownershipReason;
        private TableToken tableToken;
        private Map<CharSequence, WriterPool.Entry> writerPoolEntries;

        private WriterPoolCursor() {
        }

        @Override
        public void close() {
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                Map.Entry<CharSequence, WriterPool.Entry> mapEntry = this.iterator.next();
                WriterPool.Entry poolEntry = mapEntry.getValue();
                this.ownerThread = poolEntry.getOwnerThread();
                this.lastAccessTimestamp = poolEntry.getLastReleaseTime();
                this.tableToken = poolEntry.getTableToken();
                this.ownershipReason = poolEntry.getOwnershipReason();
                return true;
            }
            return false;
        }

        public void of(Map<CharSequence, WriterPool.Entry> readerPoolEntries) {
            this.writerPoolEntries = readerPoolEntries;
            this.toTop();
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.iterator = this.writerPoolEntries.entrySet().iterator();
        }

        private class ReaderPoolEntryRecord
        implements Record {
            private ReaderPoolEntryRecord() {
            }

            @Override
            public long getLong(int col) {
                if (col == 1) {
                    return WriterPoolCursor.this.ownerThread == -1L ? Long.MIN_VALUE : WriterPoolCursor.this.ownerThread;
                }
                throw CairoException.nonCritical().put("unsupported column number. [column=").put(col).put("]");
            }

            @Override
            public CharSequence getStrA(int col) {
                switch (col) {
                    case 0: {
                        return WriterPoolCursor.this.tableToken.getTableName();
                    }
                    case 3: {
                        return WriterPoolCursor.this.ownershipReason;
                    }
                }
                throw CairoException.nonCritical().put("unsupported column number. [column=").put(col).put("]");
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStrA(col);
            }

            @Override
            public int getStrLen(int col) {
                return TableUtils.lengthOf(this.getStrA(col));
            }

            @Override
            public long getTimestamp(int col) {
                assert (col == 2);
                return WriterPoolCursor.this.lastAccessTimestamp;
            }
        }
    }
}

