/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import org.jetbrains.annotations.NotNull;

final class StringLongTuplesRecordCursor
implements NoRandomAccessRecordCursor {
    private final TableWriterMetricsRecord record = new TableWriterMetricsRecord();
    private String[] keys;
    private int pos;
    private long[] values;

    StringLongTuplesRecordCursor() {
    }

    @Override
    public void close() {
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public boolean hasNext() {
        if (this.keys.length > this.pos + 1) {
            ++this.pos;
            return true;
        }
        return false;
    }

    public void of(String[] keys, long[] values) {
        assert (keys.length == values.length);
        this.keys = keys;
        this.values = values;
        this.toTop();
    }

    @Override
    public long preComputedStateSize() {
        return 0L;
    }

    @Override
    public long size() {
        return this.keys.length;
    }

    @Override
    public void toTop() {
        this.pos = -1;
    }

    private class TableWriterMetricsRecord
    implements Record {
        private TableWriterMetricsRecord() {
        }

        @Override
        public long getLong(int col) {
            if (col != 1) {
                throw CairoException.nonCritical().put("unsupported long column number [column=").put(col).put("]");
            }
            return StringLongTuplesRecordCursor.this.values[StringLongTuplesRecordCursor.this.pos];
        }

        @Override
        @NotNull
        public CharSequence getStrA(int col) {
            if (col != 0) {
                throw CairoException.nonCritical().put("unsupported string column number [column=").put(col).put("]");
            }
            return StringLongTuplesRecordCursor.this.keys[StringLongTuplesRecordCursor.this.pos];
        }

        @Override
        public CharSequence getStrB(int col) {
            return this.getStrA(col);
        }

        @Override
        public int getStrLen(int col) {
            return this.getStrA(col).length();
        }
    }
}

