/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractLatestByValueRecordCursor;
import org.jetbrains.annotations.NotNull;

class LatestByValueIndexedFilteredRecordCursor
extends AbstractLatestByValueRecordCursor {
    private final Function filter;
    private SqlExecutionCircuitBreaker circuitBreaker;

    public LatestByValueIndexedFilteredRecordCursor(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, int columnIndex, int symbolKey, @NotNull Function filter) {
        super(configuration, metadata, columnIndex, symbolKey);
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        if (!this.isFindPending) {
            this.findRecord();
            this.hasNext = this.isRecordFound;
            this.isFindPending = true;
        }
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public void of(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.frameCursor = pageFrameCursor;
        this.recordA.of(pageFrameCursor);
        this.recordB.of(pageFrameCursor);
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.filter.init(pageFrameCursor, executionContext);
        this.isRecordFound = false;
        this.isFindPending = false;
        super.init();
    }

    @Override
    public void setSymbolKey(int symbolKey) {
        super.setSymbolKey(TableUtils.toIndexKey(symbolKey));
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public long preComputedStateSize() {
        return this.isFindPending ? 1L : 0L;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index backward scan").meta("on").putColumnName(this.columnIndex);
        sink.optAttr((CharSequence)"filter", this.filter);
    }

    @Override
    public void toTop() {
        this.hasNext = this.isRecordFound;
        this.filter.toTop();
    }

    private void findRecord() {
        PageFrame frame;
        while ((frame = this.frameCursor.next()) != null) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            BitmapIndexReader indexReader = frame.getBitmapIndexReader(this.columnIndex, 2);
            long partitionLo = frame.getPartitionLo();
            long partitionHi = frame.getPartitionHi() - 1L;
            this.frameAddressCache.add(this.frameCount, frame);
            this.frameMemoryPool.navigateTo(this.frameCount++, this.recordA);
            RowCursor cursor = indexReader.getCursor(false, this.symbolKey, partitionLo, partitionHi);
            while (cursor.hasNext()) {
                this.recordA.setRowIndex(cursor.next() - partitionLo);
                if (!this.filter.getBool(this.recordA)) continue;
                this.isRecordFound = true;
                return;
            }
        }
    }
}

