/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.table.LatestByValueIndexedRowCursor;

public class LatestByValueDeferredIndexedRowCursorFactory
implements RowCursorFactory {
    private final boolean cachedIndexReaderCursor;
    private final int columnIndex;
    private final LatestByValueIndexedRowCursor cursor = new LatestByValueIndexedRowCursor();
    private final Function symbolFunc;
    private int symbolKey;

    public LatestByValueDeferredIndexedRowCursorFactory(int columnIndex, Function symbolFunc, boolean cachedIndexReaderCursor) {
        this.columnIndex = columnIndex;
        this.symbolFunc = symbolFunc;
        this.symbolKey = -2;
        this.cachedIndexReaderCursor = cachedIndexReaderCursor;
    }

    @Override
    public RowCursor getCursor(PageFrame pageFrame, PageFrameMemory pageFrameMemory) {
        RowCursor indexReaderCursor;
        if (this.symbolKey != -2 && (indexReaderCursor = pageFrame.getBitmapIndexReader(this.columnIndex, 2).getCursor(this.cachedIndexReaderCursor, this.symbolKey, pageFrame.getPartitionLo(), pageFrame.getPartitionHi() - 1L)).hasNext()) {
            this.cursor.of(indexReaderCursor.next());
            return this.cursor;
        }
        return EmptyRowCursor.INSTANCE;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public boolean isUsingIndex() {
        return true;
    }

    @Override
    public void prepareCursor(PageFrameCursor pageFrameCursor) {
        CharSequence symbol = this.symbolFunc.getStrA(null);
        this.symbolKey = pageFrameCursor.getSymbolTable(this.columnIndex).keyOf(symbol);
        if (this.symbolKey != -2) {
            ++this.symbolKey;
        }
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index ").type("backward").type(" scan").meta("on").putBaseColumnName(this.columnIndex).meta("deferred").val(true);
        sink.attr("filter").putBaseColumnName(this.columnIndex).val('=').val(this.symbolFunc);
    }
}

