/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.sql.AtomicBooleanCircuitBreaker;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.geohash.GeoHashNative;
import io.questdb.griffin.engine.table.AbstractPageFrameRecordCursor;
import io.questdb.griffin.engine.table.LatestByArguments;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.std.DirectLongList;
import io.questdb.std.Os;
import io.questdb.std.Rows;
import io.questdb.std.Vect;
import io.questdb.tasks.LatestByTask;
import org.jetbrains.annotations.NotNull;

class LatestByAllIndexedRecordCursor
extends AbstractPageFrameRecordCursor {
    private final int columnIndex;
    private final SOUnboundedCountDownLatch doneLatch = new SOUnboundedCountDownLatch();
    private final long indexShift = 0L;
    private final DirectLongList prefixes;
    private final DirectLongList rows;
    private final AtomicBooleanCircuitBreaker sharedCircuitBreaker = new AtomicBooleanCircuitBreaker();
    private long aIndex;
    private long aLimit;
    private long argumentsAddress;
    private MessageBus bus;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private boolean isFrameCacheBuilt;
    private boolean isTreeMapBuilt;
    private int keyCount;
    private int sharedQueryWorkerCount;

    public LatestByAllIndexedRecordCursor(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, int columnIndex, @NotNull DirectLongList rows, @NotNull DirectLongList prefixes) {
        super(configuration, metadata);
        this.rows = rows;
        this.columnIndex = columnIndex;
        this.prefixes = prefixes;
    }

    @Override
    public boolean hasNext() {
        if (!this.isTreeMapBuilt) {
            this.buildTreeMap();
            this.isTreeMapBuilt = true;
        }
        if (this.aIndex < this.aLimit) {
            long rowId = this.rows.get(this.aIndex++) - 1L;
            int frameIndex = 524287 - Rows.toPartitionIndex(rowId);
            this.frameMemoryPool.navigateTo(frameIndex, this.recordA);
            this.recordA.setRowIndex(Rows.toLocalRowID(rowId));
            return true;
        }
        return false;
    }

    @Override
    public void of(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) {
        this.frameCursor = pageFrameCursor;
        this.recordA.of(pageFrameCursor);
        this.recordB.of(pageFrameCursor);
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.bus = executionContext.getMessageBus();
        this.sharedQueryWorkerCount = executionContext.getSharedQueryWorkerCount();
        this.rows.clear();
        this.keyCount = -1;
        this.argumentsAddress = 0L;
        this.isFrameCacheBuilt = false;
        this.isTreeMapBuilt = false;
        super.init();
    }

    @Override
    public long preComputedStateSize() {
        return this.isTreeMapBuilt ? 1L : 0L;
    }

    @Override
    public long size() {
        return this.isTreeMapBuilt ? this.aLimit - 0L : -1L;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Async index backward scan").meta("on").putColumnName(this.columnIndex);
        sink.meta("workers").val(this.sharedQueryWorkerCount + 1);
        if (this.prefixes.size() > 2L) {
            int geoHashColumnIndex = (int)this.prefixes.get(0L);
            int geoHashColumnType = (int)this.prefixes.get(1L);
            int geoHashBits = ColumnType.getGeoHashBits(geoHashColumnType);
            if (geoHashColumnIndex > -1 && ColumnType.isGeoHash(geoHashColumnType)) {
                sink.attr("filter").putColumnName(geoHashColumnIndex).val(" within(");
                long n = this.prefixes.size();
                for (long i = 2L; i < n; i += 2L) {
                    if (i > 2L) {
                        sink.val(',');
                    }
                    sink.val(this.prefixes.get(i), geoHashBits);
                }
                sink.val(')');
            }
        }
    }

    @Override
    public void toTop() {
        this.aIndex = 0L;
    }

    private static long getChunkSize(int keyCount, int sharedWorkerCount) {
        return sharedWorkerCount > 0 ? (long)((keyCount + sharedWorkerCount - 1) / sharedWorkerCount) : (long)keyCount;
    }

    private static int getTaskCount(int keyCount, long chunkSize) {
        return (int)(((long)keyCount + chunkSize - 1L) / chunkSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTreeMap() {
        int taskCount;
        long chunkSize;
        if (this.keyCount < 0) {
            this.keyCount = this.getSymbolTable(this.columnIndex).getSymbolCount() + 1;
            chunkSize = LatestByAllIndexedRecordCursor.getChunkSize(this.keyCount, this.sharedQueryWorkerCount);
            taskCount = LatestByAllIndexedRecordCursor.getTaskCount(this.keyCount, chunkSize);
            this.rows.setCapacity(this.keyCount);
            GeoHashNative.iota(this.rows.getAddress(), this.rows.getCapacity(), 0L);
            this.argumentsAddress = LatestByArguments.allocateMemoryArray(taskCount);
            for (long i = 0L; i < (long)taskCount; ++i) {
                long keyLo = i * chunkSize;
                long keyHi = Long.min(keyLo + chunkSize, this.keyCount);
                long argsAddress = this.argumentsAddress + i * 48L;
                LatestByArguments.setRowsAddress(argsAddress, this.rows.getAddress());
                LatestByArguments.setRowsCapacity(argsAddress, this.rows.getCapacity());
                LatestByArguments.setKeyLo(argsAddress, keyLo);
                LatestByArguments.setKeyHi(argsAddress, keyHi);
                LatestByArguments.setRowsSize(argsAddress, 0L);
            }
            this.sharedCircuitBreaker.reset();
        } else {
            chunkSize = LatestByAllIndexedRecordCursor.getChunkSize(this.keyCount, this.sharedQueryWorkerCount);
            taskCount = LatestByAllIndexedRecordCursor.getTaskCount(this.keyCount, chunkSize);
        }
        int geoHashColumnIndex = -1;
        int geoHashColumnType = 0;
        long prefixesAddress = 0L;
        long prefixesCount = 0L;
        if (this.prefixes.size() > 2L) {
            geoHashColumnIndex = (int)this.prefixes.get(0L);
            geoHashColumnType = (int)this.prefixes.get(1L);
            prefixesAddress = this.prefixes.getAddress() + 16L;
            prefixesCount = this.prefixes.size() - 2L;
        }
        RingQueue<LatestByTask> queue = this.bus.getLatestByQueue();
        MPSequence pubSeq = this.bus.getLatestByPubSeq();
        MCSequence subSeq = this.bus.getLatestBySubSeq();
        int queuedCount = 0;
        long foundRowCount = 0L;
        try {
            PageFrame frame;
            if (!this.isFrameCacheBuilt) {
                while ((frame = this.frameCursor.next()) != null) {
                    this.frameAddressCache.add(this.frameCount++, frame);
                }
                this.isFrameCacheBuilt = true;
            }
            int frameIndex = 0;
            this.frameCursor.toTop();
            while ((frame = this.frameCursor.next()) != null && foundRowCount < (long)this.keyCount) {
                BitmapIndexReader indexReader = frame.getBitmapIndexReader(this.columnIndex, 2);
                long partitionLo = frame.getPartitionLo();
                long partitionHi = frame.getPartitionHi() - 1L;
                long keyBaseAddress = indexReader.getKeyBaseAddress();
                long keysMemorySize = indexReader.getKeyMemorySize();
                long valueBaseAddress = indexReader.getValueBaseAddress();
                long valuesMemorySize = indexReader.getValueMemorySize();
                int valueBlockCapacity = indexReader.getValueBlockCapacity();
                long unIndexedNullCount = indexReader.getColumnTop();
                this.doneLatch.reset();
                queuedCount = 0;
                for (long i = 0L; i < (long)taskCount; ++i) {
                    long keyLo;
                    long keyHi;
                    long argsAddress = this.argumentsAddress + i * 48L;
                    long found = LatestByArguments.getRowsSize(argsAddress);
                    if (found >= (keyHi = LatestByArguments.getKeyHi(argsAddress)) - (keyLo = LatestByArguments.getKeyLo(argsAddress))) continue;
                    long seq = pubSeq.next();
                    if (seq < 0L) {
                        this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                        GeoHashNative.latestByAndFilterPrefix(this.frameMemoryPool, keyBaseAddress, keysMemorySize, valueBaseAddress, valuesMemorySize, argsAddress, unIndexedNullCount, partitionHi, partitionLo, frameIndex, valueBlockCapacity, geoHashColumnIndex, geoHashColumnType, prefixesAddress, prefixesCount);
                        continue;
                    }
                    queue.get(seq).of(this.frameAddressCache, keyBaseAddress, keysMemorySize, valueBaseAddress, valuesMemorySize, argsAddress, unIndexedNullCount, partitionHi, partitionLo, frameIndex, valueBlockCapacity, geoHashColumnIndex, geoHashColumnType, prefixesAddress, prefixesCount, this.doneLatch, this.sharedCircuitBreaker);
                    pubSeq.done(seq);
                    ++queuedCount;
                }
                while (!this.doneLatch.done(queuedCount)) {
                    this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                    long seq = subSeq.next();
                    if (seq > -1L) {
                        try {
                            queue.get(seq).run();
                            continue;
                        }
                        finally {
                            subSeq.done(seq);
                            continue;
                        }
                    }
                    Os.pause();
                }
                foundRowCount = 0L;
                for (int i = 0; i < taskCount; ++i) {
                    long address = this.argumentsAddress + (long)i * 48L;
                    foundRowCount += LatestByArguments.getRowsSize(address);
                }
                ++frameIndex;
            }
        }
        catch (DataUnavailableException e) {
            throw e;
        }
        catch (Throwable th) {
            this.sharedCircuitBreaker.cancel();
            throw th;
        }
        finally {
            this.processTasks(queuedCount);
            if (this.sharedCircuitBreaker.checkIfTripped()) {
                LatestByArguments.releaseMemoryArray(this.argumentsAddress, taskCount);
                this.argumentsAddress = 0L;
            }
        }
        long rowCount = 0L;
        if (this.argumentsAddress > 0L) {
            rowCount = GeoHashNative.slideFoundBlocks(this.argumentsAddress, taskCount);
            LatestByArguments.releaseMemoryArray(this.argumentsAddress, taskCount);
            this.argumentsAddress = 0L;
        }
        this.aLimit = rowCount;
        this.aIndex = 0L;
        this.postProcessRows();
    }

    private void postProcessRows() {
        Vect.sortULongAscInPlace(this.rows.getAddress(), this.aLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTasks(int queuedCount) {
        RingQueue<LatestByTask> queue = this.bus.getLatestByQueue();
        MCSequence subSeq = this.bus.getLatestBySubSeq();
        while (!this.doneLatch.done(queuedCount)) {
            long seq = subSeq.next();
            if (seq > -1L) {
                if (this.circuitBreaker.checkIfTripped()) {
                    this.sharedCircuitBreaker.cancel();
                }
                try {
                    queue.get(seq).run();
                    continue;
                }
                finally {
                    subSeq.done(seq);
                    continue;
                }
            }
            Os.pause();
        }
    }
}

