/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.MessageBus;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameReduceTaskFactory;
import io.questdb.cairo.sql.async.PageFrameReducer;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.griffin.engine.table.AsyncFilterUtils;
import io.questdb.griffin.engine.table.AsyncGroupByNotKeyedAtom;
import io.questdb.griffin.engine.table.AsyncGroupByNotKeyedRecordCursor;
import io.questdb.jit.CompiledFilter;
import io.questdb.mp.SCSequence;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncGroupByNotKeyedRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final PageFrameReducer AGGREGATE = AsyncGroupByNotKeyedRecordCursorFactory::aggregate;
    private static final PageFrameReducer FILTER_AND_AGGREGATE = AsyncGroupByNotKeyedRecordCursorFactory::filterAndAggregate;
    private final RecordCursorFactory base;
    private final SCSequence collectSubSeq = new SCSequence();
    private final AsyncGroupByNotKeyedRecordCursor cursor;
    private final PageFrameSequence<AsyncGroupByNotKeyedAtom> frameSequence;
    private final ObjList<GroupByFunction> groupByFunctions;
    private final int workerCount;

    public AsyncGroupByNotKeyedRecordCursorFactory(@NotNull BytecodeAssembler asm, @NotNull CairoConfiguration configuration, @NotNull MessageBus messageBus, @NotNull RecordCursorFactory base, @NotNull RecordMetadata groupByMetadata, @NotNull ObjList<GroupByFunction> groupByFunctions, @Nullable ObjList<ObjList<GroupByFunction>> perWorkerGroupByFunctions, int valueCount, @Nullable CompiledFilter compiledFilter, @Nullable MemoryCARW bindVarMemory, @Nullable ObjList<Function> bindVarFunctions, @Nullable Function filter, @NotNull PageFrameReduceTaskFactory reduceTaskFactory, @Nullable ObjList<Function> perWorkerFilters, int workerCount) {
        super(groupByMetadata);
        try {
            this.base = base;
            this.groupByFunctions = groupByFunctions;
            AsyncGroupByNotKeyedAtom atom = new AsyncGroupByNotKeyedAtom(asm, configuration, groupByFunctions, perWorkerGroupByFunctions, valueCount, compiledFilter, bindVarMemory, bindVarFunctions, filter, perWorkerFilters, workerCount);
            this.frameSequence = filter != null ? new PageFrameSequence<AsyncGroupByNotKeyedAtom>(configuration, messageBus, atom, FILTER_AND_AGGREGATE, reduceTaskFactory, workerCount, 2) : new PageFrameSequence<AsyncGroupByNotKeyedAtom>(configuration, messageBus, atom, AGGREGATE, reduceTaskFactory, workerCount, 2);
            this.cursor = new AsyncGroupByNotKeyedRecordCursor(groupByFunctions);
            this.workerCount = workerCount;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    public PageFrameSequence<AsyncGroupByNotKeyedAtom> execute(SqlExecutionContext executionContext, SCSequence collectSubSeq, int order) throws SqlException {
        return this.frameSequence.of(this.base, executionContext, collectSubSeq, order);
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        int order = this.base.getScanDirection() == 2 ? 1 : 0;
        this.cursor.of(this.execute(executionContext, this.collectSubSeq, order), executionContext);
        return this.cursor;
    }

    @Override
    public int getScanDirection() {
        return this.base.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        if (this.usesCompiledFilter()) {
            sink.type("Async JIT Group By");
        } else {
            sink.type("Async Group By");
        }
        sink.meta("workers").val(this.workerCount);
        sink.optAttr((CharSequence)"values", this.groupByFunctions, true);
        sink.optAttr((CharSequence)"filter", this.frameSequence.getAtom(), true);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.frameSequence.getAtom().getCompiledFilter() != null;
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void aggregate(int workerId, @NotNull PageFrameMemoryRecord record, @NotNull PageFrameReduceTask task, @NotNull SqlExecutionCircuitBreaker circuitBreaker, @Nullable PageFrameSequence<?> stealingFrameSequence) {
        long frameRowCount = task.getFrameRowCount();
        assert (frameRowCount > 0L);
        AsyncGroupByNotKeyedAtom atom = task.getFrameSequence(AsyncGroupByNotKeyedAtom.class).getAtom();
        PageFrameMemory frameMemory = task.populateFrameMemory();
        record.init(frameMemory);
        boolean owner = stealingFrameSequence != null && stealingFrameSequence == task.getFrameSequence();
        try {
            int slotId = atom.maybeAcquire(workerId, owner, circuitBreaker);
            GroupByFunctionsUpdater functionUpdater = atom.getFunctionUpdater(slotId);
            SimpleMapValue value = atom.getMapValue(slotId);
            try {
                record.setRowIndex(0L);
                long rowId = record.getRowId();
                for (long r = 0L; r < frameRowCount; ++r) {
                    record.setRowIndex(r);
                    if (value.isNew()) {
                        functionUpdater.updateNew(value, record, rowId++);
                        value.setNew(false);
                        continue;
                    }
                    functionUpdater.updateExisting(value, record, rowId++);
                }
            }
            finally {
                atom.release(slotId);
            }
        }
        finally {
            task.releaseFrameMemory();
        }
    }

    private static void aggregateFiltered(@NotNull PageFrameMemoryRecord record, DirectLongList rows, long baseRowId, SimpleMapValue value, GroupByFunctionsUpdater functionUpdater) {
        long n = rows.size();
        for (long p = 0L; p < n; ++p) {
            long r = rows.get(p);
            record.setRowIndex(r);
            if (value.isNew()) {
                functionUpdater.updateNew(value, record, baseRowId + r);
                value.setNew(false);
                continue;
            }
            functionUpdater.updateExisting(value, record, baseRowId + r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterAndAggregate(int workerId, @NotNull PageFrameMemoryRecord record, @NotNull PageFrameReduceTask task, @NotNull SqlExecutionCircuitBreaker circuitBreaker, @Nullable PageFrameSequence<?> stealingFrameSequence) {
        DirectLongList rows = task.getFilteredRows();
        PageFrameSequence<AsyncGroupByNotKeyedAtom> frameSequence = task.getFrameSequence(AsyncGroupByNotKeyedAtom.class);
        AsyncGroupByNotKeyedAtom atom = frameSequence.getAtom();
        PageFrameMemory frameMemory = task.populateFrameMemory();
        record.init(frameMemory);
        rows.clear();
        long frameRowCount = task.getFrameRowCount();
        assert (frameRowCount > 0L);
        boolean owner = stealingFrameSequence != null && stealingFrameSequence == frameSequence;
        try {
            int slotId = atom.maybeAcquire(workerId, owner, circuitBreaker);
            GroupByFunctionsUpdater functionUpdater = atom.getFunctionUpdater(slotId);
            SimpleMapValue value = atom.getMapValue(slotId);
            CompiledFilter compiledFilter = atom.getCompiledFilter();
            Function filter = atom.getFilter(slotId);
            try {
                if (compiledFilter == null || frameMemory.hasColumnTops()) {
                    AsyncFilterUtils.applyFilter(filter, rows, record, frameRowCount);
                } else {
                    AsyncFilterUtils.applyCompiledFilter(compiledFilter, atom.getBindVarMemory(), atom.getBindVarFunctions(), task);
                }
                record.setRowIndex(0L);
                long baseRowId = record.getRowId();
                AsyncGroupByNotKeyedRecordCursorFactory.aggregateFiltered(record, rows, baseRowId, value, functionUpdater);
            }
            finally {
                atom.release(slotId);
            }
        }
        finally {
            task.releaseFrameMemory();
        }
    }

    @Override
    protected void _close() {
        Misc.free(this.base);
        Misc.free(this.cursor);
        Misc.free(this.frameSequence);
        Misc.freeObjList(this.groupByFunctions);
    }
}

