/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.PageFrameMemoryPool;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;

class AsyncFilteredNegativeLimitRecordCursor
implements RecordCursor {
    private static final Log LOG = LogFactory.getLog(AsyncFilteredNegativeLimitRecordCursor.class);
    private final PageFrameMemoryPool frameMemoryPool;
    private final boolean hasDescendingOrder;
    private final PageFrameMemoryRecord record = new PageFrameMemoryRecord(0);
    private int frameIndex;
    private int frameLimit;
    private PageFrameSequence<?> frameSequence;
    private PageFrameMemoryRecord recordB;
    private long rowCount;
    private long rowIndex;
    private long rowLimit;
    private DirectLongList rows;

    public AsyncFilteredNegativeLimitRecordCursor(@NotNull CairoConfiguration configuration, int scanDirection) {
        this.hasDescendingOrder = scanDirection == 2;
        this.frameMemoryPool = new PageFrameMemoryPool(configuration.getSqlParquetFrameCacheCapacity());
    }

    @Override
    public void close() {
        LOG.debug().$("closing [shard=").$(this.frameSequence.getShard()).$(", frameCount=").$(this.frameLimit).I$();
        if (this.frameLimit > -1) {
            this.frameSequence.await();
        }
        this.frameSequence.clear();
        Misc.free(this.frameMemoryPool);
    }

    public void freeRecords() {
        Misc.free(this.record);
        Misc.free(this.recordB);
        Misc.free(this.frameMemoryPool);
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record getRecordB() {
        if (this.recordB != null) {
            return this.recordB;
        }
        this.recordB = new PageFrameMemoryRecord(this.record, 1);
        return this.recordB;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.frameSequence.getSymbolTableSource().getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        if (this.frameIndex == -1) {
            this.fetchAllFrames();
        }
        if (this.rowIndex < this.rows.getCapacity()) {
            long rowId = this.rows.get(this.rowIndex);
            PageFrameMemory frameMemory = this.frameMemoryPool.navigateTo(Rows.toPartitionIndex(rowId));
            this.record.init(frameMemory);
            this.record.setRowIndex(Rows.toLocalRowID(rowId));
            ++this.rowIndex;
            return true;
        }
        return false;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.frameSequence.getSymbolTableSource().newSymbolTable(columnIndex);
    }

    @Override
    public long preComputedStateSize() {
        return this.frameIndex;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        PageFrameMemoryRecord frameMemoryRecord = (PageFrameMemoryRecord)record;
        this.frameMemoryPool.navigateTo(Rows.toPartitionIndex(atRowId), frameMemoryRecord);
        frameMemoryRecord.setRowIndex(Rows.toLocalRowID(atRowId));
    }

    @Override
    public long size() {
        if (this.frameIndex == -1) {
            return -1L;
        }
        return this.rowCount;
    }

    @Override
    public void toTop() {
        this.rowIndex = this.rows.getCapacity() - this.rowCount;
    }

    private void fetchAllFrames() {
        if (this.frameLimit == -1) {
            this.frameSequence.prepareForDispatch();
            this.frameLimit = this.frameSequence.getFrameCount() - 1;
        }
        boolean allFramesActive = true;
        try {
            do {
                long cursor;
                if ((cursor = this.frameSequence.next()) > -1L) {
                    PageFrameReduceTask task = this.frameSequence.getTask(cursor);
                    LOG.debug().$("collected [shard=").$(this.frameSequence.getShard()).$(", frameIndex=").$(task.getFrameIndex()).$(", frameCount=").$(this.frameSequence.getFrameCount()).$(", active=").$(this.frameSequence.isActive()).$(", cursor=").$(cursor).I$();
                    if (task.hasError()) {
                        throw CairoException.nonCritical().position(task.getErrorMessagePosition()).put(task.getErrorMsg()).setCancellation(task.isCancelled()).setInterruption(task.isCancelled()).setOutOfMemory(task.isOutOfMemory());
                    }
                    allFramesActive &= this.frameSequence.isActive() || this.rowCount >= this.rowLimit;
                    DirectLongList frameRows = task.getFilteredRows();
                    long frameRowCount = frameRows.size();
                    this.frameIndex = task.getFrameIndex();
                    if (frameRowCount > 0L && this.rowCount < this.rowLimit + 1L && this.frameSequence.isActive()) {
                        long i;
                        if (this.hasDescendingOrder) {
                            i = 0L;
                            while (i < frameRowCount && this.rowCount < this.rowLimit) {
                                this.rows.set(--this.rowIndex, Rows.toRowID(this.frameIndex, frameRows.get(i)));
                                ++i;
                                ++this.rowCount;
                            }
                        } else {
                            i = frameRowCount - 1L;
                            while (i > -1L && this.rowCount < this.rowLimit) {
                                this.rows.set(--this.rowIndex, Rows.toRowID(this.frameIndex, frameRows.get(i)));
                                --i;
                                ++this.rowCount;
                            }
                        }
                        if (this.rowCount >= this.rowLimit) {
                            this.frameSequence.cancel(0);
                        }
                    }
                    this.frameSequence.collect(cursor, false);
                    continue;
                }
                if (cursor == -2L) break;
                Os.pause();
            } while (this.frameIndex < this.frameLimit);
        }
        catch (Throwable e) {
            LOG.error().$("negative limit filter error [ex=").$(e).I$();
            if (e instanceof CairoException) {
                CairoException ce = (CairoException)e;
                if (ce.isInterruption()) {
                    this.throwTimeoutException();
                } else {
                    throw ce;
                }
            }
            throw CairoException.nonCritical().put(e.getMessage());
        }
        if (!allFramesActive) {
            this.throwTimeoutException();
        }
    }

    private void throwTimeoutException() {
        if (this.frameSequence.getCancelReason() == 3) {
            throw CairoException.queryCancelled();
        }
        throw CairoException.queryTimedOut();
    }

    void of(PageFrameSequence<?> frameSequence, long rowLimit, DirectLongList negativeLimitRows) {
        this.frameSequence = frameSequence;
        this.frameIndex = -1;
        this.frameLimit = -1;
        this.rowLimit = rowLimit;
        this.rows = negativeLimitRows;
        this.rowIndex = negativeLimitRows.getCapacity();
        this.rowCount = 0L;
        this.frameMemoryPool.of(frameSequence.getPageFrameAddressCache());
        this.record.of(frameSequence.getSymbolTableSource());
        if (this.recordB != null) {
            this.recordB.of(frameSequence.getSymbolTableSource());
        }
    }
}

