/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import io.questdb.std.Vect;

class LongSortedLightRecordCursor
implements DelegatingRecordCursor {
    private static final RecordAdapter getIPv4AsLongRef = LongSortedLightRecordCursor::getIPv4AsLong;
    private static final RecordAdapter getIntAsLongRef = LongSortedLightRecordCursor::getIntAsLong;
    private static final RecordAdapter getLongRef = LongSortedLightRecordCursor::getLong;
    private final int columnIndex;
    private final int columnType;
    private final long radixSortThreshold;
    private final Cursor rowIdCursor;
    private final DirectLongList valueRowIdMem;
    private final DirectLongList valueRowIdMemCpy;
    private boolean areValuesSorted;
    private RecordCursor baseCursor;
    private Record baseRecord;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private boolean isOpen;
    private RecordAdapter recordAdapter;

    public LongSortedLightRecordCursor(CairoConfiguration configuration, int columnIndex, int columnType, boolean ascOrder) {
        try {
            this.columnIndex = columnIndex;
            this.columnType = columnType;
            this.isOpen = true;
            this.radixSortThreshold = configuration.getSqlOrderByRadixSortThreshold();
            this.valueRowIdMem = new DirectLongList(configuration.getSqlSortLightValuePageSize() / 16L, 19);
            this.valueRowIdMemCpy = new DirectLongList(configuration.getSqlSortLightValuePageSize() / 16L, 19);
            this.rowIdCursor = ascOrder ? new FwdCursor() : new BwdCursor();
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            Misc.free(this.valueRowIdMem);
            Misc.free(this.valueRowIdMemCpy);
            this.baseCursor = Misc.free(this.baseCursor);
            this.baseRecord = null;
        }
    }

    @Override
    public Record getRecord() {
        return this.baseRecord;
    }

    @Override
    public Record getRecordB() {
        return this.baseCursor.getRecordB();
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.baseCursor.getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        if (!this.areValuesSorted) {
            this.sortValues();
            this.areValuesSorted = true;
        }
        if (this.rowIdCursor.hasNext()) {
            this.baseCursor.recordAt(this.baseRecord, this.rowIdCursor.next());
            return true;
        }
        return false;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.baseCursor.newSymbolTable(columnIndex);
    }

    @Override
    public void of(RecordCursor baseCursor, SqlExecutionContext executionContext) throws SqlException {
        this.baseCursor = baseCursor;
        this.baseRecord = baseCursor.getRecord();
        if (!this.isOpen) {
            this.isOpen = true;
            this.valueRowIdMem.reopen();
        }
        short columnTypeTag = ColumnType.tagOf(this.columnType);
        switch (columnTypeTag) {
            case 6: 
            case 7: 
            case 8: {
                this.recordAdapter = getLongRef;
                break;
            }
            case 5: {
                this.recordAdapter = getIntAsLongRef;
                break;
            }
            case 25: {
                this.recordAdapter = getIPv4AsLongRef;
                break;
            }
            default: {
                throw SqlException.position(0).put("unsupported order by column type: ").put(ColumnType.nameOf(columnTypeTag));
            }
        }
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.areValuesSorted = false;
    }

    @Override
    public long preComputedStateSize() {
        return this.areValuesSorted ? 1L : 0L;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.baseCursor.recordAt(record, atRowId);
    }

    @Override
    public long size() {
        return this.baseCursor.size();
    }

    @Override
    public void toTop() {
        this.rowIdCursor.toTop();
        if (!this.areValuesSorted) {
            this.valueRowIdMem.clear();
            this.baseCursor.toTop();
        }
    }

    private static long getIPv4AsLong(Record record, int columnIndex) {
        return record.getLongIPv4(columnIndex);
    }

    private static long getIntAsLong(Record record, int columnIndex) {
        int value = record.getInt(columnIndex);
        if (value != Integer.MIN_VALUE) {
            return value;
        }
        return Long.MIN_VALUE;
    }

    private static long getLong(Record record, int columnIndex) {
        return record.getLong(columnIndex);
    }

    private void sortValues() {
        while (this.baseCursor.hasNext()) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            this.valueRowIdMem.add(this.recordAdapter.getLong(this.baseRecord, this.columnIndex) ^ Long.MIN_VALUE);
            this.valueRowIdMem.add(this.baseRecord.getRowId());
        }
        long size = this.valueRowIdMem.size();
        if (size > 0L) {
            if (size > this.radixSortThreshold) {
                this.valueRowIdMemCpy.reopen();
                this.valueRowIdMemCpy.setCapacity(this.valueRowIdMem.size());
                Vect.radixSortLongIndexAscInPlace(this.valueRowIdMem.getAddress(), this.valueRowIdMem.size() >>> 1, this.valueRowIdMemCpy.getAddress());
                this.valueRowIdMemCpy.close();
            } else {
                Vect.quickSortLongIndexAscInPlace(this.valueRowIdMem.getAddress(), this.valueRowIdMem.size() >>> 1);
            }
        }
        this.rowIdCursor.toTop();
    }

    private class FwdCursor
    implements Cursor {
        private long limit;
        private long pos;

        private FwdCursor() {
        }

        @Override
        public boolean hasNext() {
            return ++this.pos < this.limit;
        }

        @Override
        public long next() {
            return LongSortedLightRecordCursor.this.valueRowIdMem.get((this.pos << 1) + 1L);
        }

        @Override
        public void toTop() {
            this.pos = -1L;
            this.limit = LongSortedLightRecordCursor.this.valueRowIdMem.size() >>> 1;
        }
    }

    private class BwdCursor
    implements Cursor {
        private long pos;

        private BwdCursor() {
        }

        @Override
        public boolean hasNext() {
            return --this.pos > -1L;
        }

        @Override
        public long next() {
            return LongSortedLightRecordCursor.this.valueRowIdMem.get((this.pos << 1) + 1L);
        }

        @Override
        public void toTop() {
            this.pos = LongSortedLightRecordCursor.this.valueRowIdMem.size() >>> 1;
        }
    }

    private static interface Cursor {
        public boolean hasNext();

        public long next();

        public void toTop();
    }

    @FunctionalInterface
    private static interface RecordAdapter {
        public long getLong(Record var1, int var2);
    }
}

