/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.pool.WriterSource;
import io.questdb.cairo.sql.InsertMethod;
import io.questdb.cairo.sql.InsertOperation;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.griffin.InsertRowImpl;
import io.questdb.griffin.RecordToRowCopier;
import io.questdb.griffin.SqlCompilerImpl;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.DoneOperationFuture;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.Misc;

public class InsertAsSelectOperationImpl
implements InsertOperation {
    private static final Log LOG = LogFactory.getLog(InsertAsSelectOperationImpl.class);
    private final long batchSize;
    private final RecordToRowCopier copier;
    private final InsertSelectOperationFuture doneFuture = new InsertSelectOperationFuture();
    private final CairoEngine engine;
    private final RecordCursorFactory factory;
    private final InsertSelectMethodImpl insertMethod = new InsertSelectMethodImpl();
    private final long metadataVersion;
    private final long o3MaxLag;
    private final TableToken tableToken;
    private final int timestampIndex;
    private long rowCount;

    public InsertAsSelectOperationImpl(CairoEngine engine, TableToken tableToken, RecordCursorFactory cursorFactory, RecordToRowCopier copier, long metadataVersion, int timestampIndex, long batchSize, long o3MaxLag) {
        this.batchSize = batchSize;
        this.copier = copier;
        this.engine = engine;
        this.o3MaxLag = o3MaxLag;
        this.tableToken = tableToken;
        this.metadataVersion = metadataVersion;
        this.factory = cursorFactory;
        this.timestampIndex = timestampIndex;
    }

    @Override
    public void addInsertRow(InsertRowImpl row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        Misc.free(this.factory);
    }

    @Override
    public InsertMethod createMethod(SqlExecutionContext executionContext) throws SqlException {
        return this.createMethod(executionContext, this.engine);
    }

    @Override
    public InsertMethod createMethod(SqlExecutionContext executionContext, WriterSource writerSource) throws SqlException {
        SecurityContext securityContext = executionContext.getSecurityContext();
        securityContext.authorizeInsert(this.tableToken);
        if (this.insertMethod.writer == null) {
            TableWriterAPI writer = writerSource.getTableWriterAPI(this.tableToken, "insertAsSelect");
            if (writer.getMetadataVersion() != this.metadataVersion || !Chars.equals(this.tableToken.getTableName(), writer.getTableToken().getTableName())) {
                writer.close();
                throw TableReferenceOutOfDateException.of(this.tableToken.getTableName());
            }
            this.insertMethod.writer = writer;
        }
        return this.insertMethod;
    }

    @Override
    public OperationFuture execute(SqlExecutionContext sqlExecutionContext) throws SqlException {
        try (InsertMethod insertMethod = this.createMethod(sqlExecutionContext);){
            insertMethod.execute(sqlExecutionContext);
            insertMethod.commit();
            InsertSelectOperationFuture insertSelectOperationFuture = this.doneFuture;
            return insertSelectOperationFuture;
        }
    }

    private class InsertSelectOperationFuture
    extends DoneOperationFuture {
        private InsertSelectOperationFuture() {
        }

        @Override
        public long getAffectedRowsCount() {
            return InsertAsSelectOperationImpl.this.rowCount;
        }
    }

    private class InsertSelectMethodImpl
    implements InsertMethod {
        private TableWriterAPI writer = null;

        private InsertSelectMethodImpl() {
        }

        @Override
        public void close() {
            this.writer = Misc.free(this.writer);
        }

        @Override
        public void commit() {
            this.writer.commit();
        }

        @Override
        public long execute(SqlExecutionContext executionContext) throws SqlException {
            executionContext.setUseSimpleCircuitBreaker(true);
            SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
            try (RecordCursor cursor = InsertAsSelectOperationImpl.this.factory.getCursor(executionContext);){
                try {
                    InsertAsSelectOperationImpl.this.rowCount = InsertAsSelectOperationImpl.this.timestampIndex == -1 ? SqlCompilerImpl.copyUnordered(cursor, this.writer, InsertAsSelectOperationImpl.this.copier, circuitBreaker) : (InsertAsSelectOperationImpl.this.batchSize != -1L ? SqlCompilerImpl.copyOrderedBatched(this.writer, InsertAsSelectOperationImpl.this.factory.getMetadata(), cursor, InsertAsSelectOperationImpl.this.copier, InsertAsSelectOperationImpl.this.timestampIndex, InsertAsSelectOperationImpl.this.batchSize, InsertAsSelectOperationImpl.this.o3MaxLag, circuitBreaker) : SqlCompilerImpl.copyOrderedBatched(this.writer, InsertAsSelectOperationImpl.this.factory.getMetadata(), cursor, InsertAsSelectOperationImpl.this.copier, InsertAsSelectOperationImpl.this.timestampIndex, Long.MAX_VALUE, 0L, circuitBreaker));
                }
                catch (Throwable e) {
                    try {
                        this.writer.rollback();
                    }
                    catch (Throwable e2) {
                        LOG.error().$("could not rollback, writer must be distressed [table=").$(InsertAsSelectOperationImpl.this.tableToken.getTableName()).I$();
                    }
                    throw e;
                }
                finally {
                    executionContext.setUseSimpleCircuitBreaker(false);
                }
            }
            return InsertAsSelectOperationImpl.this.rowCount;
        }

        @Override
        public TableWriterAPI getWriter() {
            return this.writer;
        }

        @Override
        public TableWriterAPI popWriter() {
            TableWriterAPI w = this.writer;
            this.writer = null;
            return w;
        }
    }
}

