/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.AbstractJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.JoinRecord;
import io.questdb.griffin.engine.join.LongChain;
import io.questdb.griffin.model.JoinContext;
import io.questdb.std.Misc;

public class HashJoinLightRecordCursorFactory
extends AbstractJoinRecordCursorFactory {
    private final HashJoinRecordCursor cursor;
    private final RecordSink masterSink;
    private final RecordSink slaveKeySink;

    public HashJoinLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterSink, RecordSink slaveKeySink, int columnSplit, JoinContext joinContext) {
        super(metadata, joinContext, masterFactory, slaveFactory);
        try {
            this.masterSink = masterSink;
            this.slaveKeySink = slaveKeySink;
            this.cursor = new HashJoinRecordCursor(columnSplit, configuration, joinColumnTypes, valueTypes);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.masterFactory.followedOrderByAdvice();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor slaveCursor = this.slaveFactory.getCursor(executionContext);
        RecordCursor masterCursor = null;
        try {
            masterCursor = this.masterFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor, executionContext.getCircuitBreaker());
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public boolean supportsUpdateRowId(TableToken tableToken) {
        return this.masterFactory.supportsUpdateRowId(tableToken);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Hash Join Light");
        sink.attr("condition").val(this.joinContext);
        sink.child(this.masterFactory);
        sink.child("Hash", this.slaveFactory);
    }

    private static void populateRowIDHashMap(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor cursor, Map keyMap, RecordSink recordSink, LongChain rowIDChain) {
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            circuitBreaker.statefulThrowExceptionIfTripped();
            MapKey key = keyMap.withKey();
            key.put(record, recordSink);
            MapValue value = key.createValue();
            if (value.isNew()) {
                value.putInt(0, rowIDChain.put(record.getRowId(), -1));
                value.putInt(1, 1);
                continue;
            }
            value.putInt(0, rowIDChain.put(record.getRowId(), value.getInt(0)));
            value.addInt(1, 1);
        }
    }

    @Override
    protected void _close() {
        Misc.freeIfCloseable(this.getMetadata());
        Misc.free(this.masterFactory);
        Misc.free(this.slaveFactory);
        Misc.free(this.cursor);
    }

    private class HashJoinRecordCursor
    extends AbstractJoinCursor {
        private final Map joinKeyMap;
        private final JoinRecord record;
        private final LongChain slaveChain;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isMapBuilt;
        private boolean isOpen;
        private Record masterRecord;
        private LongChain.Cursor slaveChainCursor;
        private Record slaveRecord;

        public HashJoinRecordCursor(int columnSplit, CairoConfiguration configuration, ColumnTypes joinColumnTypes, ColumnTypes valueTypes) {
            super(columnSplit);
            try {
                this.isOpen = true;
                this.record = new JoinRecord(columnSplit);
                this.joinKeyMap = MapFactory.createUnorderedMap(configuration, joinColumnTypes, valueTypes);
                this.slaveChain = new LongChain(configuration.getSqlHashJoinLightValuePageSize(), configuration.getSqlHashJoinLightValueMaxPages());
            }
            catch (Throwable th) {
                this.close();
                throw th;
            }
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            this.buildMapOfSlaveRecords();
            Record masterRecord = this.masterCursor.getRecord();
            while (this.masterCursor.hasNext()) {
                MapKey key = this.joinKeyMap.withKey();
                key.put(masterRecord, HashJoinLightRecordCursorFactory.this.masterSink);
                MapValue value = key.findValue();
                if (value == null) continue;
                counter.add(value.getInt(1));
            }
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                Misc.free(this.joinKeyMap);
                Misc.free(this.slaveChain);
                super.close();
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            this.buildMapOfSlaveRecords();
            if (this.slaveChainCursor != null && this.slaveChainCursor.hasNext()) {
                this.slaveCursor.recordAt(this.slaveRecord, this.slaveChainCursor.next());
                return true;
            }
            while (this.masterCursor.hasNext()) {
                MapKey key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, HashJoinLightRecordCursorFactory.this.masterSink);
                MapValue value = key.findValue();
                if (value == null) continue;
                this.slaveChainCursor = this.slaveChain.getCursor(value.getInt(0));
                this.slaveChainCursor.hasNext();
                this.slaveCursor.recordAt(this.slaveRecord, this.slaveChainCursor.next());
                return true;
            }
            return false;
        }

        @Override
        public long preComputedStateSize() {
            return this.isMapBuilt ? 1L : 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.slaveChainCursor = null;
            if (!this.isMapBuilt) {
                this.slaveCursor.toTop();
                this.joinKeyMap.clear();
                this.slaveChain.clear();
            }
        }

        private void buildMapOfSlaveRecords() {
            if (!this.isMapBuilt) {
                HashJoinLightRecordCursorFactory.populateRowIDHashMap(this.circuitBreaker, this.slaveCursor, this.joinKeyMap, HashJoinLightRecordCursorFactory.this.slaveKeySink, this.slaveChain);
                this.isMapBuilt = true;
            }
        }

        private void of(RecordCursor masterCursor, RecordCursor slaveCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.joinKeyMap.reopen();
                this.slaveChain.reopen();
            }
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.circuitBreaker = circuitBreaker;
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecord = slaveCursor.getRecordB();
            this.record.of(this.masterRecord, this.slaveRecord);
            this.slaveChainCursor = null;
            this.isMapBuilt = false;
        }
    }
}

