/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import java.util.concurrent.atomic.LongAdder;

public class CountVectorAggregateFunction
extends LongFunction
implements VectorAggregateFunction {
    private final LongAdder count = new LongAdder();
    private final CountFunc countFunc;
    private int valueOffset;

    public CountVectorAggregateFunction(int keyKind) {
        this.countFunc = keyKind == 1 ? Rosti::keyedHourCount : Rosti::keyedIntCount;
    }

    @Override
    public void aggregate(long address, long frameRowCount, int workerId) {
        this.count.add(frameRowCount);
    }

    @Override
    public boolean aggregate(long pRosti, long keyAddress, long valueAddress, long frameRowCount) {
        return this.countFunc.count(pRosti, keyAddress, frameRowCount, this.valueOffset);
    }

    @Override
    public void clear() {
        this.count.reset();
    }

    @Override
    public int getColumnIndex() {
        return -1;
    }

    @Override
    public long getLong(Record rec) {
        return this.count.sum();
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset), 0L);
    }

    @Override
    public boolean merge(long pRostiA, long pRostiB) {
        return Rosti.keyedIntCountMerge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(6);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val("count(*)");
    }

    @Override
    public boolean wrapUp(long pRosti) {
        return Rosti.keyedIntCountWrapUp(pRosti, this.valueOffset, this.count.sum() > 0L ? this.count.sum() : -1L);
    }

    @FunctionalInterface
    private static interface CountFunc {
        public boolean count(long var1, long var3, long var5, int var7);
    }
}

