/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnFilter;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.griffin.engine.groupby.GroupByAllocatorFactory;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdaterFactory;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.VirtualFunctionSkewedSymbolRecordCursor;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.DirectLongLongSortedList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class GroupByRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final GroupByRecordCursor cursor;
    private final ObjList<GroupByFunction> groupByFunctions;
    private final ObjList<Function> keyFunctions;
    private final RecordSink mapSink;
    private final ObjList<Function> recordFunctions;

    public GroupByRecordCursorFactory(@NotNull BytecodeAssembler asm, CairoConfiguration configuration, RecordCursorFactory base, @NotNull ListColumnFilter listColumnFilter, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> keyFunctions, ObjList<Function> recordFunctions) {
        super(groupByMetadata);
        try {
            this.base = base;
            this.groupByFunctions = groupByFunctions;
            this.keyFunctions = keyFunctions;
            this.recordFunctions = recordFunctions;
            this.mapSink = RecordSinkFactory.getInstance(asm, (ColumnTypes)base.getMetadata(), (ColumnFilter)listColumnFilter, keyFunctions, null);
            GroupByFunctionsUpdater updater = GroupByFunctionsUpdaterFactory.getInstance(asm, groupByFunctions);
            this.cursor = new GroupByRecordCursor(configuration, recordFunctions, groupByFunctions, updater, keyTypes, valueTypes);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    public static ObjList<String> getKeys(ObjList<Function> recordFunctions, RecordMetadata metadata) {
        ObjList<String> keyFuncs = null;
        int n = recordFunctions.size();
        for (int i = 0; i < n; ++i) {
            if (recordFunctions.get(i) instanceof GroupByFunction) continue;
            if (keyFuncs == null) {
                keyFuncs = new ObjList<String>();
            }
            keyFuncs.add(metadata.getColumnName(i));
        }
        return keyFuncs;
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            Function.init(this.recordFunctions, baseCursor, executionContext, null);
        }
        catch (Throwable th) {
            baseCursor.close();
            throw th;
        }
        try {
            this.cursor.of(baseCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable th) {
            this.cursor.close();
            throw th;
        }
    }

    @Override
    public boolean recordCursorSupportsLongTopK() {
        return true;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("GroupBy");
        sink.meta("vectorized").val(false);
        sink.optAttr((CharSequence)"keys", GroupByRecordCursorFactory.getKeys(this.recordFunctions, this.getMetadata()));
        sink.optAttr((CharSequence)"values", this.groupByFunctions, true);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    @Override
    protected void _close() {
        Misc.freeObjList(this.recordFunctions);
        Misc.freeObjList(this.keyFunctions);
        Misc.free(this.base);
        Misc.free(this.cursor);
    }

    private class GroupByRecordCursor
    extends VirtualFunctionSkewedSymbolRecordCursor {
        private final GroupByAllocator allocator;
        private final Map dataMap;
        private final GroupByFunctionsUpdater groupByFunctionsUpdater;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isDataMapBuilt;
        private boolean isOpen;
        private long rowId;

        public GroupByRecordCursor(CairoConfiguration configuration, ObjList<Function> functions, ObjList<GroupByFunction> groupByFunctions, @NotNull GroupByFunctionsUpdater groupByFunctionsUpdater, @NotNull ArrayColumnTypes keyTypes, ArrayColumnTypes valueTypes) {
            super(functions);
            try {
                this.isOpen = true;
                this.dataMap = MapFactory.createUnorderedMap(configuration, keyTypes, valueTypes);
                this.groupByFunctionsUpdater = groupByFunctionsUpdater;
                this.allocator = GroupByAllocatorFactory.createAllocator(configuration);
                GroupByUtils.setAllocator(groupByFunctions, this.allocator);
            }
            catch (Throwable th) {
                this.close();
                throw th;
            }
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            this.buildMapConditionally();
            this.baseCursor.calculateSize(circuitBreaker, counter);
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                Misc.free(this.dataMap);
                Misc.free(this.allocator);
                Misc.clearObjList(GroupByRecordCursorFactory.this.groupByFunctions);
                super.close();
            }
        }

        @Override
        public boolean hasNext() {
            this.buildMapConditionally();
            return super.hasNext();
        }

        @Override
        public void longTopK(DirectLongLongSortedList list, int columnIndex) {
            this.buildMapConditionally();
            ((MapRecordCursor)this.baseCursor).longTopK(list, GroupByRecordCursorFactory.this.recordFunctions.getQuick(columnIndex));
        }

        public void of(RecordCursor managedCursor, SqlExecutionContext executionContext) throws SqlException {
            this.managedCursor = managedCursor;
            if (!this.isOpen) {
                this.isOpen = true;
                this.dataMap.reopen();
            }
            this.circuitBreaker = executionContext.getCircuitBreaker();
            Function.init(GroupByRecordCursorFactory.this.keyFunctions, managedCursor, executionContext, null);
            this.isDataMapBuilt = false;
            this.rowId = 0L;
        }

        @Override
        public long preComputedStateSize() {
            return this.isDataMapBuilt ? 1L : 0L;
        }

        @Override
        public void toTop() {
            super.toTop();
            this.rowId = 0L;
        }

        private void buildDataMap() {
            Record baseRecord = this.managedCursor.getRecord();
            while (this.managedCursor.hasNext()) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                MapKey key = this.dataMap.withKey();
                GroupByRecordCursorFactory.this.mapSink.copy(baseRecord, key);
                MapValue value = key.createValue();
                if (value.isNew()) {
                    this.groupByFunctionsUpdater.updateNew(value, baseRecord, this.rowId++);
                    continue;
                }
                this.groupByFunctionsUpdater.updateExisting(value, baseRecord, this.rowId++);
            }
            super.of(this.dataMap.getCursor());
            this.isDataMapBuilt = true;
        }

        private void buildMapConditionally() {
            if (!this.isDataMapBuilt) {
                this.buildDataMap();
            }
        }
    }
}

