/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.window.BaseWindowFunction;
import io.questdb.std.Misc;

public abstract class BasePartitionedWindowFunction
extends BaseWindowFunction
implements Reopenable {
    protected final Map map;
    protected final VirtualRecord partitionByRecord;
    protected final RecordSink partitionBySink;

    public BasePartitionedWindowFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg) {
        super(arg);
        this.map = map;
        this.partitionByRecord = partitionByRecord;
        this.partitionBySink = partitionBySink;
    }

    @Override
    public void close() {
        super.close();
        Misc.free(this.map);
        Misc.freeObjList(this.partitionByRecord.getFunctions());
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        super.init(symbolTableSource, executionContext);
        Function.init(this.partitionByRecord.getFunctions(), symbolTableSource, executionContext, null);
    }

    @Override
    public void reopen() {
        if (this.map != null) {
            this.map.reopen();
        }
    }

    @Override
    public void reset() {
        Misc.free(this.map);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.getName());
        if (this.arg != null) {
            sink.val('(').val(this.arg).val(')');
        } else {
            sink.val("(*)");
        }
        if (this.isIgnoreNulls()) {
            sink.val(" ignore nulls");
        }
        sink.val(" over (");
        sink.val("partition by ");
        sink.val(this.partitionByRecord.getFunctions());
        sink.val(')');
    }

    @Override
    public void toTop() {
        super.toTop();
        Misc.clear(this.map);
    }
}

