/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.test;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.datetime.millitime.MillisecondClock;

public class TestSleepFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "sleep(l)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        long sleepMillis = arg.getLong(null);
        return new Func(configuration, sleepMillis);
    }

    private static class Func
    extends BooleanFunction {
        private final MillisecondClock clock;
        private final long sleepMillis;
        private SqlExecutionCircuitBreaker circuitBreaker;

        public Func(CairoConfiguration configuration, long sleepMillis) {
            this.clock = configuration.getMillisecondClock();
            this.sleepMillis = sleepMillis;
        }

        @Override
        public boolean getBool(Record rec) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            long sleepStart = this.clock.getTicks();
            while (this.clock.getTicks() - sleepStart < this.sleepMillis) {
                this.circuitBreaker.statefulThrowExceptionIfTripped();
                Os.sleep(1L);
            }
            return true;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            this.circuitBreaker = executionContext.getCircuitBreaker();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("sleep(").val(this.sleepMillis).val(')');
        }
    }
}

