/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.test;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import java.util.concurrent.atomic.AtomicInteger;

public class TestLatchedCounterFunctionFactory
implements FunctionFactory {
    public static final String SIGNATURE = "test_latched_counter()";
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static volatile Callback CALLBACK;

    public static int getCount() {
        return COUNTER.get();
    }

    public static void reset(Callback callback) {
        CALLBACK = callback;
        COUNTER.set(0);
    }

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new TestLatchFunction();
    }

    public static interface Callback {
        default public void onClose() {
        }

        default public boolean onGet(Record rec, int count) {
            return true;
        }
    }

    private static class TestLatchFunction
    extends BooleanFunction {
        private final Callback callback = CALLBACK;

        @Override
        public void close() {
            if (this.callback != null) {
                this.callback.onClose();
            }
        }

        @Override
        public boolean getBool(Record rec) {
            int count = COUNTER.incrementAndGet();
            if (this.callback == null) {
                return true;
            }
            return this.callback.onGet(rec, count);
        }

        @Override
        public boolean isThreadSafe() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(TestLatchedCounterFunctionFactory.SIGNATURE);
        }
    }
}

