/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.table;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.VarcharTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.BorrowedArray;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.griffin.engine.table.parquet.PartitionDecoder;
import io.questdb.griffin.engine.table.parquet.RowGroupBuffers;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.DirectBinarySequence;
import io.questdb.std.DirectIntList;
import io.questdb.std.FilesFacade;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectString;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8SplitString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReadParquetRecordCursor
implements NoRandomAccessRecordCursor {
    private static final Log LOG = LogFactory.getLog(ReadParquetRecordCursor.class);
    private final LongList auxPtrs = new LongList();
    private final DirectIntList columns;
    private final LongList dataPtrs = new LongList();
    private final PartitionDecoder decoder;
    private final FilesFacade ff;
    private final RecordMetadata metadata;
    private final ParquetRecord record;
    private final RowGroupBuffers rowGroupBuffers;
    private long addr = 0L;
    private int currentRowInRowGroup;
    private long fd = -1L;
    private long fileSize = 0L;
    private int rowGroupIndex;
    private long rowGroupRowCount;

    public ReadParquetRecordCursor(FilesFacade ff, RecordMetadata metadata) {
        try {
            this.ff = ff;
            this.metadata = metadata;
            this.decoder = new PartitionDecoder();
            this.rowGroupBuffers = new RowGroupBuffers(65);
            this.columns = new DirectIntList(32L, 19);
            this.record = new ParquetRecord(metadata.getColumnCount());
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public static boolean metadataHasChanged(RecordMetadata metadata, PartitionDecoder decoder) {
        if (metadata.getColumnCount() != decoder.metadata().columnCount()) {
            return true;
        }
        int n = metadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            boolean symbolRemappingDetected;
            if (!Chars.equals((CharSequence)metadata.getColumnName(i), decoder.metadata().columnName(i))) {
                return true;
            }
            int metadataType = metadata.getColumnType(i);
            int decoderType = decoder.metadata().getColumnType(i);
            boolean bl = symbolRemappingDetected = metadataType == 26 && decoderType == 12;
            if (symbolRemappingDetected || metadataType == decoderType) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        Misc.free(this.decoder);
        Misc.free(this.rowGroupBuffers);
        Misc.free(this.columns);
        Misc.free(this.record);
        if (this.fd != -1L) {
            this.ff.close(this.fd);
            this.fd = -1L;
        }
        if (this.addr != 0L) {
            this.ff.munmap(this.addr, this.fileSize, 17);
            this.addr = 0L;
        }
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public boolean hasNext() throws DataUnavailableException {
        if ((long)(++this.currentRowInRowGroup) < this.rowGroupRowCount) {
            return true;
        }
        try {
            return this.switchToNextRowGroup();
        }
        catch (CairoException ex) {
            throw CairoException.nonCritical().put("Error reading. Parquet file is likely corrupted");
        }
    }

    public void of(LPSZ path) {
        try {
            this.fd = TableUtils.openRO(this.ff, path, LOG);
            this.fileSize = this.ff.length(this.fd);
            this.addr = TableUtils.mapRO(this.ff, this.fd, this.fileSize, 17);
            this.decoder.of(this.addr, this.fileSize, 65);
            if (ReadParquetRecordCursor.metadataHasChanged(this.metadata, this.decoder)) {
                throw TableReferenceOutOfDateException.of(path);
            }
            this.rowGroupBuffers.reopen();
            this.columns.reopen();
            int n = this.metadata.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.columns.add(i);
                this.columns.add(this.metadata.getColumnType(i));
            }
            this.toTop();
        }
        catch (DataUnavailableException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long preComputedStateSize() {
        return 0L;
    }

    @Override
    public long size() throws DataUnavailableException {
        return this.decoder.metadata().rowCount();
    }

    @Override
    public void toTop() {
        this.rowGroupIndex = -1;
        this.rowGroupRowCount = -1L;
        this.currentRowInRowGroup = -1;
    }

    private long getStrAddr(int col) {
        long auxPtr = this.auxPtrs.get(col);
        long dataPtr = this.dataPtrs.get(col);
        long dataOffset = Unsafe.getUnsafe().getLong(auxPtr + (long)this.currentRowInRowGroup * 8L);
        return dataPtr + dataOffset;
    }

    private boolean switchToNextRowGroup() {
        this.dataPtrs.clear();
        this.auxPtrs.clear();
        if (++this.rowGroupIndex < this.decoder.metadata().rowGroupCount()) {
            int rowGroupSize = this.decoder.metadata().rowGroupSize(this.rowGroupIndex);
            this.rowGroupRowCount = this.decoder.decodeRowGroup(this.rowGroupBuffers, this.columns, this.rowGroupIndex, 0, rowGroupSize);
            int n = this.metadata.getColumnCount();
            for (int columnIndex = 0; columnIndex < n; ++columnIndex) {
                this.dataPtrs.add(this.rowGroupBuffers.getChunkDataPtr(columnIndex));
                this.auxPtrs.add(this.rowGroupBuffers.getChunkAuxPtr(columnIndex));
            }
            this.currentRowInRowGroup = 0;
            return true;
        }
        return false;
    }

    private class ParquetRecord
    implements Record,
    QuietCloseable {
        private final ObjList<BorrowedArray> arrayBuffers;
        private final ObjList<DirectBinarySequence> bsViews;
        private final ObjList<DirectString> csViewsA;
        private final ObjList<DirectString> csViewsB;
        private final ObjList<Long256Impl> longs256A;
        private final ObjList<Long256Impl> longs256B;
        private final ObjList<Utf8SplitString> utf8ViewsA;
        private final ObjList<Utf8SplitString> utf8ViewsB;

        public ParquetRecord(int columnCount) {
            this.bsViews = new ObjList(columnCount);
            this.csViewsA = new ObjList(columnCount);
            this.csViewsB = new ObjList(columnCount);
            this.longs256A = new ObjList(columnCount);
            this.longs256B = new ObjList(columnCount);
            this.utf8ViewsA = new ObjList(columnCount);
            this.utf8ViewsB = new ObjList(columnCount);
            this.arrayBuffers = new ObjList(columnCount);
        }

        @Override
        public void close() {
            Misc.freeObjList(this.arrayBuffers);
        }

        @Override
        public ArrayView getArray(int col, int colType) {
            BorrowedArray array = this.borrowedArray(col);
            long auxPageAddress = ReadParquetRecordCursor.this.auxPtrs.getQuick(col);
            if (auxPageAddress != 0L) {
                long dataPageAddress = ReadParquetRecordCursor.this.dataPtrs.getQuick(col);
                array.of(colType, auxPageAddress, Long.MAX_VALUE, dataPageAddress, Long.MAX_VALUE, ReadParquetRecordCursor.this.currentRowInRowGroup);
            } else {
                array.ofNull();
            }
            return array;
        }

        @Override
        public BinarySequence getBin(int col) {
            long auxPtr = ReadParquetRecordCursor.this.auxPtrs.get(col);
            long dataPtr = ReadParquetRecordCursor.this.dataPtrs.get(col);
            long dataOffset = Unsafe.getUnsafe().getLong(auxPtr + (long)ReadParquetRecordCursor.this.currentRowInRowGroup * 8L);
            long len = Unsafe.getUnsafe().getLong(dataPtr + dataOffset);
            if (len != -1L) {
                return this.bsView(col).of(dataPtr + dataOffset + 8L, len);
            }
            return null;
        }

        @Override
        public long getBinLen(int col) {
            long auxPtr = ReadParquetRecordCursor.this.auxPtrs.get(col);
            long dataPtr = ReadParquetRecordCursor.this.dataPtrs.get(col);
            long dataOffset = Unsafe.getUnsafe().getLong(auxPtr + (long)ReadParquetRecordCursor.this.currentRowInRowGroup * 8L);
            return Unsafe.getUnsafe().getLong(dataPtr + dataOffset);
        }

        @Override
        public boolean getBool(int col) {
            return this.getByte(col) == 1;
        }

        @Override
        public byte getByte(int col) {
            long dataPtr = ReadParquetRecordCursor.this.dataPtrs.get(col);
            return Unsafe.getUnsafe().getByte(dataPtr + (long)ReadParquetRecordCursor.this.currentRowInRowGroup);
        }

        @Override
        public char getChar(int col) {
            long dataPtr = ReadParquetRecordCursor.this.dataPtrs.get(col);
            return Unsafe.getUnsafe().getChar(dataPtr + (long)ReadParquetRecordCursor.this.currentRowInRowGroup * 2L);
        }

        @Override
        public double getDouble(int col) {
            long dataPtr = ReadParquetRecordCursor.this.dataPtrs.get(col);
            return Unsafe.getUnsafe().getDouble(dataPtr + (long)ReadParquetRecordCursor.this.currentRowInRowGroup * 8L);
        }

        @Override
        public float getFloat(int col) {
            long dataPtr = ReadParquetRecordCursor.this.dataPtrs.get(col);
            return Unsafe.getUnsafe().getFloat(dataPtr + (long)ReadParquetRecordCursor.this.currentRowInRowGroup * 4L);
        }

        @Override
        public byte getGeoByte(int col) {
            return this.getByte(col);
        }

        @Override
        public int getGeoInt(int col) {
            return this.getInt(col);
        }

        @Override
        public long getGeoLong(int col) {
            return this.getLong(col);
        }

        @Override
        public short getGeoShort(int col) {
            return this.getShort(col);
        }

        @Override
        public int getIPv4(int col) {
            return this.getInt(col);
        }

        @Override
        public int getInt(int col) {
            long dataPtr = ReadParquetRecordCursor.this.dataPtrs.get(col);
            return Unsafe.getUnsafe().getInt(dataPtr + (long)ReadParquetRecordCursor.this.currentRowInRowGroup * 4L);
        }

        @Override
        public long getLong(int col) {
            long dataPtr = ReadParquetRecordCursor.this.dataPtrs.get(col);
            return Unsafe.getUnsafe().getLong(dataPtr + (long)ReadParquetRecordCursor.this.currentRowInRowGroup * 8L);
        }

        @Override
        public long getLong128Hi(int col) {
            long dataPtr = ReadParquetRecordCursor.this.dataPtrs.get(col);
            return Unsafe.getUnsafe().getLong(dataPtr + (long)ReadParquetRecordCursor.this.currentRowInRowGroup * 16L + 8L);
        }

        @Override
        public long getLong128Lo(int col) {
            long dataPtr = ReadParquetRecordCursor.this.dataPtrs.get(col);
            return Unsafe.getUnsafe().getLong(dataPtr + (long)ReadParquetRecordCursor.this.currentRowInRowGroup * 16L);
        }

        @Override
        public void getLong256(int col, CharSink<?> sink) {
            Numbers.appendLong256FromUnsafe(this.getLong256Addr(col), sink);
        }

        @Override
        public Long256 getLong256A(int col) {
            Long256Impl long256 = this.long256A(col);
            long256.fromAddress(this.getLong256Addr(col));
            return long256;
        }

        @Override
        public Long256 getLong256B(int col) {
            Long256Impl long256 = this.long256B(col);
            long256.fromAddress(this.getLong256Addr(col));
            return long256;
        }

        @Override
        public short getShort(int col) {
            long dataPtr = ReadParquetRecordCursor.this.dataPtrs.get(col);
            return Unsafe.getUnsafe().getShort(dataPtr + (long)ReadParquetRecordCursor.this.currentRowInRowGroup * 2L);
        }

        @Override
        public CharSequence getStrA(int col) {
            return this.getStr(ReadParquetRecordCursor.this.getStrAddr(col), this.csViewA(col));
        }

        @Override
        public CharSequence getStrB(int col) {
            return this.getStr(ReadParquetRecordCursor.this.getStrAddr(col), this.csViewB(col));
        }

        @Override
        public int getStrLen(int col) {
            return Unsafe.getUnsafe().getInt(ReadParquetRecordCursor.this.getStrAddr(col));
        }

        @Override
        @Nullable
        public Utf8Sequence getVarcharA(int col) {
            long auxPtr = ReadParquetRecordCursor.this.auxPtrs.get(col);
            long dataPtr = ReadParquetRecordCursor.this.dataPtrs.get(col);
            return VarcharTypeDriver.getSplitValue(auxPtr, Long.MAX_VALUE, dataPtr, Long.MAX_VALUE, ReadParquetRecordCursor.this.currentRowInRowGroup, this.utf8ViewA(col));
        }

        @Override
        @Nullable
        public Utf8Sequence getVarcharB(int col) {
            long auxPtr = ReadParquetRecordCursor.this.auxPtrs.get(col);
            long dataPtr = ReadParquetRecordCursor.this.dataPtrs.get(col);
            return VarcharTypeDriver.getSplitValue(auxPtr, Long.MAX_VALUE, dataPtr, Long.MAX_VALUE, ReadParquetRecordCursor.this.currentRowInRowGroup, this.utf8ViewB(col));
        }

        @Override
        public int getVarcharSize(int col) {
            long auxPtr = ReadParquetRecordCursor.this.auxPtrs.get(col);
            return VarcharTypeDriver.getValueSize(auxPtr, (long)ReadParquetRecordCursor.this.currentRowInRowGroup);
        }

        @NotNull
        private BorrowedArray borrowedArray(int col) {
            BorrowedArray array = this.arrayBuffers.getQuiet(col);
            if (array != null) {
                return array;
            }
            array = new BorrowedArray();
            this.arrayBuffers.extendAndSet(col, array);
            return array;
        }

        private DirectBinarySequence bsView(int columnIndex) {
            if (this.bsViews.getQuiet(columnIndex) == null) {
                this.bsViews.extendAndSet(columnIndex, new DirectBinarySequence());
            }
            return this.bsViews.getQuick(columnIndex);
        }

        private DirectString csViewA(int columnIndex) {
            if (this.csViewsA.getQuiet(columnIndex) == null) {
                this.csViewsA.extendAndSet(columnIndex, new DirectString());
            }
            return this.csViewsA.getQuick(columnIndex);
        }

        private DirectString csViewB(int columnIndex) {
            if (this.csViewsB.getQuiet(columnIndex) == null) {
                this.csViewsB.extendAndSet(columnIndex, new DirectString());
            }
            return this.csViewsB.getQuick(columnIndex);
        }

        private long getLong256Addr(int col) {
            return ReadParquetRecordCursor.this.dataPtrs.get(col) + (long)ReadParquetRecordCursor.this.currentRowInRowGroup * 32L;
        }

        private DirectString getStr(long addr, DirectString view) {
            assert (addr > 0L);
            int len = Unsafe.getUnsafe().getInt(addr);
            if (len != -1) {
                return view.of(addr + 4L, len);
            }
            return null;
        }

        private Long256Impl long256A(int columnIndex) {
            if (this.longs256A.getQuiet(columnIndex) == null) {
                this.longs256A.extendAndSet(columnIndex, new Long256Impl());
            }
            return this.longs256A.getQuick(columnIndex);
        }

        private Long256Impl long256B(int columnIndex) {
            if (this.longs256B.getQuiet(columnIndex) == null) {
                this.longs256B.extendAndSet(columnIndex, new Long256Impl());
            }
            return this.longs256B.getQuick(columnIndex);
        }

        private Utf8SplitString utf8ViewA(int columnIndex) {
            if (this.utf8ViewsA.getQuiet(columnIndex) == null) {
                this.utf8ViewsA.extendAndSet(columnIndex, new Utf8SplitString());
            }
            return this.utf8ViewsA.getQuick(columnIndex);
        }

        private Utf8SplitString utf8ViewB(int columnIndex) {
            if (this.utf8ViewsB.getQuiet(columnIndex) == null) {
                this.utf8ViewsB.extendAndSet(columnIndex, new Utf8SplitString());
            }
            return this.utf8ViewsB.getQuick(columnIndex);
        }
    }
}

