/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.VarcharFunction;
import io.questdb.griffin.engine.functions.constants.VarcharConstant;
import io.questdb.griffin.engine.functions.str.TrimType;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.DirectUtf8Sink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.Nullable;

public class TrimVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "trim(\u00d8)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.get(0);
        if (!arg.isConstant()) {
            return new Func(args.getQuick(0), this.trimType());
        }
        if (arg.getStrA(null) == null) {
            return VarcharConstant.NULL;
        }
        return new ConstFunc(args.getQuick(0), this.trimType());
    }

    protected TrimType trimType() {
        return TrimType.TRIM;
    }

    private static class Func
    extends VarcharFunction
    implements UnaryFunction {
        private final Function arg;
        private final DirectUtf8Sink sinkA = new DirectUtf8Sink(4L);
        private final DirectUtf8Sink sinkB = new DirectUtf8Sink(4L);
        private final TrimType type;

        public Func(Function arg, TrimType type) {
            this.arg = arg;
            this.type = type;
        }

        @Override
        public void close() {
            UnaryFunction.super.close();
            this.sinkA.close();
            this.sinkB.close();
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public String getName() {
            switch (this.type) {
                case LTRIM: {
                    return "ltrim";
                }
                case RTRIM: {
                    return "rtrim";
                }
            }
            return "trim";
        }

        @Override
        public Utf8Sequence getVarcharA(Record rec) {
            Utf8Sequence utf8Sequence = this.getArg().getVarcharA(rec);
            if (utf8Sequence == null) {
                return null;
            }
            this.sinkA.clear();
            Utf8s.trim(this.type, utf8Sequence, this.sinkA);
            return this.sinkA;
        }

        @Override
        public Utf8Sequence getVarcharB(Record rec) {
            Utf8Sequence charSequence = this.getArg().getVarcharA(rec);
            if (charSequence == null) {
                return null;
            }
            this.sinkB.clear();
            Utf8s.trim(this.type, charSequence, this.sinkB);
            return this.sinkB;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }
    }

    private static class ConstFunc
    extends VarcharFunction
    implements UnaryFunction {
        private final Function arg;
        private final DirectUtf8Sink sink;

        public ConstFunc(Function arg, TrimType type) {
            this.arg = arg;
            Utf8Sequence value = this.getArg().getVarcharA(null);
            if (value == null) {
                this.sink = null;
            } else {
                this.sink = new DirectUtf8Sink(value.size());
                Utf8s.trim(type, value, this.sink);
            }
        }

        @Override
        public void close() {
            UnaryFunction.super.close();
            Misc.free(this.sink);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        @Nullable
        public Utf8Sequence getVarcharA(Record rec) {
            return this.sink;
        }

        @Override
        @Nullable
        public Utf8Sequence getVarcharB(Record rec) {
            return this.sink;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val('\'').val(this.sink).val('\'');
        }
    }
}

