/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.VarcharFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.Nullable;

public class RPadVarcharFunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "rpad(\u00d8I)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function strFunc = args.getQuick(0);
        Function lenFunc = args.getQuick(1);
        int maxLength = configuration.getStrFunctionMaxBufferLength();
        return new RPadFunc(strFunc, lenFunc, maxLength);
    }

    public static class RPadFunc
    extends VarcharFunction
    implements BinaryFunction {
        private final Function lenFunc;
        private final int maxLength;
        private final Utf8StringSink sinkA = new Utf8StringSink();
        private final Utf8StringSink sinkB = new Utf8StringSink();
        private final Function strFunc;

        public RPadFunc(Function strFunc, Function lenFunc, int maxLength) {
            this.strFunc = strFunc;
            this.lenFunc = lenFunc;
            this.maxLength = maxLength;
        }

        @Override
        public Function getLeft() {
            return this.strFunc;
        }

        @Override
        public String getName() {
            return "rpad";
        }

        @Override
        public Function getRight() {
            return this.lenFunc;
        }

        @Override
        public Utf8Sequence getVarcharA(Record rec) {
            return this.rPad(this.strFunc.getVarcharA(rec), this.lenFunc.getInt(rec), this.sinkA);
        }

        @Override
        public Utf8Sequence getVarcharB(Record rec) {
            return this.rPad(this.strFunc.getVarcharB(rec), this.lenFunc.getInt(rec), this.sinkB);
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Nullable
        private Utf8StringSink rPad(Utf8Sequence str, int len, Utf8StringSink sink) {
            if (str != null && len >= 0) {
                if (len > this.maxLength) {
                    throw CairoException.nonCritical().put("breached memory limit set for ").put(RPadVarcharFunctionFactory.SIGNATURE).put(" [maxLength=").put(this.maxLength).put(", requiredLength=").put(len).put(']');
                }
                sink.clear();
                int length = Utf8s.validateUtf8(str);
                if (len > length) {
                    sink.put(str);
                    for (int i = 0; i < len - length; ++i) {
                        sink.put(' ');
                    }
                } else {
                    Utf8s.strCpy(str, length - len, length, sink);
                }
                return sink;
            }
            return null;
        }
    }
}

