/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.groupby.FirstVarcharGroupByFunction;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;

public class LastVarcharGroupByFunction
extends FirstVarcharGroupByFunction {
    public LastVarcharGroupByFunction(@NotNull Function arg) {
        super(arg);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        mapValue.putLong(this.valueIndex, rowId);
        Utf8Sequence val = this.arg.getVarcharA(record);
        if (val == null) {
            mapValue.putLong(this.valueIndex + 1, 0L);
            mapValue.putBool(this.valueIndex + 2, true);
        } else {
            long ptr = mapValue.getLong(this.valueIndex + 1);
            this.sink.of(ptr).clearAndSet(val);
            mapValue.putLong(this.valueIndex + 1, this.sink.colouredPtr());
            mapValue.putBool(this.valueIndex + 2, false);
        }
    }

    @Override
    public String getName() {
        return "last";
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long destRowId;
        long srcRowId = srcValue.getLong(this.valueIndex);
        if (srcRowId > (destRowId = destValue.getLong(this.valueIndex))) {
            destValue.putLong(this.valueIndex, srcRowId);
            destValue.putLong(this.valueIndex + 1, srcValue.getLong(this.valueIndex + 1));
            destValue.putBool(this.valueIndex + 2, srcValue.getBool(this.valueIndex + 2));
        }
    }
}

