/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class FirstIntGroupByFunction
extends IntFunction
implements GroupByFunction,
UnaryFunction {
    protected final Function arg;
    protected int valueIndex;

    public FirstIntGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        mapValue.putLong(this.valueIndex, rowId);
        mapValue.putInt(this.valueIndex + 1, this.arg.getInt(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public int getInt(Record rec) {
        return rec.getInt(this.valueIndex + 1);
    }

    @Override
    public String getName() {
        return "first";
    }

    @Override
    public int getSampleByFlags() {
        return 31;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
        columnTypes.add(5);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return UnaryFunction.super.isThreadSafe();
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long srcRowId = srcValue.getLong(this.valueIndex);
        long destRowId = destValue.getLong(this.valueIndex);
        if (srcRowId != Long.MIN_VALUE && (srcRowId < destRowId || destRowId == Long.MIN_VALUE)) {
            destValue.putLong(this.valueIndex, srcRowId);
            destValue.putInt(this.valueIndex + 1, srcValue.getInt(this.valueIndex + 1));
        }
    }

    @Override
    public void setInt(MapValue mapValue, int value) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
        mapValue.putInt(this.valueIndex + 1, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        this.setInt(mapValue, Integer.MIN_VALUE);
    }

    @Override
    public boolean supportsParallelism() {
        return UnaryFunction.super.supportsParallelism();
    }
}

