/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.CompactUtf8SequenceHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;

public class CountDistinctVarcharGroupByFunction
extends LongFunction
implements UnaryFunction,
GroupByFunction {
    private final Function arg;
    private final int setInitialCapacity;
    private final double setLoadFactor;
    private final ObjList<CompactUtf8SequenceHashSet> sets = new ObjList();
    private int setIndex = 0;
    private int valueIndex;

    public CountDistinctVarcharGroupByFunction(Function arg, int setInitialCapacity, double setLoadFactor) {
        this.arg = arg;
        this.setInitialCapacity = setInitialCapacity;
        this.setLoadFactor = setLoadFactor;
    }

    @Override
    public void clear() {
        this.sets.clear();
        this.setIndex = 0;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        CompactUtf8SequenceHashSet set;
        if (this.sets.size() <= this.setIndex) {
            set = new CompactUtf8SequenceHashSet(this.setInitialCapacity, this.setLoadFactor);
            this.sets.extendAndSet(this.setIndex, set);
        } else {
            set = this.sets.getQuick(this.setIndex);
            set.clear();
        }
        Utf8Sequence val = this.arg.getVarcharA(record);
        if (val != null) {
            set.add(val);
            mapValue.putLong(this.valueIndex, 1L);
        } else {
            mapValue.putLong(this.valueIndex, 0L);
        }
        mapValue.putInt(this.valueIndex + 1, this.setIndex++);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        CompactUtf8SequenceHashSet set = this.sets.getQuick(mapValue.getInt(this.valueIndex + 1));
        Utf8Sequence val = this.arg.getVarcharA(record);
        if (val != null) {
            int index = set.keyIndex(val);
            if (index < 0) {
                return;
            }
            set.addAt(index, val);
            mapValue.addLong(this.valueIndex, 1L);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public long getLong(Record rec) {
        return rec.getLong(this.valueIndex);
    }

    @Override
    public String getName() {
        return "count_distinct";
    }

    @Override
    public int getSampleByFlags() {
        return 31;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
        columnTypes.add(5);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public void setEmpty(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, 0L);
    }

    @Override
    public void setLong(MapValue mapValue, long value) {
        mapValue.putLong(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
    }

    @Override
    public boolean supportsParallelism() {
        return false;
    }

    @Override
    public void toTop() {
        UnaryFunction.super.toTop();
        this.setIndex = 0;
    }
}

