/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.groupby.ApproxPercentileDoubleGroupByFunctionFactory;
import io.questdb.griffin.engine.functions.groupby.ApproxPercentileLongGroupByFunction;
import io.questdb.griffin.engine.functions.groupby.ApproxPercentileLongPackedGroupByFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class ApproxPercentileLongGroupByFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "approx_percentile(LDi)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function exprFunc = args.getQuick(0);
        Function percentileFunc = args.getQuick(1);
        Function precisionFunc = args.getQuick(2);
        ApproxPercentileDoubleGroupByFunctionFactory.checkPercentile(percentileFunc, argPositions.getQuick(1));
        int precision = ApproxPercentileDoubleGroupByFunctionFactory.checkAndReturnPrecision(precisionFunc, argPositions.getQuick(2));
        if (precision > 2) {
            return new ApproxPercentileLongPackedGroupByFunction(exprFunc, percentileFunc, precision, position);
        }
        return new ApproxPercentileLongGroupByFunction(exprFunc, percentileFunc, precision, position);
    }
}

