/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class EqDateFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(MM)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new EqDateFunction(args.getQuick(0), args.getQuick(1));
    }

    private static class EqDateFunction
    extends AbstractEqBinaryFunction {
        public EqDateFunction(Function left, Function right) {
            super(left, right);
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.left.getDate(rec) == this.right.getDate(rec));
        }
    }
}

