/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.date.AbstractGenerateSeriesRecordCursorFactory;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;

public final class GenerateSeriesDoubleRecordCursorFactory
extends AbstractGenerateSeriesRecordCursorFactory {
    private static final RecordMetadata METADATA;
    private GenerateSeriesDoubleRecordCursor cursor;

    public GenerateSeriesDoubleRecordCursorFactory(Function startFunc, Function endFunc, Function stepFunc, IntList argPositions) throws SqlException {
        super(METADATA, startFunc, endFunc, stepFunc, argPositions);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        if (this.cursor == null) {
            this.cursor = new GenerateSeriesDoubleRecordCursor(this.startFunc, this.endFunc, this.stepFunc);
        }
        this.cursor.of(executionContext, this.stepPosition);
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(0, new TableColumnMetadata("generate_series", 10));
        METADATA = metadata;
    }

    private static class GenerateSeriesDoubleRecordCursor
    extends AbstractGenerateSeriesRecordCursorFactory.AbstractGenerateSeriesRecordCursor {
        private final GenerateSeriesDoubleRecord recordA = new GenerateSeriesDoubleRecord();
        private double end;
        private double start;
        private double step;

        public GenerateSeriesDoubleRecordCursor(Function startFunc, Function endFunc, Function stepFunc) {
            super(startFunc, endFunc, stepFunc);
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public boolean hasNext() {
            this.recordA.kahanInc(this.step);
            if (Numbers.isNull(this.recordA.curr)) {
                return false;
            }
            if (this.step >= 0.0) {
                return this.recordA.curr <= this.end;
            }
            return this.recordA.curr >= this.end;
        }

        public void of(SqlExecutionContext executionContext, int stepPosition) throws SqlException {
            super.of(executionContext);
            this.start = this.startFunc.getDouble(null);
            this.end = this.endFunc.getDouble(null);
            this.step = this.stepFunc.getDouble(null);
            if (this.step == 0.0) {
                throw SqlException.$(stepPosition, "step cannot be zero");
            }
            if (this.start <= this.end && this.step < 0.0 || this.start >= this.end && this.step > 0.0) {
                double temp = this.start;
                this.start = this.end;
                this.end = temp;
            }
            this.toTop();
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.recordA.curr = this.start;
            this.recordA.compensation = 0.0;
            this.recordA.kahanInc(-this.step);
        }

        private static class GenerateSeriesDoubleRecord
        implements Record {
            private double compensation;
            private double curr;

            private GenerateSeriesDoubleRecord() {
            }

            @Override
            public double getDouble(int col) {
                return this.curr;
            }

            public void kahanInc(double step) {
                double y = step - this.compensation;
                double t = this.curr + y;
                this.compensation = t - this.curr - y;
                this.curr = t;
            }
        }
    }
}

