/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IPv4Function;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class NullIfIPv4FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "nullif(XS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new NullIfIPv4Function(args.getQuick(0), args.getQuick(1));
    }

    private static class NullIfIPv4Function
    extends IPv4Function
    implements BinaryFunction {
        private final Function arg1;
        private final Function arg2;

        public NullIfIPv4Function(Function arg1, Function arg2) {
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        @Override
        public int getIPv4(Record rec) {
            return this.arg1.getIPv4(rec) == this.arg2.getIPv4(rec) ? 0 : this.arg1.getIPv4(rec);
        }

        @Override
        public Function getLeft() {
            return this.arg1;
        }

        @Override
        public Function getRight() {
            return this.arg2;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("nullif(").val(this.arg1).val(',').val(this.arg2).val(')');
        }
    }
}

