/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cutlass.http.processors.WarningsProcessor;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class SimulateWarningsFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "simulate_warnings(SS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        if (configuration.isDevModeEnabled()) {
            String tag = args.get(0).getStrA(null).toString();
            String warning = args.get(1).getStrA(null).toString();
            return new SimulateWarningsFunction(tag, warning);
        }
        return BooleanConstant.FALSE;
    }

    private static class SimulateWarningsFunction
    extends BooleanFunction {
        final String tag;
        final String warning;

        SimulateWarningsFunction(String tag, String warning) {
            this.tag = tag;
            this.warning = warning;
        }

        @Override
        public boolean getBool(Record rec) {
            WarningsProcessor.override(this.tag, this.warning);
            return true;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            executionContext.getSecurityContext().authorizeSystemAdmin();
            super.init(symbolTableSource, executionContext);
        }

        @Override
        public boolean isThreadSafe() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("simulate_warnings(").val(this.tag).val(", ").val(this.warning).val(")");
        }
    }
}

