/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToIPv4Function;
import io.questdb.griffin.engine.functions.constants.IPv4Constant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastIntToIPv4FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Ix)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            int value = arg.getInt(null);
            if (value == Integer.MIN_VALUE) {
                return IPv4Constant.NULL;
            }
            return IPv4Constant.newInstance(value);
        }
        return new Func(arg);
    }

    private static class Func
    extends AbstractCastToIPv4Function {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public int getIPv4(Record rec) {
            if (this.arg.getInt(rec) == Integer.MIN_VALUE) {
                return 0;
            }
            return this.arg.getInt(rec);
        }
    }
}

