/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DirectArray;
import io.questdb.cairo.arr.FlatArrayView;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class DoubleArrayCumSumFunctionFactory
implements FunctionFactory {
    private static final String FUNCTION_NAME = "array_cum_sum";

    @Override
    public String getSignature() {
        return "array_cum_sum(D[])";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new Func(args.getQuick(0), configuration);
    }

    private static class Func
    extends ArrayFunction
    implements UnaryFunction {
        private final DirectArray array;
        private final Function arrayArg;
        private double compensation = 0.0;
        private double currentSum;
        private MemoryA memory;

        public Func(Function arrayArg, CairoConfiguration configuration) {
            this.arrayArg = arrayArg;
            this.type = ColumnType.encodeArrayType((short)10, 1);
            this.array = new DirectArray(configuration);
        }

        @Override
        public void close() {
            UnaryFunction.super.close();
            Misc.free(this.array);
        }

        @Override
        public Function getArg() {
            return this.arrayArg;
        }

        @Override
        public ArrayView getArray(Record rec) {
            ArrayView arr = this.arrayArg.getArray(rec);
            if (arr.isNull()) {
                this.array.ofNull();
                return this.array;
            }
            this.currentSum = Double.NaN;
            this.compensation = 0.0;
            this.array.setType(this.getType());
            this.array.setDimLen(0, arr.getCardinality());
            this.array.applyShape();
            this.memory = this.array.startMemoryA();
            if (arr.isNull()) {
                this.array.ofNull();
            } else if (arr.isVanilla()) {
                FlatArrayView flatView = arr.flatView();
                int n = arr.getHi();
                for (int i = arr.getLo(); i < n; ++i) {
                    this.accumulate(flatView.getDoubleAtAbsIndex(i));
                }
                if (this.compensation == 0.0 && Numbers.isNull(this.currentSum)) {
                    this.array.ofNull();
                }
            } else {
                this.calculateRecursive(arr, 0, 0);
            }
            if (this.compensation == 0.0 && Numbers.isNull(this.currentSum)) {
                this.array.ofNull();
            }
            return this.array;
        }

        @Override
        public String getName() {
            return DoubleArrayCumSumFunctionFactory.FUNCTION_NAME;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        private void accumulate(double v) {
            if (Numbers.isFinite(v)) {
                if (this.compensation == 0.0 && Numbers.isNull(this.currentSum)) {
                    this.currentSum = 0.0;
                }
                double y = v - this.compensation;
                double t = this.currentSum + y;
                this.compensation = t - this.currentSum - y;
                this.currentSum = t;
            }
            this.memory.putDouble(this.currentSum);
        }

        private void calculateRecursive(ArrayView view, int dim, int flatIndex) {
            boolean atDeepestDim;
            int count = view.getDimLen(dim);
            int stride = view.getStride(dim);
            boolean bl = atDeepestDim = dim == view.getDimCount() - 1;
            if (atDeepestDim) {
                for (int i = 0; i < count; ++i) {
                    this.accumulate(view.getDouble(flatIndex));
                    flatIndex += stride;
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    this.calculateRecursive(view, dim + 1, flatIndex);
                    flatIndex += stride;
                }
            }
        }
    }
}

