/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.activity;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.QueryRegistry;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CancelQueryFunctionFactory
implements FunctionFactory {
    private static final String NAME = "cancel_query";
    private static final String SIGNATURE = "cancel_query(L)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (args.get(0).isConstant() && args.get(0).getLong(null) < 0L) {
            throw SqlException.$(argPositions.getQuick(0), "non-negative integer literal expected as query id");
        }
        return new Func(sqlExecutionContext.getCairoEngine().getQueryRegistry(), args.getQuick(0), position);
    }

    private static class Func
    extends BooleanFunction {
        private final int position;
        private final Function queryIdFunc;
        private final QueryRegistry queryRegistry;
        private SqlExecutionContext executionContext;

        public Func(QueryRegistry queryRegistry, Function queryIdFunc, int position) {
            this.queryRegistry = queryRegistry;
            this.queryIdFunc = queryIdFunc;
            this.position = position;
        }

        @Override
        public boolean getBool(Record rec) {
            long queryId = this.queryIdFunc.getLong(rec);
            if (queryId < 0L) {
                return false;
            }
            try {
                return this.queryRegistry.cancel(queryId, this.executionContext);
            }
            catch (CairoException e) {
                e.position(this.position);
                throw e;
            }
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            this.executionContext = executionContext;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(CancelQueryFunctionFactory.NAME).val('(').val(this.queryIdFunc).val(')');
        }
    }
}

