/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.pool.ReaderPool;
import io.questdb.cairo.pool.ResourcePoolSupervisor;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.TimeFrameRecordCursor;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.QueryRegistry;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.metrics.QueryTrace;
import io.questdb.mp.SCSequence;
import io.questdb.std.Chars;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryProgress
extends AbstractRecordCursorFactory
implements ResourcePoolSupervisor<ReaderPool.R> {
    private static Log LOG = LogFactory.getLog(QueryProgress.class);
    private final RecordCursorFactory base;
    private final RegisteredRecordCursor cursor;
    private final boolean jit;
    private final QueryTrace queryTrace = new QueryTrace();
    private final ObjList<TableReader> readers = new ObjList();
    private final QueryRegistry registry;
    private long beginNanos;
    private SqlExecutionContext executionContext;
    private long sqlId;

    public QueryProgress(QueryRegistry registry, CharSequence sqlText, RecordCursorFactory base) {
        super(base.getMetadata());
        this.base = base;
        this.registry = registry;
        this.cursor = new RegisteredRecordCursor();
        this.jit = base.usesCompiledFilter();
        this.queryTrace.queryText = Chars.toString(sqlText);
    }

    public static void logEnd(long sqlId, @NotNull CharSequence sqlText, @NotNull SqlExecutionContext executionContext, long beginNanos) {
        QueryProgress.logEnd(sqlId, sqlText, executionContext, beginNanos, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logEnd(long sqlId, @NotNull CharSequence sqlText, @NotNull SqlExecutionContext executionContext, long beginNanos, @Nullable ObjList<TableReader> leakedReaders, @Nullable QueryTrace queryTrace) {
        if (!executionContext.shouldLogSql()) {
            return;
        }
        CairoEngine engine = executionContext.getCairoEngine();
        CairoConfiguration config = engine.getConfiguration();
        long durationNanos = config.getNanosecondClock().getTicks() - beginNanos;
        boolean isJit = executionContext.getJitMode() != 2;
        CharSequence principal = executionContext.getSecurityContext().getPrincipal();
        LogRecord log = null;
        try {
            int leakedReadersCount;
            int n = leakedReadersCount = leakedReaders != null ? leakedReaders.size() : 0;
            if (leakedReadersCount > 0) {
                log = LOG.errorW();
                executionContext.getCairoEngine().getMetrics().healthMetrics().incrementReaderLeakCounter(leakedReadersCount);
                log.$("brk");
            } else {
                log = LOG.info();
                log.$("fin");
            }
            log.$(" [id=").$(sqlId).$(", sql=`").$safe(sqlText).$("`, ").$(executionContext).$(", jit=").$(isJit).$(", time=").$(durationNanos);
            QueryProgress.appendLeakedReaderNames(leakedReaders, leakedReadersCount, log);
        }
        catch (Throwable e) {
            System.err.print("could not log exception message");
            e.printStackTrace(System.err);
        }
        finally {
            if (log != null) {
                log.I$();
            }
        }
        if (queryTrace != null && engine.getConfiguration().isQueryTracingEnabled()) {
            queryTrace.executionNanos = durationNanos;
            queryTrace.isJit = isJit;
            queryTrace.timestamp = config.getMicrosecondClock().getTicks();
            queryTrace.principal = principal.toString();
            engine.getMessageBus().getQueryTraceQueue().enqueue(queryTrace);
        }
    }

    public static void logError(@Nullable Throwable e, long sqlId, @NotNull CharSequence sqlText, @NotNull SqlExecutionContext executionContext, long beginNanos) {
        QueryProgress.logError(e, sqlId, sqlText, executionContext, beginNanos, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logError(@Nullable Throwable e, long sqlId, @NotNull CharSequence sqlText, @NotNull SqlExecutionContext executionContext, long beginNanos, @Nullable ObjList<TableReader> leakedReaders) {
        int leakedReadersCount = leakedReaders != null ? leakedReaders.size() : 0;
        LogRecord log = null;
        try {
            executionContext.getCairoEngine().getMetrics().healthMetrics().incrementQueryErrorCounter();
            long durationNanos = executionContext.getCairoEngine().getConfiguration().getNanosecondClock().getTicks() - beginNanos;
            log = LOG.errorW();
            if (leakedReadersCount > 0) {
                log.$("brk");
                executionContext.getCairoEngine().getMetrics().healthMetrics().incrementReaderLeakCounter(leakedReadersCount);
            } else {
                log.$("err");
            }
            if (e instanceof FlyweightMessageContainer) {
                int pos = ((FlyweightMessageContainer)((Object)e)).getPosition();
                int errno = e instanceof CairoException ? ((CairoException)e).getErrno() : 0;
                CharSequence message = ((FlyweightMessageContainer)((Object)e)).getFlyweightMessage();
                log.$(" [id=").$(sqlId).$(", sql=`").$safe(sqlText).$("`, ").$(executionContext).$(", jit=").$(executionContext.getJitMode() != 2).$(", time=").$(durationNanos).$(", msg=").$safe(message).$(", errno=").$(errno).$(", pos=").$(pos);
            } else {
                log.$(" [id=").$(sqlId).$(", sql=`").$safe(sqlText).$("`, ").$(executionContext).$(", jit=").$(executionContext.getJitMode() != 2).$(", time=").$(durationNanos).$(", exception=").$(e);
            }
            QueryProgress.appendLeakedReaderNames(leakedReaders, leakedReadersCount, log);
        }
        catch (Throwable th) {
            System.err.print("Could not log exception message! ");
            th.printStackTrace(System.err);
        }
        finally {
            if (log != null) {
                log.I$();
            }
        }
    }

    public static void logStart(long sqlId, @NotNull CharSequence sqlText, @NotNull SqlExecutionContext executionContext, boolean jit) {
        if (executionContext.shouldLogSql() && executionContext.getCairoEngine().getConfiguration().getLogSqlQueryProgressExe()) {
            LOG.info().$("exe").$(" [id=").$(sqlId).$(", sql=`").$safe(sqlText).$("`, ").$(executionContext).$(", jit=").$(jit).I$();
        }
    }

    @Override
    public PageFrameSequence<?> execute(SqlExecutionContext executionContext, SCSequence collectSubSeq, int order) throws SqlException {
        return this.base.execute(executionContext, collectSubSeq, order);
    }

    @Override
    public boolean followedLimitAdvice() {
        return this.base.followedLimitAdvice();
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.base.followedOrderByAdvice();
    }

    @Override
    public boolean fragmentedSymbolTables() {
        return this.base.fragmentedSymbolTables();
    }

    @Override
    public String getBaseColumnName(int idx) {
        return this.base.getBaseColumnName(idx);
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        if (!this.cursor.isOpen) {
            this.executionContext = executionContext;
            String sqlText = this.queryTrace.queryText;
            this.sqlId = this.registry.register(sqlText, executionContext);
            this.beginNanos = executionContext.getCairoEngine().getConfiguration().getNanosecondClock().getTicks();
            QueryProgress.logStart(this.sqlId, sqlText, executionContext, this.jit);
            try {
                executionContext.getCairoEngine().configureThreadLocalReaderPoolSupervisor(this);
                RecordCursor baseCursor = this.base.getCursor(executionContext);
                executionContext.getCairoEngine().removeThreadLocalReaderPoolSupervisor();
                this.cursor.of(baseCursor);
            }
            catch (Throwable th) {
                executionContext.getCairoEngine().removeThreadLocalReaderPoolSupervisor();
                this.cursor.close0(th);
                throw th;
            }
        }
        return this.cursor;
    }

    @Override
    public PageFrameCursor getPageFrameCursor(SqlExecutionContext executionContext, int order) throws SqlException {
        return this.base.getPageFrameCursor(executionContext, order);
    }

    @Override
    public int getScanDirection() {
        return this.base.getScanDirection();
    }

    @Override
    public TableToken getTableToken() {
        return this.base.getTableToken();
    }

    @Override
    public TimeFrameRecordCursor getTimeFrameCursor(SqlExecutionContext executionContext) throws SqlException {
        return this.base.getTimeFrameCursor(executionContext);
    }

    @Override
    public boolean implementsLimit() {
        return this.base.implementsLimit();
    }

    @Override
    public void onResourceBorrowed(ReaderPool.R resource) {
        assert (resource.getSupervisor() != null);
        this.readers.add(resource);
    }

    @Override
    public void onResourceReturned(ReaderPool.R resource) {
        int index = this.readers.remove(resource);
        if (index < 0 && this.cursor.isOpen) {
            LOG.critical().$("returned reader is not in supervisor's list [tableName=").$(resource.getTableToken().getTableName()).I$();
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    @Override
    public boolean supportsPageFrameCursor() {
        return this.base.supportsPageFrameCursor();
    }

    @Override
    public boolean supportsTimeFrameCursor() {
        return this.base.supportsTimeFrameCursor();
    }

    @Override
    public boolean supportsUpdateRowId(TableToken tableName) {
        return this.base.supportsUpdateRowId(tableName);
    }

    @Override
    public void toPlan(PlanSink sink) {
        this.base.toPlan(sink);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    private static void appendLeakedReaderNames(ObjList<TableReader> leakedReaders, int leakedReadersCount, LogRecord log) {
        for (int i = 0; i < leakedReadersCount; ++i) {
            log.$(", leaked=").$(leakedReaders.getQuick(i).getTableToken().getTableName());
        }
    }

    @Override
    protected void _close() {
        this.cursor.close();
        this.base.close();
    }

    class RegisteredRecordCursor
    implements RecordCursor {
        private RecordCursor base;
        private boolean isOpen = false;

        RegisteredRecordCursor() {
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            this.base.calculateSize(circuitBreaker, counter);
        }

        @Override
        public void close() {
            this.close0(null);
        }

        @Override
        public Record getRecord() {
            return this.base.getRecord();
        }

        @Override
        public Record getRecordB() {
            return this.base.getRecordB();
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.base.getSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() throws DataUnavailableException {
            try {
                return this.base.hasNext();
            }
            catch (DataUnavailableException e) {
                throw e;
            }
            catch (Throwable e) {
                this.close0(e);
                throw e;
            }
        }

        @Override
        public boolean isUsingIndex() {
            return this.base.isUsingIndex();
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.base.newSymbolTable(columnIndex);
        }

        public void of(RecordCursor cursor) {
            this.base = cursor;
            this.isOpen = true;
        }

        @Override
        public long preComputedStateSize() {
            return this.base.preComputedStateSize();
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.base.recordAt(record, atRowId);
        }

        @Override
        public long size() throws DataUnavailableException {
            return this.base.size();
        }

        @Override
        public void skipRows(RecordCursor.Counter rowCount) throws DataUnavailableException {
            this.base.skipRows(rowCount);
        }

        @Override
        public void toTop() {
            this.base.toTop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close0(@Nullable Throwable th) {
            try {
                if (this.isOpen) {
                    this.isOpen = false;
                    this.base = Misc.free(this.base);
                }
            }
            catch (Throwable th0) {
                LOG.critical().$("could not close record cursor").$(" [id=").$(QueryProgress.this.sqlId).$(", sql=`").$safe(QueryProgress.this.queryTrace.queryText).$(", error=").$(th0).I$();
            }
            finally {
                if (QueryProgress.this.executionContext != null) {
                    try {
                        String sqlText = QueryProgress.this.queryTrace.queryText;
                        if (th == null) {
                            QueryProgress.logEnd(QueryProgress.this.sqlId, sqlText, QueryProgress.this.executionContext, QueryProgress.this.beginNanos, QueryProgress.this.readers, QueryProgress.this.queryTrace);
                        } else {
                            QueryProgress.logError(th, QueryProgress.this.sqlId, sqlText, QueryProgress.this.executionContext, QueryProgress.this.beginNanos, QueryProgress.this.readers);
                        }
                    }
                    finally {
                        QueryProgress.this.registry.unregister(QueryProgress.this.sqlId, QueryProgress.this.executionContext);
                        if (QueryProgress.this.executionContext.getCairoEngine().getConfiguration().freeLeakedReaders()) {
                            Misc.freeObjListAndClear(QueryProgress.this.readers);
                        } else {
                            QueryProgress.this.readers.clear();
                        }
                        QueryProgress.this.executionContext = null;
                    }
                }
            }
        }
    }
}

