/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.SecurityContext;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Worker;
import io.questdb.std.Chars;
import io.questdb.std.ConcurrentLongHashMap;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.ThreadLocal;
import io.questdb.std.WeakMutableObjectPool;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.StringSink;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class QueryRegistry {
    private static final Log LOG = LogFactory.getLog(QueryRegistry.class);
    private final MicrosecondClock clock;
    private final AtomicLong idSeq = new AtomicLong();
    private final ConcurrentLongHashMap<Entry> registry = new ConcurrentLongHashMap();
    private final ThreadLocal<WeakMutableObjectPool<Entry>> tlQueryPool;
    private volatile Listener listener;

    public QueryRegistry(CairoConfiguration configuration) {
        this.clock = configuration.getMicrosecondClock();
        this.tlQueryPool = new ThreadLocal<WeakMutableObjectPool>(() -> new WeakMutableObjectPool<Entry>(Entry::new, configuration.getQueryRegistryPoolSize()));
    }

    public boolean cancel(long queryId, SqlExecutionContext executionContext) throws CairoException {
        SecurityContext securityContext = executionContext.getSecurityContext();
        if (!securityContext.isQueryCancellationAllowed()) {
            throw CairoException.nonCritical().put("Query cancellation is disabled");
        }
        Entry entry = this.registry.get(queryId);
        if (entry != null) {
            if (!Chars.equals(entry.principal, securityContext.getPrincipal())) {
                securityContext.authorizeSqlEngineAdmin();
            }
            if (entry.isWAL) {
                throw CairoException.nonCritical().put("query applied in WAL job can't be cancelled [id=").put(queryId).put(']');
            }
            entry.cancel();
            entry.changedAtNs = this.clock.getTicks();
            entry.state = (byte)3;
            LOG.info().$("cancelling query [user=").$(securityContext.getPrincipal()).$(",queryId=").$(queryId).$(",sql=").$(entry.query).I$();
            return true;
        }
        LOG.info().$("query not found in registry [id=").$(queryId).I$();
        return false;
    }

    public Entry getEntry(long id) {
        return this.registry.get(id);
    }

    public void getEntryIds(@NotNull LongList target) {
        target.clear();
        ConcurrentLongHashMap.KeyIterator<Entry> iterator = this.registry.keySet().iterator();
        while (iterator.hasNext()) {
            target.add(iterator.next());
        }
    }

    public long register(CharSequence query, SqlExecutionContext executionContext) {
        long queryId = this.idSeq.getAndIncrement();
        Entry e = (Entry)this.tlQueryPool.get().pop();
        e.clear();
        e.changedAtNs = e.registeredAtNs = this.clock.getTicks();
        e.state = (byte)2;
        if (executionContext.containsSecret()) {
            e.query.put("<SECRET>");
        } else {
            e.query.put(query);
        }
        Thread thread = Thread.currentThread();
        if (thread instanceof Worker) {
            Worker worker = (Worker)thread;
            e.workerId = worker.getWorkerId();
            e.poolName = worker.getPoolName();
        }
        e.isWAL = executionContext.isWalApplication();
        e.principal = executionContext.getSecurityContext().getPrincipal();
        this.registry.put(queryId, e);
        Listener listener = this.listener;
        if (listener != null) {
            listener.onRegister(query, queryId, executionContext);
        }
        executionContext.setCancelledFlag(e.cancelled);
        return queryId;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void unregister(long queryId, SqlExecutionContext executionContext) {
        if (queryId < 0L) {
            return;
        }
        executionContext.setCancelledFlag(null);
        Entry e = this.registry.remove(queryId);
        if (e != null) {
            this.tlQueryPool.get().push(e);
        } else {
            LOG.error().$("query to unregister not found [id=").$(queryId).I$();
        }
    }

    public static class Entry
    implements Mutable {
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private final StringSink query = new StringSink();
        private long changedAtNs;
        private boolean isWAL;
        private CharSequence poolName;
        private CharSequence principal;
        private long registeredAtNs;
        private byte state;
        private long workerId;

        public void cancel() {
            this.cancelled.set(true);
        }

        @Override
        public void clear() {
            this.query.clear();
            this.registeredAtNs = 0L;
            this.changedAtNs = 0L;
            this.cancelled.set(false);
            this.poolName = null;
            this.workerId = -1L;
            this.principal = null;
            this.state = 1;
            this.isWAL = false;
        }

        public AtomicBoolean getCancelled() {
            return this.cancelled;
        }

        public long getChangedAtNs() {
            return this.changedAtNs;
        }

        public CharSequence getPoolName() {
            return this.poolName;
        }

        public CharSequence getPrincipal() {
            return this.principal;
        }

        public StringSink getQuery() {
            return this.query;
        }

        public long getRegisteredAtNs() {
            return this.registeredAtNs;
        }

        public byte getState() {
            return this.state;
        }

        public String getStateText() {
            return State.getText(this.state);
        }

        public long getWorkerId() {
            return this.workerId;
        }

        public boolean isWAL() {
            return this.isWAL;
        }

        public static class State {
            public static final byte ACTIVE = 2;
            public static final byte CANCELLED = 3;
            public static final byte IDLE = 1;

            private State() {
            }

            public static String getText(byte state) {
                switch (state) {
                    case 1: {
                        return "idle";
                    }
                    case 2: {
                        return "active";
                    }
                    case 3: {
                        return "cancelled";
                    }
                }
                return "unknown state";
            }
        }
    }

    public static interface Listener {
        public void onRegister(CharSequence var1, long var2, SqlExecutionContext var4);
    }
}

