/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.log.Log;
import io.questdb.mp.MPSequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.str.Path;
import io.questdb.tasks.ColumnPurgeTask;

public final class PurgingOperator {
    public static final long TABLE_ROOT_PARTITION = -9223372036854775807L;
    private final LongList cleanupColumnVersions = new LongList();
    private final ObjList<String> columnNames = new ObjList();
    private final FilesFacade ff;
    private final Log log;
    private final MessageBus messageBus;
    private final IntList updateColumnIndexes = new IntList();

    public PurgingOperator(Log log, CairoConfiguration configuration, MessageBus messageBus) {
        this.log = log;
        this.messageBus = messageBus;
        this.ff = configuration.getFilesFacade();
    }

    public void add(int columnIndex, String columnName, int columnType, boolean isIndexed, long columnVersion, long partitionTimestamp, long partitionNameTxn) {
        this.updateColumnIndexes.add(columnIndex);
        this.updateColumnIndexes.add(columnType);
        this.updateColumnIndexes.add(isIndexed ? 1 : 0);
        this.updateColumnIndexes.add(this.columnNames.size());
        this.columnNames.add(columnName);
        this.cleanupColumnVersions.add(columnIndex, columnVersion, partitionTimestamp, partitionNameTxn);
    }

    public void clear() {
        this.updateColumnIndexes.clear();
        this.cleanupColumnVersions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(Path path, TableToken tableToken, int partitionBy, boolean asyncOnly, long truncateVersion, long txn) {
        int rootLen = path.size();
        try {
            int cleanupVersionSize = this.cleanupColumnVersions.size();
            int lastColumnIndex = -1;
            int intsPerEntry = 4;
            this.updateColumnIndexes.sortGroups(4);
            int nn = this.updateColumnIndexes.size();
            for (int updatedCol = 0; updatedCol < nn; updatedCol += 4) {
                int processColumnIndex = this.updateColumnIndexes.getQuick(updatedCol);
                if (processColumnIndex == lastColumnIndex) continue;
                lastColumnIndex = processColumnIndex;
                int columnType = this.updateColumnIndexes.getQuick(updatedCol + 1);
                boolean isIndexed = this.updateColumnIndexes.getQuick(updatedCol + 2) == 1;
                int colNameIndex = this.updateColumnIndexes.getQuick(updatedCol + 3);
                String columnName = this.columnNames.getQuick(colNameIndex);
                for (int i = 0; i < cleanupVersionSize; i += 4) {
                    boolean columnPurged;
                    int columnIndex = (int)this.cleanupColumnVersions.getQuick(i);
                    long columnVersion = this.cleanupColumnVersions.getQuick(i + 1);
                    long partitionTimestamp = this.cleanupColumnVersions.getQuick(i + 2);
                    long partitionNameTxn = this.cleanupColumnVersions.getQuick(i + 3);
                    if (columnIndex != processColumnIndex) continue;
                    boolean bl = columnPurged = !asyncOnly;
                    if (!asyncOnly) {
                        if (partitionTimestamp != -9223372036854775807L) {
                            path.trimTo(rootLen);
                            TableUtils.setPathForNativePartition(path, partitionBy, partitionTimestamp, partitionNameTxn);
                            int pathPartitionLen = path.size();
                            TableUtils.dFile(path, columnName, columnVersion);
                            columnPurged = this.ff.removeQuiet(path.$());
                            if (ColumnType.isVarSize(columnType)) {
                                TableUtils.iFile(path.trimTo(pathPartitionLen), columnName, columnVersion);
                                columnPurged &= this.ff.removeQuiet(path.$());
                            }
                            if (isIndexed) {
                                BitmapIndexUtils.valueFileName(path.trimTo(pathPartitionLen), columnName, columnVersion);
                                columnPurged &= this.ff.removeQuiet(path.$());
                                BitmapIndexUtils.keyFileName(path.trimTo(pathPartitionLen), columnName, columnVersion);
                                columnPurged &= this.ff.removeQuiet(path.$());
                            }
                        } else {
                            TableUtils.charFileName(path.trimTo(rootLen), columnName, columnVersion);
                            columnPurged = this.ff.removeQuiet(path.$());
                            TableUtils.offsetFileName(path.trimTo(rootLen), columnName, columnVersion);
                            columnPurged &= this.ff.removeQuiet(path.$());
                            BitmapIndexUtils.keyFileName(path.trimTo(rootLen), columnName, columnVersion);
                            columnPurged &= this.ff.removeQuiet(path.$());
                            BitmapIndexUtils.valueFileName(path.trimTo(rootLen), columnName, columnVersion);
                            columnPurged &= this.ff.removeQuiet(path.$());
                        }
                    }
                    if (columnPurged) continue;
                    this.cleanupColumnVersions.add(columnVersion, partitionTimestamp, partitionNameTxn, 0L);
                }
                if (this.cleanupColumnVersions.size() > cleanupVersionSize) {
                    this.purgeColumnVersionAsync(tableToken, columnName, tableToken.getTableId(), (int)truncateVersion, columnType, partitionBy, txn, this.cleanupColumnVersions, cleanupVersionSize, this.cleanupColumnVersions.size());
                    this.cleanupColumnVersions.setPos(cleanupVersionSize);
                    this.log.info().$("column purge scheduled [table=").$safe(tableToken.getTableName()).$(", column=").$safe(columnName).$(", updateTxn=").$(txn).I$();
                    continue;
                }
                this.log.info().$("column purge complete [table=").$safe(tableToken.getTableName()).$(", column=").$safe(columnName).$(", newColumnVersion=").$(txn - 1L).I$();
            }
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    private void purgeColumnVersionAsync(TableToken tableName, String columnName, int tableId, int tableTruncateVersion, int columnType, int partitionBy, long updateTxn, LongList columnVersions, int columnVersionsLo, int columnVersionsHi) {
        MPSequence pubSeq = this.messageBus.getColumnPurgePubSeq();
        while (true) {
            long cursor;
            if ((cursor = pubSeq.next()) > -1L) {
                ColumnPurgeTask task = this.messageBus.getColumnPurgeQueue().get(cursor);
                task.of(tableName, columnName, tableId, tableTruncateVersion, columnType, partitionBy, updateTxn, columnVersions, columnVersionsLo, columnVersionsHi);
                pubSeq.done(cursor);
                return;
            }
            if (cursor == -1L) {
                this.log.error().$("cannot schedule column purge, purge queue is full. Please run 'VACUUM TABLE \"").$safe(tableName.getTableName()).$("\"' [columnName=").$safe(columnName).$(", updateTxn=").$(updateTxn).I$();
                return;
            }
            Os.pause();
        }
    }
}

