/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.cutlass.text.types.TimestampCompatibleAdapter;
import io.questdb.griffin.SqlKeywords;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.DirectUtf8Sequence;

public final class IntAdapter
extends AbstractTypeAdapter
implements TimestampCompatibleAdapter {
    public static final IntAdapter INSTANCE = new IntAdapter();

    private IntAdapter() {
    }

    @Override
    public long getTimestamp(DirectUtf8Sequence value) throws Exception {
        return this.parseInt(value);
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public boolean probe(DirectUtf8Sequence text) {
        if (text.size() > 2 && text.byteAt(0) == 48 && text.byteAt(1) != 46) {
            return false;
        }
        try {
            Numbers.parseInt(text);
            return true;
        }
        catch (NumericException e) {
            return false;
        }
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectUtf8Sequence value) throws Exception {
        row.putInt(column, SqlKeywords.isNullKeyword(value) ? Integer.MIN_VALUE : this.parseInt(value));
    }

    private int parseInt(DirectUtf8Sequence value) throws NumericException {
        return Numbers.parseInt(value);
    }
}

