/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.FlatArrayView;
import io.questdb.cairo.arr.MutableArray;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.cutlass.pgwire.PGMessageProcessingException;
import io.questdb.cutlass.pgwire.PGPipelineEntry;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;

final class PGNonNullBinaryArrayView
extends MutableArray
implements FlatArrayView,
Mutable {
    private long hi;
    private long lo;

    public PGNonNullBinaryArrayView() {
        this.isVanilla = false;
        this.flatViewLength = 1;
        this.flatView = this;
    }

    @Override
    public void appendToMemFlat(MemoryA mem, int offset, int length) {
        switch (ColumnType.decodeArrayElementType(this.type)) {
            case 6: 
            case 10: {
                for (int i = 0; i < length; ++i) {
                    mem.putLong(this.getLong(i));
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("not implemented yet");
            }
        }
    }

    @Override
    public void clear() {
        this.shape.clear();
        this.strides.clear();
        this.flatViewLength = 1;
        this.lo = 0L;
        this.hi = 0L;
        this.type = 0;
    }

    @Override
    public double getDoubleAtAbsIndex(int flatIndex) {
        long addr = this.lo + 4L + (long)flatIndex * 12L;
        assert (addr < this.hi);
        long networkOrderVal = Unsafe.getUnsafe().getLong(addr);
        return Double.longBitsToDouble(Numbers.bswap(networkOrderVal));
    }

    @Override
    public long getLongAtAbsIndex(int flatIndex) {
        long addr = this.lo + 4L + (long)flatIndex * 12L;
        assert (addr < this.hi);
        long networkOrderVal = Unsafe.getUnsafe().getLong(addr);
        return Numbers.bswap(networkOrderVal);
    }

    @Override
    public int length() {
        return this.flatViewLength;
    }

    void addDimLen(int dimLen) {
        this.shape.add(dimLen);
        this.flatViewLength *= dimLen;
    }

    void setPtrAndCalculateStrides(long lo, long hi, int pgOidType, PGPipelineEntry pipelineEntry) throws PGMessageProcessingException {
        int expectedElementSize;
        short componentNativeType;
        assert (this.shape.size() > 0);
        switch (pgOidType) {
            case 20: {
                componentNativeType = 6;
                expectedElementSize = 8;
                break;
            }
            case 701: {
                componentNativeType = 10;
                expectedElementSize = 8;
                break;
            }
            default: {
                throw CairoException.nonCritical().put("unsupported array type, only arrays of int8 and float8 are supported [pgOid=").put(pgOidType).put(']');
            }
        }
        int increment = 4 + expectedElementSize;
        int expectedElementSizeBE = Numbers.bswap(expectedElementSize);
        for (long p = lo; p < hi; p += (long)increment) {
            int actualElementSizeBE = Unsafe.getUnsafe().getInt(p);
            if (actualElementSizeBE == -1) {
                throw CairoException.nonCritical().put("null elements are not supported in arrays");
            }
            if (actualElementSizeBE == expectedElementSizeBE) continue;
            int actualElementSize = Numbers.bswap(actualElementSizeBE);
            throw PGMessageProcessingException.instance(pipelineEntry).put("unexpected array element size [expected=").put(expectedElementSize).put(", actual=").put(actualElementSize).put(']');
        }
        long totalExpectedSizeBytes = (long)(expectedElementSize + 4) * (long)this.flatViewLength;
        if (hi - lo != totalExpectedSizeBytes) {
            throw PGMessageProcessingException.instance(pipelineEntry).put("unexpected array size [expected=").put(totalExpectedSizeBytes).put(", actual=").put(hi - lo).put(']');
        }
        this.lo = lo;
        this.hi = hi;
        this.type = ColumnType.encodeArrayType(componentNativeType, this.shape.size());
        this.resetToDefaultStrides();
    }
}

