/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.CommitFailedException;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableUtils;
import io.questdb.cutlass.line.LineTcpTimestampAdapter;
import io.questdb.cutlass.line.tcp.LineProtocolException;
import io.questdb.cutlass.line.tcp.LineTcpParser;
import io.questdb.cutlass.line.tcp.MetadataChangedException;
import io.questdb.cutlass.line.tcp.TableUpdateDetails;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Long256Acceptor;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Uuid;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Utf8s;

public class LineWalAppender {
    private static final Log LOG = LogFactory.getLog(LineWalAppender.class);
    private final boolean autoCreateNewColumns;
    private final Long256Impl long256;
    private final int maxFileNameLength;
    private final MicrosecondClock microsecondClock;
    private final boolean stringToCharCastAllowed;
    private LineTcpTimestampAdapter timestampAdapter;

    public LineWalAppender(boolean autoCreateNewColumns, boolean stringToCharCastAllowed, LineTcpTimestampAdapter timestampAdapter, int maxFileNameLength, MicrosecondClock microsecondClock) {
        this.autoCreateNewColumns = autoCreateNewColumns;
        this.stringToCharCastAllowed = stringToCharCastAllowed;
        this.timestampAdapter = timestampAdapter;
        this.maxFileNameLength = maxFileNameLength;
        this.microsecondClock = microsecondClock;
        this.long256 = new Long256Impl();
    }

    public void appendToWal(SecurityContext securityContext, LineTcpParser parser, TableUpdateDetails tud) throws CommitFailedException {
        while (!tud.isDropped()) {
            try {
                this.appendToWal0(securityContext, parser, tud);
                break;
            }
            catch (MetadataChangedException metadataChangedException) {
            }
        }
    }

    public void setTimestampAdapter(byte precision) {
        switch (precision) {
            case 1: {
                this.timestampAdapter = LineTcpTimestampAdapter.DEFAULT_TS_NANO_INSTANCE;
                break;
            }
            case 2: {
                this.timestampAdapter = LineTcpTimestampAdapter.DEFAULT_TS_MICRO_INSTANCE;
                break;
            }
            case 3: {
                this.timestampAdapter = LineTcpTimestampAdapter.DEFAULT_TS_MILLI_INSTANCE;
                break;
            }
            case 4: {
                this.timestampAdapter = LineTcpTimestampAdapter.DEFAULT_TS_SECOND_INSTANCE;
                break;
            }
            case 5: {
                this.timestampAdapter = LineTcpTimestampAdapter.DEFAULT_TS_MINUTE_INSTANCE;
                break;
            }
            case 6: {
                this.timestampAdapter = LineTcpTimestampAdapter.DEFAULT_TS_HOUR_INSTANCE;
                break;
            }
            default: {
                throw new UnsupportedOperationException("precision: " + precision);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void appendToWal0(SecurityContext securityContext, LineTcpParser parser, TableUpdateDetails tud) throws CommitFailedException, MetadataChangedException {
        ld = tud.getThreadLocalDetails(0);
        ld.resetStateIfNecessary();
        ld.clearColumnTypes();
        writer = tud.getWriter();
        if (!LineWalAppender.$assertionsDisabled && !writer.supportsMultipleWriters()) {
            throw new AssertionError();
        }
        metadata = writer.getMetadata();
        timestamp = parser.getTimestamp();
        if (timestamp != -9223372036854775808L) {
            if (timestamp < 0L) {
                throw LineProtocolException.designatedTimestampMustBePositive(tud.getTableNameUtf16(), timestamp);
            }
            timestamp = this.timestampAdapter.getMicros(timestamp, parser.getTimestampUnit());
        } else {
            timestamp = this.microsecondClock.getTicks();
        }
        entCount = parser.getEntityCount();
        block75: for (i = 0; i < entCount; ++i) {
            ent = parser.getEntity(i);
            columnWriterIndex = ld.getColumnWriterIndex(ent.getName(), metadata);
            switch (columnWriterIndex) {
                default: {
                    columnType = metadata.getColumnType(columnWriterIndex);
                    if (columnType > -1) {
                        if (columnWriterIndex == tud.getTimestampIndex()) {
                            timestamp = this.timestampAdapter.getMicros(ent.getLongValue(), ent.getUnit());
                            ld.addColumnType(-2, 0);
                            continue block75;
                        }
                        ld.addColumnType(columnWriterIndex, metadata.getColumnType(columnWriterIndex));
                        continue block75;
                    }
                    ld.removeFromCaches(ent.getName());
                }
                case -1: {
                    columnNameUtf16 = ld.getColNameUtf16();
                    if (!this.autoCreateNewColumns || !TableUtils.isValidColumnName(columnNameUtf16, this.maxFileNameLength)) ** GOTO lbl50
                    columnWriterIndex = metadata.getColumnIndexQuiet(columnNameUtf16);
                    if (columnWriterIndex >= 0) ** GOTO lbl46
                    securityContext.authorizeAlterTableAddColumn(writer.getTableToken());
                    try {
                        newColumnType = ld.getColumnType(ld.getColNameUtf8(), ent);
                        writer.addColumn(columnNameUtf16, newColumnType, securityContext);
                        columnWriterIndex = metadata.getWriterIndex(metadata.getColumnIndexQuiet(columnNameUtf16));
                        ld.addColumn(columnNameUtf16, columnWriterIndex, newColumnType);
                    }
                    catch (CairoException e) {
                        columnWriterIndex = metadata.getColumnIndexQuiet(columnNameUtf16);
                        if (columnWriterIndex >= 0) ** GOTO lbl46
                        throw e;
                    }
lbl46:
                    // 3 sources

                    if (ld.getMetadataVersion() != writer.getMetadataVersion()) {
                        throw MetadataChangedException.INSTANCE;
                    }
                    ld.addColumnType(columnWriterIndex, metadata.getColumnType(columnWriterIndex));
                    continue block75;
lbl50:
                    // 1 sources

                    if (!this.autoCreateNewColumns) {
                        throw LineProtocolException.newColumnsNotAllowed(columnNameUtf16, tud.getTableNameUtf16());
                    }
                    throw LineProtocolException.invalidColNameError(columnNameUtf16, tud.getTableNameUtf16());
                }
                case -2: {
                    ld.addColumnType(-2, 0);
                }
            }
        }
        r = writer.newRow(timestamp);
        try {
            block76: for (i = 0; i < entCount; ++i) {
                colType = ld.getColumnType(i);
                columnIndex = ld.getColumnIndex(i);
                if (columnIndex < 0) continue;
                ent = parser.getEntity(i);
                switch (ent.getType()) {
                    case 1: 
                    case 5: {
                        switch (colType) {
                            case 11: {
                                r.putStrUtf8(columnIndex, ent.getValue());
                                continue block76;
                            }
                            case 12: {
                                r.putSymUtf8(columnIndex, ent.getValue());
                                continue block76;
                            }
                            case 26: {
                                r.putVarchar(columnIndex, ent.getValue());
                                continue block76;
                            }
                        }
                        throw LineProtocolException.castError(tud.getTableNameUtf16(), "TAG", colType, ent.getName());
                    }
                    case 3: {
                        switch (colType) {
                            case 6: {
                                r.putLong(columnIndex, ent.getLongValue());
                                continue block76;
                            }
                            case 5: {
                                entityValue = ent.getLongValue();
                                if (entityValue >= -2147483648L && entityValue <= 0x7FFFFFFFL) {
                                    r.putInt(columnIndex, (int)entityValue);
                                    continue block76;
                                }
                                if (entityValue == -9223372036854775808L) {
                                    r.putInt(columnIndex, -2147483648);
                                    continue block76;
                                }
                                throw LineProtocolException.boundsError(entityValue, 5, (CharSequence)tud.getTableNameUtf16(), writer.getMetadata().getColumnName(columnIndex));
                            }
                            case 3: {
                                entityValue = ent.getLongValue();
                                if (entityValue >= -32768L && entityValue <= 32767L) {
                                    r.putShort(columnIndex, (short)entityValue);
                                    continue block76;
                                }
                                if (entityValue == -9223372036854775808L) {
                                    r.putShort(columnIndex, (short)0);
                                    continue block76;
                                }
                                throw LineProtocolException.boundsError(entityValue, 3, (CharSequence)tud.getTableNameUtf16(), writer.getMetadata().getColumnName(columnIndex));
                            }
                            case 2: {
                                entityValue = ent.getLongValue();
                                if (entityValue >= -128L && entityValue <= 127L) {
                                    r.putByte(columnIndex, (byte)entityValue);
                                    continue block76;
                                }
                                if (entityValue == -9223372036854775808L) {
                                    r.putByte(columnIndex, (byte)0);
                                    continue block76;
                                }
                                throw LineProtocolException.boundsError(entityValue, 2, (CharSequence)tud.getTableNameUtf16(), writer.getMetadata().getColumnName(columnIndex));
                            }
                            case 8: {
                                r.putTimestamp(columnIndex, ent.getLongValue());
                                continue block76;
                            }
                            case 7: {
                                r.putDate(columnIndex, ent.getLongValue());
                                continue block76;
                            }
                            case 10: {
                                r.putDouble(columnIndex, ent.getLongValue());
                                continue block76;
                            }
                            case 9: {
                                r.putFloat(columnIndex, ent.getLongValue());
                                continue block76;
                            }
                            case 12: {
                                r.putSymUtf8(columnIndex, ent.getValue());
                                continue block76;
                            }
                        }
                        throw LineProtocolException.castError(tud.getTableNameUtf16(), "INTEGER", colType, ent.getName());
                    }
                    case 2: {
                        switch (colType) {
                            case 10: {
                                r.putDouble(columnIndex, ent.getFloatValue());
                                continue block76;
                            }
                            case 9: {
                                r.putFloat(columnIndex, (float)ent.getFloatValue());
                                continue block76;
                            }
                            case 12: {
                                r.putSymUtf8(columnIndex, ent.getValue());
                                continue block76;
                            }
                        }
                        throw LineProtocolException.castError(tud.getTableNameUtf16(), "FLOAT", colType, ent.getName());
                    }
                    case 4: {
                        geoHashBits = ColumnType.getGeoHashBits(colType);
                        entityValue = ent.getValue();
                        if (geoHashBits == 0) {
                            switch (colType) {
                                case 25: {
                                    try {
                                        value = Numbers.parseIPv4Nl(entityValue);
                                        r.putInt(columnIndex, value);
                                        continue block76;
                                    }
                                    catch (NumericException e) {
                                        throw LineProtocolException.castError(tud.getTableNameUtf16(), "STRING", colType, ent.getName());
                                    }
                                }
                                case 26: {
                                    r.putVarchar(columnIndex, entityValue);
                                    continue block76;
                                }
                                case 11: {
                                    r.putStrUtf8(columnIndex, entityValue);
                                    continue block76;
                                }
                                case 4: {
                                    if (entityValue.size() == 1 && entityValue.byteAt(0) > -1) {
                                        r.putChar(columnIndex, (char)entityValue.byteAt(0));
                                        continue block76;
                                    }
                                    if (this.stringToCharCastAllowed) {
                                        encodedResult = Utf8s.utf8CharDecode(entityValue);
                                        if (Numbers.decodeLowShort(encodedResult) > 0) {
                                            r.putChar(columnIndex, (char)Numbers.decodeHighShort(encodedResult));
                                            continue block76;
                                        }
                                        throw LineProtocolException.castError(tud.getTableNameUtf16(), "STRING", colType, ent.getName());
                                    }
                                }
                                throw LineProtocolException.castError(tud.getTableNameUtf16(), "STRING", colType, ent.getName());
                                case 12: {
                                    r.putSymUtf8(columnIndex, entityValue);
                                    continue block76;
                                }
                                case 19: {
                                    asciiCharSequence = entityValue.asAsciiCharSequence();
                                    try {
                                        Uuid.checkDashesAndLength(asciiCharSequence);
                                        uuidLo = Uuid.parseLo(asciiCharSequence);
                                        uuidHi = Uuid.parseHi(asciiCharSequence);
                                        r.putLong128(columnIndex, uuidLo, uuidHi);
                                        continue block76;
                                    }
                                    catch (NumericException e) {
                                        throw LineProtocolException.castError(tud.getTableNameUtf16(), "STRING", colType, ent.getName());
                                    }
                                }
                                case 13: {
                                    cs = entityValue.asAsciiCharSequence();
                                    if (Numbers.extractLong256(cs, (Long256Acceptor)this.long256)) {
                                        r.putLong256(columnIndex, this.long256);
                                        continue block76;
                                    }
                                    throw LineProtocolException.castError(tud.getTableNameUtf16(), "STRING", colType, ent.getName());
                                }
                            }
                            throw LineProtocolException.castError(tud.getTableNameUtf16(), "STRING", colType, ent.getName());
                        }
                        try {
                            value = ent.getValue();
                            geoHash = GeoHashes.fromAsciiTruncatingNl(value.lo(), value.hi(), geoHashBits);
                        }
                        catch (NumericException e) {
                            geoHash = -1L;
                        }
                        r.putGeoHash(columnIndex, geoHash);
                        continue block76;
                    }
                    case 7: {
                        switch (colType) {
                            case 13: {
                                r.putLong256Utf8(columnIndex, ent.getValue());
                                continue block76;
                            }
                            case 12: {
                                r.putSymUtf8(columnIndex, ent.getValue());
                                continue block76;
                            }
                        }
                        throw LineProtocolException.castError(tud.getTableNameUtf16(), "LONG256", colType, ent.getName());
                    }
                    case 6: {
                        switch (colType) {
                            case 1: {
                                r.putBool(columnIndex, ent.getBooleanValue());
                                continue block76;
                            }
                            case 2: {
                                r.putByte(columnIndex, (byte)(ent.getBooleanValue() != false));
                                continue block76;
                            }
                            case 3: {
                                r.putShort(columnIndex, (short)(ent.getBooleanValue() != false));
                                continue block76;
                            }
                            case 5: {
                                r.putInt(columnIndex, ent.getBooleanValue() != false ? 1 : 0);
                                continue block76;
                            }
                            case 6: {
                                r.putLong(columnIndex, ent.getBooleanValue() != false ? 1L : 0L);
                                continue block76;
                            }
                            case 9: {
                                r.putFloat(columnIndex, ent.getBooleanValue() != false ? 1.0f : 0.0f);
                                continue block76;
                            }
                            case 10: {
                                r.putDouble(columnIndex, ent.getBooleanValue() != false ? 1.0 : 0.0);
                                continue block76;
                            }
                            case 12: {
                                r.putSymUtf8(columnIndex, ent.getValue());
                                continue block76;
                            }
                        }
                        throw LineProtocolException.castError(tud.getTableNameUtf16(), "BOOLEAN", colType, ent.getName());
                    }
                    case 13: {
                        switch (colType) {
                            case 8: {
                                timestampValue = LineTcpTimestampAdapter.TS_COLUMN_INSTANCE.getMicros(ent.getLongValue(), ent.getUnit());
                                r.putTimestamp(columnIndex, timestampValue);
                                continue block76;
                            }
                            case 7: {
                                dateValue = LineTcpTimestampAdapter.TS_COLUMN_INSTANCE.getMicros(ent.getLongValue(), ent.getUnit());
                                r.putTimestamp(columnIndex, dateValue / 1000L);
                                continue block76;
                            }
                            case 12: {
                                r.putSymUtf8(columnIndex, ent.getValue());
                                continue block76;
                            }
                        }
                        throw LineProtocolException.castError(tud.getTableNameUtf16(), "TIMESTAMP", colType, ent.getName());
                    }
                    case 14: {
                        array = ent.getArray();
                        if (array.getType() != colType && !array.isNull()) {
                            throw LineProtocolException.castError(tud.getTableNameUtf16(), ColumnType.nameOf(array.getType()), colType, ent.getName());
                        }
                        r.putArray(columnIndex, array);
                        continue block76;
                    }
                }
            }
            r.append();
            tud.commitIfMaxUncommittedRowsCountReached();
        }
        catch (CommitFailedException commitFailedException) {
            throw commitFailedException;
        }
        catch (CairoException th) {
            LineWalAppender.LOG.error().$("could not write line protocol measurement [tableName=").$(tud.getTableNameUtf16()).$(", message=").$safe(th.getFlyweightMessage()).I$();
            if (r != null) {
                r.cancel();
            }
            throw th;
        }
        catch (Throwable th) {
            LineWalAppender.LOG.error().$("could not write line protocol measurement [tableName=").$(tud.getTableNameUtf16()).$(", message=").$safe(th.getMessage()).$(th).I$();
            if (r != null) {
                r.cancel();
            }
            throw th;
        }
    }
}

