/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.array;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.BorrowedFlatArrayView;
import io.questdb.cairo.arr.DirectArray;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.cutlass.line.LineSenderException;
import io.questdb.cutlass.line.array.ArrayBufferAppender;
import io.questdb.std.QuietCloseable;

public abstract class AbstractArray
implements QuietCloseable {
    protected final DirectArray array = new DirectArray();
    protected boolean closed = false;
    protected int flatLength;
    protected MemoryA memA = this.array.startMemoryA();

    protected AbstractArray(int[] shape, short columnType) {
        int dim;
        if (shape.length == 0) {
            throw new LineSenderException((CharSequence)"Shape must have at least one dimension");
        }
        if (shape.length > 32) {
            throw new LineSenderException((CharSequence)("Maximum supported dimensionality is 32D, but got " + shape.length + "D"));
        }
        for (dim = 0; dim < shape.length; ++dim) {
            if (shape[dim] < 0) {
                throw new LineSenderException((CharSequence)("dimension length must not be negative [dim=" + dim + ", dimLen=" + shape[dim] + "]"));
            }
            if (shape[dim] <= 0xFFFFFFF) continue;
            throw new LineSenderException((CharSequence)("dimension length out of range [dim=" + dim + ", dimLen=" + shape[dim] + ", maxLen=268435455]"));
        }
        this.array.setType(ColumnType.encodeArrayType(columnType, shape.length));
        int size = shape.length;
        for (dim = 0; dim < size; ++dim) {
            this.array.setDimLen(dim, shape[dim]);
        }
        this.array.applyShape();
        this.flatLength = this.array.getFlatViewLength();
    }

    public void appendToBufPtr(ArrayBufferAppender mem) {
        assert (!this.closed);
        byte nDims = (byte)this.array.getDimCount();
        mem.putByte(nDims);
        for (byte i = 0; i < nDims; i = (byte)(i + 1)) {
            mem.putInt(this.array.getDimLen(i));
        }
        if (!this.array.isNull() && !this.array.isEmpty()) {
            BorrowedFlatArrayView view = this.array.borrowedFlatView();
            mem.putBlockOfBytes(view.ptr(), view.size());
        }
    }

    public void clear() {
        assert (!this.closed);
        this.memA = this.array.startMemoryA();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.array.close();
        }
        this.closed = true;
    }

    public void reshape(int ... shape) {
        int dim;
        if (this.closed) {
            throw new LineSenderException((CharSequence)"Cannot reshape a closed array");
        }
        int nDim = shape.length;
        if (nDim > 32) {
            throw new LineSenderException((CharSequence)("Maximum supported dimensionality is 32D, but got " + nDim + "D"));
        }
        if (nDim == 0) {
            throw new LineSenderException((CharSequence)"Shape must have at least one dimension");
        }
        for (dim = 0; dim < nDim; ++dim) {
            if (shape[dim] < 0) {
                throw new LineSenderException((CharSequence)("dimension length must not be negative [dim=" + dim + ", dimLen=" + shape[dim] + "]"));
            }
            if (shape[dim] <= 0xFFFFFFF) continue;
            throw new LineSenderException((CharSequence)("dimension length out of range [dim=" + dim + ", dimLen=" + shape[dim] + ", maxLen=268435455]"));
        }
        this.array.setType(ColumnType.encodeArrayType(this.array.getElemType(), nDim));
        for (dim = 0; dim < nDim; ++dim) {
            this.array.setDimLen(dim, shape[dim]);
        }
        this.array.applyShape();
        this.flatLength = this.array.getFlatViewLength();
        this.memA = this.array.startMemoryA();
    }

    public void reshape(int dimLen) {
        if (this.closed) {
            throw new LineSenderException((CharSequence)"Cannot reshape a closed array");
        }
        if (dimLen < 0) {
            throw new LineSenderException((CharSequence)("Array size must not be negative, but got " + dimLen));
        }
        if (dimLen > 0xFFFFFFF) {
            throw new LineSenderException((CharSequence)("Array size out of range [dimLen=" + dimLen + ", maxLen=268435455]"));
        }
        this.array.setType(ColumnType.encodeArrayType(this.array.getElemType(), 1));
        this.array.setDimLen(0, dimLen);
        this.array.applyShape();
        this.flatLength = this.array.getFlatViewLength();
        this.memA = this.array.startMemoryA();
    }

    public void reshape(int dim1, int dim2) {
        if (this.closed) {
            throw new LineSenderException((CharSequence)"Cannot reshape a closed array");
        }
        if (dim1 < 0 || dim2 < 0) {
            throw new LineSenderException((CharSequence)("Array dimensions must not be negative, but got [" + dim1 + ", " + dim2 + "]"));
        }
        if (dim1 > 0xFFFFFFF || dim2 > 0xFFFFFFF) {
            throw new LineSenderException((CharSequence)("Array dimensions out of range [dim1=" + dim1 + ", dim2=" + dim2 + ", maxLen=268435455]"));
        }
        this.array.setType(ColumnType.encodeArrayType(this.array.getElemType(), 2));
        this.array.setDimLen(0, dim1);
        this.array.setDimLen(1, dim2);
        this.array.applyShape();
        this.flatLength = this.array.getFlatViewLength();
        this.memA = this.array.startMemoryA();
    }

    public void reshape(int dim1, int dim2, int dim3) {
        if (this.closed) {
            throw new LineSenderException((CharSequence)"Cannot reshape a closed array");
        }
        if (dim1 < 0 || dim2 < 0 || dim3 < 0) {
            throw new LineSenderException((CharSequence)("Array dimensions must not be negative, but got [" + dim1 + ", " + dim2 + ", " + dim3 + "]"));
        }
        if (dim1 > 0xFFFFFFF || dim2 > 0xFFFFFFF || dim3 > 0xFFFFFFF) {
            throw new LineSenderException((CharSequence)("Array dimensions out of range [dim1=" + dim1 + ", dim2=" + dim2 + ", dim3=" + dim3 + ", maxLen=268435455]"));
        }
        this.array.setType(ColumnType.encodeArrayType(this.array.getElemType(), 3));
        this.array.setDimLen(0, dim1);
        this.array.setDimLen(1, dim2);
        this.array.setDimLen(2, dim3);
        this.array.applyShape();
        this.flatLength = this.array.getFlatViewLength();
        this.memA = this.array.startMemoryA();
    }

    protected void ensureLegalAppendPosition() {
        long elementSize = ColumnType.sizeOf(this.array.getElemType());
        if (this.memA.getAppendOffset() == (long)this.flatLength * elementSize) {
            this.memA = this.array.startMemoryA();
        }
    }

    protected int toFlatOffset(int[] coords) {
        if (coords == null || coords.length == 0) {
            return 0;
        }
        if (coords.length != this.array.getDimCount()) {
            throw new LineSenderException((CharSequence)"coordinates and array shape do not match");
        }
        int flatOffset = 0;
        int n = coords.length;
        for (int dim = 0; dim < n; ++dim) {
            if (this.array.getDimLen(dim) <= coords[dim]) {
                throw new LineSenderException((CharSequence)"coordinates and array shape do not match");
            }
            flatOffset += this.array.getStride(dim) * coords[dim];
        }
        return flatOffset;
    }
}

