/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpConstants;
import io.questdb.cutlass.http.HttpFullFatServerConfiguration;
import io.questdb.cutlass.http.HttpRangeParser;
import io.questdb.cutlass.http.HttpRawSocket;
import io.questdb.cutlass.http.HttpRequestHandler;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.HttpResponseHeader;
import io.questdb.cutlass.http.LocalValue;
import io.questdb.cutlass.http.MimeTypesCache;
import io.questdb.cutlass.http.processors.StaticContentProcessorConfiguration;
import io.questdb.cutlass.http.processors.StaticContentProcessorState;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Utf8SequenceObjHashMap;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.FileNameExtractorUtf8Sequence;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.PrefixedPath;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;

public class StaticContentProcessor
implements HttpRequestProcessor,
HttpRequestHandler,
Closeable {
    private static final Log LOG = LogFactory.getLog(StaticContentProcessor.class);
    private static final LocalValue<StaticContentProcessorState> LV = new LocalValue();
    private final StaticContentProcessorConfiguration configuration;
    private final FilesFacade ff;
    private final String httpProtocolVersion;
    private final String keepAliveHeader;
    private final MimeTypesCache mimeTypes;
    private final PrefixedPath prefixedPath;
    private final HttpRangeParser rangeParser = new HttpRangeParser();
    private final byte requiredAuthType;
    private final Utf8StringSink utf8Sink = new Utf8StringSink();
    private final Utf8Sequence webConsoleContextPath;

    public StaticContentProcessor(HttpFullFatServerConfiguration configuration) {
        this.configuration = configuration.getStaticContentProcessorConfiguration();
        this.mimeTypes = configuration.getStaticContentProcessorConfiguration().getMimeTypesCache();
        this.prefixedPath = new PrefixedPath(configuration.getStaticContentProcessorConfiguration().getPublicDirectory());
        this.ff = configuration.getStaticContentProcessorConfiguration().getFilesFacade();
        this.keepAliveHeader = configuration.getStaticContentProcessorConfiguration().getKeepAliveHeader();
        this.httpProtocolVersion = configuration.getHttpContextConfiguration().getHttpVersion();
        this.requiredAuthType = configuration.getStaticContentProcessorConfiguration().getRequiredAuthType();
        this.webConsoleContextPath = new Utf8String(configuration.getContextPathWebConsole());
    }

    @Override
    public void close() {
        Misc.free(this.prefixedPath);
    }

    @Override
    public HttpRequestProcessor getDefaultProcessor() {
        return this;
    }

    @Override
    public HttpRequestProcessor getProcessor(HttpRequestHeader requestHeader) {
        return this;
    }

    @Override
    public byte getRequiredAuthType() {
        return this.requiredAuthType;
    }

    public LogRecord logInfoWithFd(HttpConnectionContext context) {
        return LOG.info().$('[').$(context.getFd()).$("] ");
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpRequestHeader headers = context.getRequestHeader();
        DirectUtf8String url = headers.getUrl();
        this.logInfoWithFd(context).$("incoming [url=").$((Utf8Sequence)url).$(']').$();
        if (Utf8s.containsAscii(url, "..")) {
            this.logInfoWithFd(context).$("URL abuse: ").$((Utf8Sequence)url).$();
            StaticContentProcessor.sendStatusTextContent(context, 404);
            return;
        }
        Utf8SequenceObjHashMap<Utf8Sequence> redirectMap = this.configuration.getRedirectMap();
        int index = redirectMap.keyIndex(url);
        if (index < 0) {
            this.utf8Sink.clear();
            this.utf8Sink.putAscii("Location: ").put(redirectMap.valueAt(index));
            if (headers.getQuery() != null) {
                this.utf8Sink.putAscii('?').put(headers.getQuery());
            }
            this.utf8Sink.putAscii("\r\n");
            context.simpleResponse().sendStatusNoContent(301, this.utf8Sink);
            return;
        }
        if (Utf8s.startsWith(url, this.webConsoleContextPath)) {
            this.utf8Sink.clear();
            Utf8s.strCpy(url, this.webConsoleContextPath.size(), url.size(), this.utf8Sink);
            PrefixedPath path = this.prefixedPath.rewind();
            LPSZ lpsz = path.concat(this.utf8Sink).$();
            if (this.ff.exists(lpsz)) {
                this.send(context, lpsz, headers.getUrlParam(HttpConstants.URL_PARAM_ATTACHMENT) != null);
                return;
            }
            this.logInfoWithFd(context).$("not found [path=").$(path).$(']').$();
        }
        StaticContentProcessor.sendStatusTextContent(context, 404);
    }

    @Override
    public boolean requiresAuthentication() {
        return this.requiredAuthType == 1;
    }

    @Override
    public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        long l;
        LOG.debug().$("resumeSend").$();
        StaticContentProcessorState state = LV.get(context);
        if (state == null || state.fd == -1L) {
            return;
        }
        context.resumeResponseSend();
        HttpRawSocket socket = context.getRawResponseSocket();
        long address = socket.getBufferAddress();
        int size = socket.getBufferSize();
        while (state.bytesSent < state.sendMax && (l = this.ff.read(state.fd, address, size, state.bytesSent)) > 0L) {
            if (l + state.bytesSent > state.sendMax) {
                l = state.sendMax - state.bytesSent;
            }
            state.bytesSent += l;
            socket.send((int)l);
        }
    }

    private static void sendStatusTextContent(HttpConnectionContext context, int code) throws PeerDisconnectedException, PeerIsSlowToReadException {
        context.simpleResponse().sendStatusTextContent(code);
    }

    private void send(HttpConnectionContext context, LPSZ path, boolean asAttachment) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int l;
        int n = Utf8s.lastIndexOfAscii(path, '.');
        if (n == -1) {
            this.logInfoWithFd(context).$("missing extension [file=").$(path).$(']').$();
            StaticContentProcessor.sendStatusTextContent(context, 404);
            return;
        }
        HttpRequestHeader headers = context.getRequestHeader();
        CharSequence contentType = (CharSequence)this.mimeTypes.valueAt(this.mimeTypes.keyIndex(path, n + 1, path.size()));
        DirectUtf8Sequence val = headers.getHeader(HttpConstants.HEADER_RANGE);
        if (val != null) {
            this.sendRange(context, val, path, contentType, asAttachment);
            return;
        }
        val = headers.getHeader(HttpConstants.HEADER_IF_NONE_MATCH);
        if (val != null && (l = val.size()) > 2 && val.byteAt(0) == 34 && val.byteAt(l - 1) == 34) {
            try {
                long that = Numbers.parseLong(val, 1, l - 1);
                if (that == this.ff.getLastModified(path)) {
                    context.simpleResponse().sendStatusNoContent(304);
                    return;
                }
            }
            catch (NumericException e) {
                LOG.info().$("bad 'If-None-Match' [value=").$(val).$(']').$();
                StaticContentProcessor.sendStatusTextContent(context, 400);
                return;
            }
        }
        this.sendVanilla(context, path, contentType, asAttachment);
    }

    private void sendRange(HttpConnectionContext context, DirectUtf8Sequence range, LPSZ path, CharSequence contentType, boolean asAttachment) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (this.rangeParser.of(range)) {
            StaticContentProcessorState state = LV.get(context);
            if (state == null) {
                state = new StaticContentProcessorState();
                LV.set(context, state);
            }
            state.fd = this.ff.openRO(path);
            if (state.fd == -1L) {
                LOG.info().$("Cannot open file: ").$(path).$();
                StaticContentProcessor.sendStatusTextContent(context, 404);
                return;
            }
            state.bytesSent = 0L;
            long length = this.ff.length(path);
            long lo = this.rangeParser.getLo();
            long hi = this.rangeParser.getHi();
            if (lo > length || hi != Long.MAX_VALUE && hi > length || lo > hi) {
                StaticContentProcessor.sendStatusTextContent(context, 416);
            } else {
                state.bytesSent = lo;
                state.sendMax = hi == Long.MAX_VALUE ? length : hi;
                HttpResponseHeader header = context.getResponseHeader();
                header.status(this.httpProtocolVersion, 206, contentType, state.sendMax - lo);
                if (asAttachment) {
                    ((Utf8Sink)header.put("Content-Disposition: attachment; filename=\"").put(FileNameExtractorUtf8Sequence.get(path))).put('\"').putEOL();
                }
                header.put("Accept-Ranges: bytes").putEOL();
                ((Utf8Sink)((Utf8Sink)((Utf8Sink)header.put("Content-Range: bytes ").put(lo)).put('-').put(state.sendMax)).put('/').put(length)).putEOL();
                ((Utf8Sink)header.put("ETag: ").put(this.ff.getLastModified(path))).putEOL();
                if (this.keepAliveHeader != null) {
                    header.put(this.keepAliveHeader);
                }
                header.send();
                this.resumeSend(context);
            }
        } else {
            StaticContentProcessor.sendStatusTextContent(context, 416);
        }
    }

    private void sendVanilla(HttpConnectionContext context, LPSZ path, CharSequence contentType, boolean asAttachment) throws PeerDisconnectedException, PeerIsSlowToReadException {
        long fd = this.ff.openRO(path);
        if (fd == -1L) {
            LOG.info().$("Cannot open file: ").$(path).$('(').$(this.ff.errno()).$(')').$();
            StaticContentProcessor.sendStatusTextContent(context, 404);
        } else {
            long length;
            StaticContentProcessorState h = LV.get(context);
            if (h == null) {
                h = new StaticContentProcessorState();
                LV.set(context, h);
            }
            h.fd = fd;
            h.bytesSent = 0L;
            h.sendMax = length = this.ff.length(path);
            HttpResponseHeader header = context.getResponseHeader();
            header.status(this.httpProtocolVersion, 200, contentType, length);
            if (asAttachment) {
                ((Utf8Sink)header.put("Content-Disposition: attachment; filename=\"").put(FileNameExtractorUtf8Sequence.get(path))).put("\"").putEOL();
            }
            ((Utf8Sink)header.put("ETag: ").put('\"').put(this.ff.getLastModified(path))).put('\"').putEOL();
            header.setKeepAlive(this.keepAliveHeader);
            header.send();
            this.resumeSend(context);
        }
    }
}

