/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpResponseSink;
import io.questdb.cutlass.http.processors.RejectProcessor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Utf8StringSink;

public class RejectProcessorImpl
implements RejectProcessor {
    private static final Log LOG = LogFactory.getLog(RejectProcessorImpl.class);
    protected final HttpConnectionContext httpConnectionContext;
    private final Utf8StringSink rejectMessage = new Utf8StringSink();
    protected byte authenticationType = 0;
    protected int rejectCode = 0;
    protected CharSequence rejectCookieName = null;
    protected CharSequence rejectCookieValue = null;
    protected boolean shutdownWrite = false;

    public RejectProcessorImpl(HttpConnectionContext httpConnectionContext) {
        this.httpConnectionContext = httpConnectionContext;
    }

    @Override
    public void clear() {
        this.rejectCode = 0;
        this.authenticationType = 0;
        this.rejectCookieName = null;
        this.rejectCookieValue = null;
        this.rejectMessage.clear();
        this.shutdownWrite = false;
    }

    @Override
    public CharSink<?> getMessageSink() {
        return this.rejectMessage;
    }

    @Override
    public boolean isRequestBeingRejected() {
        return this.rejectCode != 0;
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        HttpResponseSink.SimpleResponseImpl response = this.httpConnectionContext.simpleResponse();
        if (this.rejectCode == 401) {
            this.handleHttpUnauthorized(response);
        } else {
            response.sendStatusWithCookie(this.rejectCode, this.rejectMessage, this.rejectCookieName, this.rejectCookieValue);
        }
        if (this.shutdownWrite) {
            response.shutdownWrite();
        }
        this.httpConnectionContext.reset();
    }

    @Override
    public RejectProcessor reject(int rejectCode) {
        LOG.error().$("rejecting request [code=").$(rejectCode).I$();
        this.rejectCode = rejectCode;
        return this;
    }

    @Override
    public RejectProcessor reject(int rejectCode, CharSequence rejectMessage) {
        LOG.error().$(rejectMessage).$(" [code=").$(rejectCode).I$();
        this.rejectCode = rejectCode;
        this.rejectMessage.put(rejectMessage);
        return this;
    }

    @Override
    public RejectProcessor withAuthenticationType(byte authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    @Override
    public RejectProcessor withCookie(CharSequence cookieName, CharSequence cookieValue) {
        this.rejectCookieName = cookieName;
        this.rejectCookieValue = cookieValue;
        return this;
    }

    @Override
    public RejectProcessor withShutdownWrite() {
        this.shutdownWrite = true;
        return this;
    }

    protected void handleHttpUnauthorized(HttpResponseSink.SimpleResponseImpl response) throws PeerIsSlowToReadException, PeerDisconnectedException {
        response.sendStatusTextContent(401);
    }
}

