/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;

public class HttpRangeParser {
    private static final Utf8String BYTES = new Utf8String("bytes=");
    private long hi;
    private long lo;

    public long getHi() {
        return this.hi;
    }

    public long getLo() {
        return this.lo;
    }

    public boolean of(DirectUtf8Sequence range) {
        if (!Utf8s.startsWith(range, BYTES)) {
            return false;
        }
        int n = Utf8s.indexOfAscii(range, BYTES.size(), '-');
        if (n == -1) {
            return false;
        }
        try {
            this.lo = Numbers.parseLong(range, BYTES.size(), n);
            this.hi = n == range.size() - 1 ? Long.MAX_VALUE : Numbers.parseLong(range, n + 1, range.size());
            return true;
        }
        catch (NumericException e) {
            return false;
        }
    }
}

