/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cairo.Reopenable;
import io.questdb.cutlass.http.HttpConstants;
import io.questdb.cutlass.http.HttpCookie;
import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpHeaderParameterValue;
import io.questdb.cutlass.http.HttpKeywords;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpSemantics;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.LowerCaseUtf8SequenceObjHashMap;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Unsafe;
import io.questdb.std.Utf8SequenceObjHashMap;
import io.questdb.std.Vect;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8Sink;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpHeaderParser
implements Mutable,
QuietCloseable,
HttpRequestHeader {
    private static final Comparator<HttpCookie> COOKIE_COMPARATOR = HttpHeaderParser::cookieComparator;
    private static final Log LOG = LogFactory.getLog(HttpHeaderParser.class);
    private final BoundaryAugmenter boundaryAugmenter = new BoundaryAugmenter();
    private final ObjList<HttpCookie> cookieList = new ObjList();
    private final ObjectPool<HttpCookie> cookiePool;
    private final Utf8SequenceObjHashMap<HttpCookie> cookies = new Utf8SequenceObjHashMap();
    private final ObjectPool<DirectUtf8String> csPool;
    private final LowerCaseUtf8SequenceObjHashMap<DirectUtf8String> headers = new LowerCaseUtf8SequenceObjHashMap();
    private final HttpHeaderParameterValue parameterValue = new HttpHeaderParameterValue();
    private final DirectUtf8Sink sink = new DirectUtf8Sink(0L, true);
    private final DirectUtf8String temp = new DirectUtf8String();
    private final Utf8SequenceObjHashMap<DirectUtf8String> urlParams = new Utf8SequenceObjHashMap();
    protected boolean incomplete;
    protected DirectUtf8String url;
    private long _lo;
    private long _wptr;
    private DirectUtf8String boundary;
    private DirectUtf8String charset;
    private DirectUtf8String contentDisposition;
    private DirectUtf8String contentDispositionFilename;
    private DirectUtf8String contentDispositionName;
    private long contentLength;
    private DirectUtf8String contentType;
    private boolean getRequest = false;
    private DirectUtf8String headerName;
    private long headerPtr;
    private long hi;
    private int ignoredCookieCount;
    private boolean isMethod = true;
    private boolean isProtocol = true;
    private boolean isQueryParams = false;
    private boolean isStatusCode = true;
    private boolean isStatusText = true;
    private boolean isUrl = true;
    private DirectUtf8String method;
    private DirectUtf8String methodLine;
    private boolean needMethod;
    private boolean needProtocol = true;
    private boolean postRequest = false;
    private DirectUtf8String protocol;
    private DirectUtf8String protocolLine;
    private boolean putRequest = false;
    private DirectUtf8String query;
    private long statementTimeout = -1L;
    private DirectUtf8String statusCode;
    private DirectUtf8String statusText;

    public HttpHeaderParser(int bufferSize, ObjectPool<DirectUtf8String> csPool) {
        this.headerPtr = this._wptr = Unsafe.malloc(bufferSize, 33);
        this.hi = this.headerPtr + (long)bufferSize;
        this.csPool = csPool;
        this.cookiePool = new ObjectPool<HttpCookie>(HttpCookie::new, 16);
        this.clear();
    }

    @Override
    public void clear() {
        this.needMethod = true;
        this._wptr = this._lo = this.headerPtr;
        this.incomplete = true;
        this.headers.clear();
        this.method = null;
        this.methodLine = null;
        this.url = null;
        this.query = null;
        this.headerName = null;
        this.contentType = null;
        this.boundary = null;
        this.contentDisposition = null;
        this.contentDispositionName = null;
        this.contentDispositionFilename = null;
        this.urlParams.clear();
        this.isMethod = true;
        this.isUrl = true;
        this.isQueryParams = false;
        this.statementTimeout = -1L;
        this.protocol = null;
        this.statusCode = null;
        this.statusText = null;
        this.isProtocol = true;
        this.isStatusCode = true;
        this.isStatusText = true;
        this.needProtocol = true;
        this.contentLength = -1L;
        this.cookieList.clear();
        this.cookiePool.clear();
        this.ignoredCookieCount = 0;
    }

    @Override
    public void close() {
        this.clear();
        if (this.headerPtr != 0L) {
            this._wptr = this.hi = Unsafe.free(this.headerPtr, this.hi - this.headerPtr, 33);
            this.headerPtr = this.hi;
            this.boundaryAugmenter.close();
        }
        this.sink.close();
        this.csPool.clear();
    }

    @Override
    public DirectUtf8Sequence getBoundary() {
        return this.boundaryAugmenter.of(this.boundary);
    }

    @Override
    public DirectUtf8Sequence getCharset() {
        return this.charset;
    }

    @Override
    public DirectUtf8Sequence getContentDisposition() {
        return this.contentDisposition;
    }

    @Override
    public DirectUtf8Sequence getContentDispositionFilename() {
        return this.contentDispositionFilename;
    }

    @Override
    public DirectUtf8Sequence getContentDispositionName() {
        return this.contentDispositionName;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public DirectUtf8Sequence getContentType() {
        return this.contentType;
    }

    public HttpCookie getCookie(Utf8Sequence cookieName) {
        return this.cookies.get(cookieName);
    }

    @NotNull
    public ObjList<HttpCookie> getCookieList() {
        return this.cookieList;
    }

    @Override
    public DirectUtf8Sequence getHeader(Utf8Sequence name) {
        return this.headers.get(name);
    }

    @Override
    public ObjList<? extends Utf8Sequence> getHeaderNames() {
        return this.headers.keys();
    }

    public int getIgnoredCookieCount() {
        return this.ignoredCookieCount;
    }

    @Override
    public DirectUtf8Sequence getMethod() {
        return this.method;
    }

    @Override
    public DirectUtf8Sequence getMethodLine() {
        return this.methodLine;
    }

    public DirectUtf8Sequence getProtocolLine() {
        return this.protocolLine;
    }

    @Override
    @Nullable
    public DirectUtf8String getQuery() {
        return this.query;
    }

    @Override
    public long getStatementTimeout() {
        return this.statementTimeout;
    }

    public DirectUtf8Sequence getStatusCode() {
        return this.statusCode;
    }

    public DirectUtf8Sequence getStatusText() {
        return this.statusText;
    }

    @Override
    public DirectUtf8String getUrl() {
        return this.url;
    }

    @Override
    public DirectUtf8Sequence getUrlParam(Utf8Sequence name) {
        return this.urlParams.get(name);
    }

    public boolean hasBoundary() {
        return this.boundary != null;
    }

    @Override
    public boolean isGetRequest() {
        return this.getRequest;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    @Override
    public boolean isPostRequest() {
        return this.postRequest;
    }

    @Override
    public boolean isPutRequest() {
        return this.putRequest;
    }

    public boolean onRecvError(int err) {
        return false;
    }

    public long parse(long ptr, long hi, boolean _method, boolean _protocol) {
        long p;
        int l;
        if (_method && this.needMethod) {
            l = this.parseMethod(ptr, hi);
            p = ptr + (long)l;
        } else if (_protocol && this.needProtocol) {
            l = this.parseProtocol(ptr, hi);
            p = ptr + (long)l;
        } else {
            p = ptr;
        }
        while (p < hi) {
            if (this._wptr == this.hi) {
                throw HttpException.instance("header is too large");
            }
            char b = (char)Unsafe.getUnsafe().getByte(p++);
            if (b == '\r') continue;
            Unsafe.getUnsafe().putByte(this._wptr++, (byte)b);
            switch (b) {
                case ':': {
                    if (this.headerName != null) break;
                    this.headerName = this.csPool.next().of(this._lo, this._wptr - 1L);
                    this._lo = this._wptr + 1L;
                    break;
                }
                case '\n': {
                    if (this.headerName == null) {
                        this.incomplete = false;
                        this.parseKnownHeaders();
                        return p;
                    }
                    if (HttpKeywords.isHeaderSetCookie(this.headerName)) {
                        this.cookieParse(this._lo, this._wptr - 1L);
                    } else {
                        this.headers.put(this.headerName, this.csPool.next().of(this._lo, this._wptr - 1L));
                    }
                    this.headerName = null;
                    this._lo = this._wptr;
                    break;
                }
            }
        }
        return p;
    }

    public void reopen(int bufferSize) {
        if (this.headerPtr == 0L) {
            this._wptr = this._lo = Unsafe.malloc(bufferSize, 33);
            this.headerPtr = this._lo;
            this.hi = this.headerPtr + (long)bufferSize;
        }
        this.boundaryAugmenter.reopen();
    }

    public int size() {
        return this.headers.size();
    }

    private static int cookieComparator(HttpCookie o1, HttpCookie o2) {
        int pathLen1 = o1.path == null ? 0 : o1.path.size();
        int pathLen2 = o2.path == null ? 0 : o2.path.size();
        int diff = pathLen2 - pathLen1;
        return diff != 0 ? diff : Long.compare(o2.expires, o1.expires);
    }

    private static long cookieSkipBytes(long p, long hi) {
        while (p < hi && Unsafe.getUnsafe().getByte(p) != 59) {
            ++p;
        }
        return p;
    }

    private static boolean isEquals(long p) {
        return Unsafe.getUnsafe().getByte(p) == 61;
    }

    private static int lowercaseByte(long p) {
        return Unsafe.getUnsafe().getByte(p) | 0x20;
    }

    private static int swarLowercaseInt(long p) {
        return Unsafe.getUnsafe().getInt(p) | 0x20202020;
    }

    private static long swarLowercaseLong(long p) {
        return Unsafe.getUnsafe().getLong(p) | 0x2020202020202020L;
    }

    private static int swarLowercaseShort(long p) {
        return Unsafe.getUnsafe().getShort(p) | 0x2020;
    }

    private static DirectUtf8String unquote(CharSequence key, DirectUtf8String that) {
        int len = that.size();
        if (len == 0) {
            throw HttpException.instance("missing value [key=").put(key).put(']');
        }
        if (that.byteAt(0) == 34) {
            if (that.byteAt(len - 1) == 34) {
                return that.of(that.lo() + 1L, that.hi() - 1L);
            }
            throw HttpException.instance("unclosed quote [key=").put(key).put(']');
        }
        return that;
    }

    private long cookieLogUnknownAttributeError(long p, long lo, long hi) {
        long pnext = HttpHeaderParser.cookieSkipBytes(p, hi);
        LOG.error().$("unknown cookie attribute [attribute=").$(this.csPool.next().of(p, pnext)).$(", cookie=").$(this.csPool.next().of(lo, hi)).I$();
        return pnext;
    }

    private void cookieParse(long lo, long hi) {
        ++this.ignoredCookieCount;
        HttpCookie cookie = null;
        boolean attributeArea = false;
        long p0 = lo;
        int nonSpaceCount = 0;
        block15: for (long p = lo; p < hi; ++p) {
            char c = (char)Unsafe.getUnsafe().getByte(p);
            switch (c | 0x20) {
                case 61: {
                    if (p0 == p) {
                        LOG.error().$("cookie name is missing").$();
                        return;
                    }
                    if (cookie != null) {
                        p = this.cookieLogUnknownAttributeError(p0, lo, hi);
                    } else {
                        cookie = this.cookiePool.next();
                        cookie.cookieName = this.csPool.next().of(p0, p);
                    }
                    p0 = p + 1L;
                    nonSpaceCount = 0;
                    continue block15;
                }
                case 59: {
                    if (cookie == null) {
                        LOG.error().$("cookie name is missing").$();
                        return;
                    }
                    cookie.value = this.csPool.next().of(p0, p);
                    attributeArea = true;
                    p0 = p + 1L;
                    nonSpaceCount = 0;
                    continue block15;
                }
                case 100: {
                    if (attributeArea && nonSpaceCount == 0) {
                        if (p + 6L < hi && HttpHeaderParser.swarLowercaseInt(p + 1L) == 1767992687 && HttpHeaderParser.lowercaseByte(p + 5L) == 110 && HttpHeaderParser.isEquals(p + 6L)) {
                            p0 = p += 7L;
                            p = HttpHeaderParser.cookieSkipBytes(p, hi);
                            cookie.domain = this.csPool.next().of(p0, p);
                        } else {
                            p = this.cookieLogUnknownAttributeError(p, lo, hi);
                        }
                        p0 = p + 1L;
                        continue block15;
                    }
                    ++nonSpaceCount;
                    continue block15;
                }
                case 112: {
                    if (attributeArea && nonSpaceCount == 0) {
                        if (p + 4L < hi && HttpHeaderParser.swarLowercaseInt(p) == 1752457584 && HttpHeaderParser.isEquals(p + 4L)) {
                            p0 = p += 5L;
                            p = HttpHeaderParser.cookieSkipBytes(p, hi);
                            cookie.path = this.csPool.next().of(p0, p);
                        } else if (p + 10L < hi && HttpHeaderParser.swarLowercaseLong(p + 1L) == 7957695015293317729L && HttpHeaderParser.swarLowercaseShort(p + 9L) == 25701) {
                            p += 11L;
                            p = HttpHeaderParser.cookieSkipBytes(p, hi);
                            cookie.partitioned = true;
                        } else {
                            p = this.cookieLogUnknownAttributeError(p, lo, hi);
                        }
                        p0 = p + 1L;
                        continue block15;
                    }
                    ++nonSpaceCount;
                    continue block15;
                }
                case 115: {
                    if (attributeArea && nonSpaceCount == 0) {
                        if (p + 5L < hi && HttpHeaderParser.swarLowercaseInt(p + 1L) == 1920295781 && HttpHeaderParser.lowercaseByte(p + 5L) == 101) {
                            p += 6L;
                            p = HttpHeaderParser.cookieSkipBytes(p, hi);
                            cookie.secure = true;
                        } else if (p + 8L < hi && HttpHeaderParser.swarLowercaseLong(p) == 7310584039472980339L && HttpHeaderParser.isEquals(p + 8L)) {
                            p0 = p += 9L;
                            p = HttpHeaderParser.cookieSkipBytes(p, hi);
                            cookie.sameSite = this.csPool.next().of(p0, p);
                        } else {
                            p = this.cookieLogUnknownAttributeError(p, lo, hi);
                        }
                        p0 = p + 1L;
                        continue block15;
                    }
                    ++nonSpaceCount;
                    continue block15;
                }
                case 104: {
                    if (attributeArea && nonSpaceCount == 0) {
                        if (p + 7L < hi && HttpHeaderParser.swarLowercaseLong(p) == 8749489600981136488L) {
                            p += 8L;
                            p = HttpHeaderParser.cookieSkipBytes(p, hi);
                            cookie.httpOnly = true;
                        } else {
                            p = this.cookieLogUnknownAttributeError(p, lo, hi);
                        }
                        p0 = p + 1L;
                        continue block15;
                    }
                    ++nonSpaceCount;
                    continue block15;
                }
                case 109: {
                    DirectUtf8String v;
                    if (attributeArea && nonSpaceCount == 0) {
                        if (p + 7L < hi && HttpHeaderParser.swarLowercaseInt(p + 1L) == 1630369889 && HttpHeaderParser.swarLowercaseShort(p + 5L) == 25959 && HttpHeaderParser.isEquals(p + 7L)) {
                            p0 = p += 8L;
                            p = HttpHeaderParser.cookieSkipBytes(p, hi);
                            v = this.csPool.next().of(p0, p);
                            try {
                                cookie.maxAge = Numbers.parseLong(v);
                            }
                            catch (NumericException e) {
                                LOG.error().$("invalid cookie Max-Age value [value=").$((Utf8Sequence)v).I$();
                            }
                        } else {
                            p = this.cookieLogUnknownAttributeError(p, lo, hi);
                        }
                        p0 = p + 1L;
                        continue block15;
                    }
                    ++nonSpaceCount;
                    continue block15;
                }
                case 101: {
                    DirectUtf8String v;
                    if (attributeArea && nonSpaceCount == 0) {
                        if (p + 7L < hi && HttpHeaderParser.swarLowercaseInt(p + 1L) == 1919512696 && HttpHeaderParser.lowercaseByte(p + 6L) == 115 && HttpHeaderParser.isEquals(p + 7L)) {
                            p0 = p += 8L;
                            p = HttpHeaderParser.cookieSkipBytes(p, hi);
                            v = this.csPool.next().of(p0, p);
                            try {
                                cookie.expires = TimestampFormatUtils.parseHTTP(v.asAsciiCharSequence());
                            }
                            catch (NumericException e) {
                                LOG.error().$("invalid cookie Expires value [value=").$((Utf8Sequence)v).I$();
                            }
                        } else {
                            p = this.cookieLogUnknownAttributeError(p, lo, hi);
                        }
                        p0 = p + 1L;
                        continue block15;
                    }
                    ++nonSpaceCount;
                    continue block15;
                }
                case 32: {
                    if (nonSpaceCount == 0) continue block15;
                }
                default: {
                    ++nonSpaceCount;
                }
            }
        }
        if (cookie == null) {
            LOG.error().$("malformed cookie [value=").$safe(this.csPool.next().of(lo, hi)).I$();
            return;
        }
        if (cookie.cookieName != null && cookie.value == null) {
            cookie.value = this.csPool.next().of(p0, hi);
        }
        --this.ignoredCookieCount;
        this.cookieList.add(cookie);
    }

    private void cookieSortAndMap() {
        this.cookieList.sort(COOKIE_COMPARATOR);
        int n = this.cookieList.size();
        for (int i = 0; i < n; ++i) {
            HttpCookie cookie = this.cookieList.getQuick(i);
            int index = this.cookies.keyIndex(cookie.cookieName);
            if (index <= -1) continue;
            this.cookies.putAt(index, cookie.cookieName, cookie);
        }
    }

    private void parseContentDisposition() {
        long p;
        DirectUtf8Sequence contentDisposition = this.getHeader(HttpConstants.HEADER_CONTENT_DISPOSITION);
        if (contentDisposition == null) {
            return;
        }
        long _lo = p = contentDisposition.lo();
        long hi = contentDisposition.hi();
        boolean expectFormData = true;
        boolean swallowSpace = true;
        DirectUtf8String name = null;
        while (p <= hi) {
            char b = (char)Unsafe.getUnsafe().getByte(p++);
            if (b == ' ' && swallowSpace) {
                _lo = p;
                continue;
            }
            if (p > hi || b == ';') {
                if (expectFormData) {
                    this.contentDisposition = this.csPool.next().of(_lo, p - 1L);
                    _lo = p;
                    expectFormData = false;
                    continue;
                }
                if (name == null) {
                    throw HttpException.instance("Malformed ").put(HttpConstants.HEADER_CONTENT_DISPOSITION).put(" header");
                }
                if (Utf8s.equalsAscii("name", name)) {
                    this.contentDispositionName = HttpHeaderParser.unquote("name", this.csPool.next().of(_lo, p - 1L));
                    swallowSpace = true;
                    _lo = p;
                    name = null;
                    continue;
                }
                if (Utf8s.equalsAscii("filename", name)) {
                    this.contentDispositionFilename = HttpHeaderParser.unquote("filename", this.csPool.next().of(_lo, p - 1L));
                    _lo = p;
                    name = null;
                    continue;
                }
                if (p <= hi) continue;
                break;
            }
            if (b != '=') continue;
            name = name == null ? this.csPool.next().of(_lo, p - 1L) : name.of(_lo, p - 1L);
            _lo = p;
            swallowSpace = false;
        }
    }

    private void parseContentLength() {
        this.contentLength = -1L;
        DirectUtf8Sequence seq = this.getHeader(HttpConstants.HEADER_CONTENT_LENGTH);
        if (seq == null) {
            return;
        }
        try {
            this.contentLength = Numbers.parseLong(seq);
        }
        catch (NumericException ignore) {
            throw HttpException.instance("Malformed ").put(HttpConstants.HEADER_CONTENT_LENGTH).put(" header");
        }
    }

    private void parseContentType() {
        DirectUtf8Sequence seq = this.getHeader(HttpConstants.HEADER_CONTENT_TYPE);
        if (seq == null) {
            return;
        }
        long p = seq.lo();
        long hi = seq.hi();
        long lo = HttpSemantics.swallowOWS(p, hi);
        p = this.parseMediaType(lo, hi);
        this.contentType = this.csPool.next().of(lo, p);
        p = HttpSemantics.swallowOWS(p, hi);
        while (p < hi) {
            p = HttpSemantics.swallowNextDelimiter(p, hi);
            long nameLo = p = HttpSemantics.swallowOWS(p, hi);
            long nameHi = HttpSemantics.swallowTokens(p, hi);
            if (nameHi == nameLo) {
                throw HttpException.instance("Malformed ").put(HttpConstants.HEADER_CONTENT_TYPE).put(" header");
            }
            p = HttpSemantics.swallowOWS(nameHi, hi);
            if ((char)Unsafe.getUnsafe().getByte(p) != '=') {
                throw HttpException.instance("Malformed ").put(HttpConstants.HEADER_CONTENT_TYPE).put(" header, expected '=' but got '").put((char)Unsafe.getUnsafe().getByte(p)).put('\'');
            }
            p = HttpSemantics.swallowOWS(p + 1L, hi);
            HttpHeaderParameterValue value = this.parseParameterValue(p, hi);
            if (Utf8s.equalsAscii("charset", nameLo, nameHi)) {
                this.charset = value.getStr();
            } else if (Utf8s.equalsAscii("boundary", nameLo, nameHi)) {
                this.boundary = value.getStr();
            }
            p = value.getHi();
        }
    }

    private long parseMediaType(long lo, long hi) {
        long p = HttpSemantics.swallowTokens(lo, hi);
        if (p > hi || (char)Unsafe.getUnsafe().getByte(p) != '/') {
            return p;
        }
        return HttpSemantics.swallowTokens(p + 1L, hi);
    }

    private void parseKnownHeaders() {
        this.parseContentType();
        this.parseContentDisposition();
        this.parseStatementTimeout();
        this.parseContentLength();
        this.cookieSortAndMap();
    }

    private int parseMethod(long lo, long hi) {
        long p = lo;
        while (p < hi) {
            if (this._wptr == this.hi) {
                throw HttpException.instance("url is too long");
            }
            char b = (char)Unsafe.getUnsafe().getByte(p++);
            if (b == '\r') continue;
            switch (b) {
                case ' ': {
                    if (this.isMethod) {
                        this.method = this.csPool.next().of(this._lo, this._wptr);
                        this._lo = this._wptr + 1L;
                        this.isMethod = false;
                        break;
                    }
                    if (this.isUrl) {
                        this.url = this.csPool.next().of(this._lo, this._wptr);
                        this.isUrl = false;
                        this._lo = this._wptr + 1L;
                        break;
                    }
                    if (!this.isQueryParams) break;
                    this.query = this.csPool.next().of(this._lo, this._wptr);
                    this._lo = this._wptr + 1L;
                    this.isQueryParams = false;
                    break;
                }
                case '?': {
                    this.url = this.csPool.next().of(this._lo, this._wptr);
                    this.isUrl = false;
                    this.isQueryParams = true;
                    this._lo = this._wptr + 1L;
                    break;
                }
                case '\n': {
                    if (this.method == null) {
                        throw HttpException.instance("bad method");
                    }
                    this.methodLine = this.csPool.next().of(this.method.lo(), this._wptr);
                    this.needMethod = false;
                    this.getRequest = HttpKeywords.isGET(this.method);
                    this.postRequest = HttpKeywords.isPOST(this.method);
                    this.putRequest = HttpKeywords.isPUT(this.method);
                    if (this.query != null) {
                        int querySize = this.query.size();
                        long newBoundary = this._wptr + (long)querySize;
                        if (querySize > 0 && newBoundary < this.hi) {
                            Vect.memcpy(this._wptr, this.query.ptr(), querySize);
                            int o = this.urlDecode(this._wptr, newBoundary, this.urlParams);
                            this._wptr = newBoundary - (long)o;
                        } else {
                            throw HttpException.instance("URL query string is too long");
                        }
                    }
                    this._lo = this._wptr;
                    return (int)(p - lo);
                }
            }
            Unsafe.getUnsafe().putByte(this._wptr++, (byte)b);
        }
        return (int)(p - lo);
    }

    private HttpHeaderParameterValue parseParameterValue(long lo, long hi) {
        if (lo > hi) {
            return this.parameterValue;
        }
        long p = lo;
        char b = (char)Unsafe.getUnsafe().getByte(p++);
        if (b != '\"') {
            while (p < hi && (char)Unsafe.getUnsafe().getByte(p) != ';') {
                ++p;
            }
            this.parameterValue.of(p, this.csPool.next().of(lo, p));
            return this.parameterValue;
        }
        long s_lo = this.sink.size();
        boolean escaped = false;
        while (p <= hi) {
            b = (char)Unsafe.getUnsafe().getByte(p++);
            if (escaped || b != '\\' && b != '\"') {
                this.sink.put(b);
                escaped = false;
                continue;
            }
            if (b == '\\') {
                escaped = true;
                continue;
            }
            p = HttpSemantics.swallowOWS(p, hi);
            break;
        }
        this.parameterValue.of(p, this.csPool.next().of(this.sink.ptr() + s_lo, this.sink.hi()));
        return this.parameterValue;
    }

    private int parseProtocol(long lo, long hi) {
        long p = lo;
        while (p < hi) {
            if (this._wptr == this.hi) {
                throw HttpException.instance("protocol line is too long");
            }
            char b = (char)Unsafe.getUnsafe().getByte(p++);
            if (b == '\r') continue;
            switch (b) {
                case ' ': {
                    if (this.isProtocol) {
                        this.protocol = this.csPool.next().of(this._lo, this._wptr);
                        this._lo = this._wptr + 1L;
                        this.isProtocol = false;
                        break;
                    }
                    if (!this.isStatusCode) break;
                    this.statusCode = this.csPool.next().of(this._lo, this._wptr);
                    this.isStatusCode = false;
                    this._lo = this._wptr + 1L;
                    break;
                }
                case '\n': {
                    if (this.isStatusText) {
                        this.statusText = this.csPool.next().of(this._lo, this._wptr);
                        this.isStatusText = false;
                    }
                    if (this.protocol == null) {
                        throw HttpException.instance("bad protocol");
                    }
                    this.protocolLine = this.csPool.next().of(this.protocol.lo(), this._wptr);
                    this.needProtocol = false;
                    this._lo = this._wptr;
                    return (int)(p - lo);
                }
            }
            Unsafe.getUnsafe().putByte(this._wptr++, (byte)b);
        }
        return (int)(p - lo);
    }

    private void parseStatementTimeout() {
        this.statementTimeout = -1L;
        DirectUtf8Sequence timeout = this.getHeader(HttpConstants.HEADER_STATEMENT_TIMEOUT);
        if (timeout == null) {
            return;
        }
        try {
            this.statementTimeout = Numbers.parseLong(timeout);
        }
        catch (NumericException numericException) {
            // empty catch block
        }
    }

    private int urlDecode(long lo, long hi, Utf8SequenceObjHashMap<DirectUtf8String> map) {
        long _lo = lo;
        long rp = lo;
        long wp = lo;
        int offset = 0;
        DirectUtf8String name = null;
        block8: while (rp < hi) {
            char b = (char)Unsafe.getUnsafe().getByte(rp++);
            switch (b) {
                case '=': {
                    if (_lo < wp) {
                        name = this.csPool.next().of(_lo, wp);
                    }
                    _lo = rp - (long)offset;
                    break;
                }
                case '&': {
                    if (name != null) {
                        map.put(name, this.csPool.next().of(_lo, wp));
                        name = null;
                    }
                    _lo = rp - (long)offset;
                    break;
                }
                case '+': {
                    Unsafe.getUnsafe().putByte(wp++, (byte)32);
                    continue block8;
                }
                case '%': {
                    try {
                        if (rp + 1L < hi) {
                            byte bb = (byte)Numbers.parseHexInt(this.temp.of(rp, rp += 2L).asAsciiCharSequence());
                            Unsafe.getUnsafe().putByte(wp++, bb);
                            offset += 2;
                            continue block8;
                        }
                    }
                    catch (NumericException numericException) {
                        // empty catch block
                    }
                    throw HttpException.instance("invalid query encoding");
                }
            }
            Unsafe.getUnsafe().putByte(wp++, (byte)b);
        }
        if (_lo < wp && name != null) {
            map.put(name, this.csPool.next().of(_lo, wp));
        }
        return offset;
    }

    public static class BoundaryAugmenter
    implements Reopenable,
    QuietCloseable {
        private static final Utf8String BOUNDARY_PREFIX = new Utf8String("\r\n--");
        private final DirectUtf8String export = new DirectUtf8String();
        private long _wptr;
        private long lim = 64L;
        private long lo = this._wptr = Unsafe.malloc(this.lim, 33);

        public BoundaryAugmenter() {
            this.of0(BOUNDARY_PREFIX);
        }

        @Override
        public void close() {
            if (this.lo > 0L) {
                this.lo = this._wptr = Unsafe.free(this.lo, this.lim, 33);
            }
        }

        public DirectUtf8String of(Utf8Sequence value) {
            int len = value.size() + BOUNDARY_PREFIX.size();
            if ((long)len > this.lim) {
                this.resize(len);
            }
            this._wptr = this.lo + (long)BOUNDARY_PREFIX.size();
            this.of0(value);
            return this.export.of(this.lo, this._wptr);
        }

        @Override
        public void reopen() {
            if (this.lo == 0L) {
                this.lo = this._wptr = Unsafe.malloc(this.lim, 33);
                this.of0(BOUNDARY_PREFIX);
            }
        }

        private void of0(Utf8Sequence value) {
            int len = value.size();
            Utf8s.strCpy(value, len, this._wptr);
            this._wptr += (long)len;
        }

        private void resize(int lim) {
            long prevLim = this.lim;
            this.lim = Numbers.ceilPow2(lim);
            this.lo = this._wptr = Unsafe.realloc(this.lo, prevLim, this.lim, 33);
            this.of0(BOUNDARY_PREFIX);
        }
    }
}

