/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;

public class HttpException
extends RuntimeException
implements Sinkable,
FlyweightMessageContainer {
    private static final ThreadLocal<HttpException> tlException = new ThreadLocal<HttpException>(HttpException::new);
    private final StringSink message = new StringSink();

    public static HttpException instance(CharSequence message) {
        HttpException ex = tlException.get();
        ex.message.clear();
        ex.message.put(message);
        return ex;
    }

    @Override
    public CharSequence getFlyweightMessage() {
        return this.message;
    }

    @Override
    public String getMessage() {
        return this.message.toString();
    }

    public HttpException put(CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    public HttpException put(Utf8Sequence us) {
        this.message.put(us);
        return this;
    }

    public HttpException put(char c) {
        this.message.put(c);
        return this;
    }

    public HttpException put(int value) {
        this.message.put(value);
        return this;
    }

    public HttpException put(long value) {
        this.message.put(value);
        return this;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.put(this.message);
    }
}

