/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal.seq;

import io.questdb.cairo.BinaryAlterSerializer;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.IDGenerator;
import io.questdb.cairo.IDGeneratorFactory;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.wal.WalDirectoryPolicy;
import io.questdb.cairo.wal.seq.EmptyOperationCursor;
import io.questdb.cairo.wal.seq.SeqTxnTracker;
import io.questdb.cairo.wal.seq.SequencerMetadata;
import io.questdb.cairo.wal.seq.SequencerMetadataService;
import io.questdb.cairo.wal.seq.TableMetadataChange;
import io.questdb.cairo.wal.seq.TableMetadataChangeLog;
import io.questdb.cairo.wal.seq.TableRecordMetadataSink;
import io.questdb.cairo.wal.seq.TableSequencer;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.cairo.wal.seq.TableTransactionLog;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.SimpleReadWriteLock;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableSequencerImpl
implements TableSequencer {
    private static final Log LOG = LogFactory.getLog(TableSequencerImpl.class);
    private static final BinaryAlterSerializer alterCommandWalFormatter = new BinaryAlterSerializer();
    private final CairoEngine engine;
    private final SequencerMetadata metadata;
    private final SequencerMetadataService metadataSvc;
    private final MicrosecondClock microClock;
    private final Path path;
    private final TableSequencerAPI pool;
    private final int rootLen;
    private final ReadWriteLock schemaLock;
    private final SeqTxnTracker seqTxnTracker;
    private final TableTransactionLog tableTransactionLog;
    private final WalDirectoryPolicy walDirectoryPolicy;
    private final IDGenerator walIdGenerator;
    volatile long releaseTime;
    private volatile boolean closed;
    private boolean distressed;
    private TableToken tableToken;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TableSequencerImpl(TableSequencerAPI pool, CairoEngine engine, TableToken tableToken, SeqTxnTracker txnTracker, int tableId, @Nullable TableStructure tableStruct) {
        block10: {
            this.schemaLock = new SimpleReadWriteLock();
            this.releaseTime = Long.MAX_VALUE;
            this.closed = false;
            this.distressed = false;
            this.pool = pool;
            this.engine = engine;
            this.tableToken = tableToken;
            this.seqTxnTracker = txnTracker;
            CairoConfiguration configuration = engine.getConfiguration();
            this.walDirectoryPolicy = engine.getWalDirectoryPolicy();
            FilesFacade ff = configuration.getFilesFacade();
            try {
                this.path = new Path();
                this.path.of(configuration.getDbRoot());
                this.path.concat(tableToken.getDirName()).concat("txn_seq");
                this.rootLen = this.path.size();
                this.metadata = new SequencerMetadata(ff, configuration.getCommitMode());
                this.metadataSvc = new SequencerMetadataService(this.metadata, tableToken);
                this.walIdGenerator = IDGeneratorFactory.newIDGenerator(configuration, "_wal_index.d", configuration.getIdGenerateBatchStep() < 0 ? 512 : configuration.getIdGenerateBatchStep());
                this.tableTransactionLog = new TableTransactionLog(configuration);
                this.microClock = configuration.getMicrosecondClock();
                if (tableStruct == null) break block10;
                this.schemaLock.writeLock().lock();
                try {
                    this.createSequencerDir(ff, configuration.getMkDirMode());
                    long timestamp = this.microClock.getTicks();
                    this.metadata.create(tableStruct, tableToken, this.path, this.rootLen, tableId);
                    this.tableTransactionLog.create(this.path, timestamp);
                    engine.getWalListener().tableCreated(tableToken, timestamp);
                }
                finally {
                    this.schemaLock.writeLock().unlock();
                }
            }
            catch (Throwable th) {
                LOG.critical().$("could not create sequencer [name=").$(tableToken).$(", error=").$safe(th.getMessage()).I$();
                this.closeLocked();
                throw th;
            }
        }
        try {
            this.walIdGenerator.open(this.path);
            this.metadata.open(this.path, this.rootLen, tableToken);
            this.tableTransactionLog.open(this.path);
        }
        catch (CairoException ex) {
            this.closeLocked();
            if (ex.isTableDropped()) {
                throw ex;
            }
            if (ex.errnoFileCannotRead() && engine.isTableDropped(tableToken)) {
                LOG.info().$("could not open sequencer, table is dropped [table=").$(tableToken).$(", path=").$(this.path).$(", error=").$safe(ex.getMessage()).I$();
                throw CairoException.tableDropped(tableToken);
            }
            LOG.critical().$("could not open sequencer [table=").$(tableToken).$(", path=").$(this.path).$(", errno=").$(ex.getErrno()).$(", error=").$safe(ex.getMessage()).I$();
            throw ex;
        }
        catch (Throwable th) {
            LOG.critical().$("could not open sequencer [table=").$(tableToken).$(", path=").$(this.path).$(", error=").$safe(th.getMessage()).I$();
            this.closeLocked();
            throw th;
        }
    }

    public boolean checkClose() {
        if (this.closed) {
            return false;
        }
        this.schemaLock.writeLock().lock();
        try {
            boolean bl = this.closeLocked();
            return bl;
        }
        finally {
            this.schemaLock.writeLock().unlock();
        }
    }

    @Override
    public void close() {
        if (this.pool.closed) {
            this.checkClose();
        } else if (!this.isDistressed() && !this.isDropped()) {
            this.releaseTime = this.pool.configuration.getMicrosecondClock().getTicks();
        } else if (this.checkClose()) {
            LOG.info().$("closed table sequencer [table=").$(this.getTableToken()).$(", distressed=").$(this.isDistressed()).$(", dropped=").$(this.isDropped()).I$();
            this.pool.seqRegistry.remove(this.getTableToken().getDirName(), this);
        }
    }

    @Override
    public void dropTable() {
        this.checkDropped();
        long timestamp = this.microClock.getTicks();
        long txn = this.tableTransactionLog.addEntry(this.getStructureVersion(), -2, 0, 0, timestamp, 0L, 0L, 0L);
        this.metadata.dropTable();
        this.notifyTxnCommitted(Long.MAX_VALUE);
        this.engine.getWalListener().tableDropped(this.tableToken, txn, timestamp);
    }

    @Override
    public TableMetadataChangeLog getMetadataChangeLog(long structureVersionLo) {
        this.checkDropped();
        if (this.metadata.getMetadataVersion() == structureVersionLo) {
            return EmptyOperationCursor.INSTANCE;
        }
        return this.tableTransactionLog.getTableMetadataChangeLog(structureVersionLo, alterCommandWalFormatter);
    }

    @Override
    public TableMetadataChangeLog getMetadataChangeLogSlow(long structureVersionLo) {
        this.checkDropped();
        return this.tableTransactionLog.getTableMetadataChangeLog(structureVersionLo, alterCommandWalFormatter);
    }

    @Override
    public int getNextWalId() {
        return (int)this.walIdGenerator.getNextId();
    }

    @Override
    public long getStructureVersion() {
        return this.metadata.getMetadataVersion();
    }

    @Override
    public int getTableId() {
        return this.metadata.getTableId();
    }

    @Override
    public long getTableMetadata(@NotNull TableRecordMetadataSink sink) {
        int columnCount = this.metadata.getColumnCount();
        int timestampIndex = this.metadata.getTimestampIndex();
        int compressedTimestampIndex = -1;
        sink.clear();
        int compressedColumnCount = 0;
        boolean reorderNeeded = false;
        int lastOrder = -1;
        for (int i = 0; i < columnCount; ++i) {
            int columnType = this.metadata.getColumnType(i);
            int columnOrder = this.metadata.getReadColumnOrder().getQuick(i);
            sink.addColumn(this.metadata.getColumnName(i), columnType, this.metadata.isColumnIndexed(i), this.metadata.getIndexValueBlockCapacity(i), this.metadata.isSymbolTableStatic(i), i, this.metadata.isDedupKey(i), this.metadata.getColumnMetadata(i).isSymbolCacheFlag(), this.metadata.getColumnMetadata(i).getSymbolCapacity());
            if (columnType <= -1) continue;
            reorderNeeded |= lastOrder > columnOrder;
            lastOrder = columnOrder;
            if (i == timestampIndex) {
                compressedTimestampIndex = compressedColumnCount;
            }
            ++compressedColumnCount;
        }
        sink.of(this.tableToken, this.metadata.getTableId(), timestampIndex, compressedTimestampIndex, this.metadata.isSuspended(), this.metadata.getMetadataVersion(), compressedColumnCount, reorderNeeded ? this.metadata.getReadColumnOrder() : null);
        return this.tableTransactionLog.lastTxn();
    }

    public TableToken getTableToken() {
        return this.tableToken;
    }

    @Override
    public TransactionLogCursor getTransactionLogCursor(long seqTxn) {
        this.checkDropped();
        return this.tableTransactionLog.getCursor(seqTxn);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isDistressed() {
        return this.distressed;
    }

    public boolean isDropped() {
        return this.metadata.isDropped();
    }

    @Override
    public long lastTxn() {
        return this.tableTransactionLog.lastTxn();
    }

    public boolean metadataMatches(long structureVersion) {
        return this.metadata.getMetadataVersion() == structureVersion;
    }

    @Override
    public long nextStructureTxn(long expectedStructureVersion, TableMetadataChange change) {
        long txn;
        block8: {
            assert (!this.closed);
            this.checkDropped();
            try {
                if (this.metadata.getMetadataVersion() == expectedStructureVersion) {
                    long timestamp = this.microClock.getTicks();
                    this.tableTransactionLog.beginMetadataChangeEntry(expectedStructureVersion + 1L, alterCommandWalFormatter, change, timestamp);
                    TableToken oldTableToken = this.tableToken;
                    AlterOperation deserializedAlter = this.tableTransactionLog.readTableMetadataChangeLog(expectedStructureVersion, alterCommandWalFormatter);
                    this.applyToMetadata(deserializedAlter);
                    if (this.metadata.getMetadataVersion() != expectedStructureVersion + 1L) {
                        throw CairoException.critical(0).put("applying structure change to WAL table failed [table=").put(this.tableToken).put(", oldVersion: ").put(expectedStructureVersion).put(", newVersion: ").put(this.metadata.getMetadataVersion()).put(']');
                    }
                    this.metadata.sync();
                    this.tableToken = this.metadata.getTableToken();
                    txn = this.tableTransactionLog.endMetadataChangeEntry();
                    if (!this.metadata.isSuspended()) {
                        this.notifyTxnCommitted(txn);
                        if (!this.tableToken.equals(oldTableToken)) {
                            this.engine.getWalListener().tableRenamed(this.tableToken, txn, timestamp, oldTableToken);
                        } else {
                            this.engine.getWalListener().nonDataTxnCommitted(this.tableToken, txn, timestamp);
                        }
                    }
                    break block8;
                }
                return Long.MIN_VALUE;
            }
            catch (Throwable th) {
                this.distressed = true;
                LOG.critical().$("could not apply structure change to WAL table sequencer [table=").$(this.tableToken).$(", error=").$safe(th.getMessage()).I$();
                throw th;
            }
        }
        return txn;
    }

    @Override
    public long nextTxn(long expectedStructureVersion, int walId, int segmentId, int segmentTxn, long txnMinTimestamp, long txnMaxTimestamp, long txnRowCount) {
        long txn;
        assert (!this.closed);
        this.checkDropped();
        long timestamp = this.microClock.getTicks();
        try {
            if (this.metadata.getMetadataVersion() != expectedStructureVersion) {
                return Long.MIN_VALUE;
            }
            txn = this.nextTxn(walId, segmentId, segmentTxn, timestamp, txnMinTimestamp, txnMaxTimestamp, txnRowCount);
        }
        catch (Throwable th) {
            this.distressed = true;
            LOG.critical().$("could not apply transaction to WAL table sequencer [table=").$(this.tableToken).$(", error=").$safe(th.getMessage()).I$();
            throw th;
        }
        this.notifyTxnCommitted(txn);
        this.engine.getWalListener().dataTxnCommitted(this.tableToken, txn, timestamp, walId, segmentId, segmentTxn);
        return txn;
    }

    public void notifyRename(TableToken tableToken) {
        this.tableToken = tableToken;
        this.metadata.notifyRenameTable(tableToken);
    }

    @Override
    public TableToken reload() {
        this.tableTransactionLog.reload(this.path);
        if (this.tableTransactionLog.isDropped()) {
            return null;
        }
        try (TableMetadataChangeLog metaChangeCursor = this.tableTransactionLog.getTableMetadataChangeLog(this.metadata.getMetadataVersion(), alterCommandWalFormatter);){
            boolean updated = false;
            while (metaChangeCursor.hasNext()) {
                TableMetadataChange change = metaChangeCursor.next();
                change.apply(this.metadataSvc, true);
                updated = true;
            }
            if (updated) {
                this.metadata.syncToMetaFile();
            }
        }
        long lastTxn = this.tableTransactionLog.lastTxn();
        LOG.info().$("reloaded table sequencer [table=").$(this.tableToken).$(", lastTxn=").$(lastTxn).I$();
        this.seqTxnTracker.notifyOnCommit(lastTxn);
        this.tableToken = this.metadata.getTableToken();
        return this.tableToken;
    }

    @Override
    public void resumeTable() {
        this.metadata.resumeTable();
        this.notifyTxnCommitted(Long.MAX_VALUE);
        this.seqTxnTracker.setUnsuspended();
    }

    public void setDistressed() {
        this.distressed = true;
    }

    @Override
    public void suspendTable() {
        this.metadata.suspendTable();
    }

    private void applyToMetadata(TableMetadataChange change) {
        change.apply(this.metadataSvc, true);
        this.metadata.syncToMetaFile();
    }

    private void checkDropped() {
        if (this.metadata.isDropped()) {
            throw CairoException.tableDropped(this.tableToken);
        }
    }

    private boolean closeLocked() {
        if (this.closed) {
            return false;
        }
        this.closed = true;
        Misc.free(this.metadata);
        Misc.free(this.tableTransactionLog);
        Misc.free(this.walIdGenerator);
        Misc.free(this.path);
        return true;
    }

    private void createSequencerDir(FilesFacade ff, int mkDirMode) {
        if (ff.mkdirs(this.path.slash(), mkDirMode) != 0) {
            CairoException e = CairoException.critical(ff.errno()).put("Cannot create sequencer directory: ").put(this.path);
            this.closeLocked();
            throw e;
        }
        this.walDirectoryPolicy.initDirectory(this.path);
        this.path.trimTo(this.rootLen);
    }

    private long nextTxn(int walId, int segmentId, int segmentTxn, long timestamp, long txnMinTimestamp, long txnMaxTimestamp, long txnRowCount) {
        return this.tableTransactionLog.addEntry(this.getStructureVersion(), walId, segmentId, segmentTxn, timestamp, txnMinTimestamp, txnMaxTimestamp, txnRowCount);
    }

    private void notifyTxnCommitted(long txn) {
        if (txn == Long.MAX_VALUE || this.seqTxnTracker.notifyOnCommit(txn)) {
            this.engine.notifyWalTxnCommitted(this.tableToken);
        }
    }

    void readLock() {
        this.schemaLock.readLock().lock();
    }

    void unlockRead() {
        this.schemaLock.readLock().unlock();
    }

    void unlockWrite() {
        this.schemaLock.writeLock().unlock();
    }

    void writeLock() {
        this.schemaLock.writeLock().lock();
    }
}

