/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.Metrics;
import io.questdb.cairo.AlterTableContextException;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypeDriver;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.DdlListener;
import io.questdb.cairo.EmptySymbolMapReader;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.VarcharTypeDriver;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.cairo.vm.api.NullMemory;
import io.questdb.cairo.wal.CopyWalSegmentUtils;
import io.questdb.cairo.wal.MetadataService;
import io.questdb.cairo.wal.SegmentColumnRollSink;
import io.questdb.cairo.wal.WalDirectoryPolicy;
import io.questdb.cairo.wal.WalEventWriter;
import io.questdb.cairo.wal.WalUtils;
import io.questdb.cairo.wal.WalWriterMetadata;
import io.questdb.cairo.wal.WriterRowUtils;
import io.questdb.cairo.wal.seq.MetadataServiceStub;
import io.questdb.cairo.wal.seq.TableMetadataChange;
import io.questdb.cairo.wal.seq.TableMetadataChangeLog;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.SymbolMapWriterLite;
import io.questdb.griffin.engine.ops.AbstractOperation;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.std.AtomicIntList;
import io.questdb.std.BinarySequence;
import io.questdb.std.BoolList;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.Utf8StringIntHashMap;
import io.questdb.std.Uuid;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.SingleCharCharSequence;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WalWriter
implements TableWriterAPI {
    private static final long COLUMN_DELETED_NULL_FLAG = Long.MAX_VALUE;
    private static final Log LOG = LogFactory.getLog(WalWriter.class);
    private static final int MEM_TAG = 11;
    private static final Runnable NOOP = () -> {};
    private final AlterOperation alterOp = new AlterOperation();
    private final ObjList<MemoryMA> columns;
    private final CairoConfiguration configuration;
    private final DdlListener ddlListener;
    private final WalEventWriter events;
    private final FilesFacade ff;
    private final AtomicIntList initialSymbolCounts;
    private final IntList localSymbolIds;
    private final MetadataValidatorService metaValidatorSvc = new MetadataValidatorService();
    private final MetadataService metaWriterSvc = new MetadataWriterService();
    private final WalWriterMetadata metadata;
    private final Metrics metrics;
    private final int mkDirMode;
    private final ObjList<Runnable> nullSetters;
    private final Path path;
    private final int pathRootSize;
    private final int pathSize;
    private final RowImpl row = new RowImpl();
    private final LongList rowValueIsNotNull = new LongList();
    private final TableSequencerAPI sequencer;
    private final BoolList symbolMapNullFlags = new BoolList();
    private final ObjList<SymbolMapReader> symbolMapReaders = new ObjList();
    private final ObjList<CharSequenceIntHashMap> symbolMaps = new ObjList();
    private final int timestampIndex;
    private final ObjList<Utf8StringIntHashMap> utf8SymbolMaps = new ObjList();
    private final Uuid uuid = new Uuid();
    private final WalDirectoryPolicy walDirectoryPolicy;
    private final int walId;
    private final String walName;
    private long avgRecordSize;
    private SegmentColumnRollSink columnConversionSink;
    private int columnCount;
    private ColumnVersionReader columnVersionReader;
    private ConversionSymbolMapWriter conversionSymbolMap;
    private ConversionSymbolTable conversionSymbolTable;
    private long currentTxnStartRowNum = -1L;
    private boolean distressed;
    private boolean isCommittingData;
    private byte lastDedupMode = 0;
    private long lastMatViewPeriodHi = WalUtils.WAL_DEFAULT_LAST_PERIOD_HI;
    private long lastMatViewRefreshBaseTxn = WalUtils.WAL_DEFAULT_BASE_TABLE_TXN;
    private long lastMatViewRefreshTimestamp = WalUtils.WAL_DEFAULT_LAST_REFRESH_TIMESTAMP;
    private long lastReplaceRangeHiTs = 0L;
    private long lastReplaceRangeLowTs = 0L;
    private int lastSegmentTxn = -1;
    private long lastSeqTxn = Long.MIN_VALUE;
    private byte lastTxnType = 0;
    private boolean open;
    private boolean rollSegmentOnNextRow = false;
    private int segmentId = -1;
    private long segmentLockFd = -1L;
    private long segmentRowCount = -1L;
    private TableToken tableToken;
    private long totalSegmentsRowCount;
    private long totalSegmentsSize;
    private TxReader txReader;
    private long txnMaxTimestamp = -1L;
    private long txnMinTimestamp = Long.MAX_VALUE;
    private boolean txnOutOfOrder = false;
    private long walLockFd = -1L;

    public WalWriter(CairoConfiguration configuration, TableToken tableToken, TableSequencerAPI tableSequencerAPI, DdlListener ddlListener, WalDirectoryPolicy walDirectoryPolicy) {
        LOG.info().$("open [table=").$(tableToken).I$();
        this.sequencer = tableSequencerAPI;
        this.configuration = configuration;
        this.ddlListener = ddlListener;
        this.mkDirMode = configuration.getMkDirMode();
        this.ff = configuration.getFilesFacade();
        this.walDirectoryPolicy = walDirectoryPolicy;
        this.tableToken = tableToken;
        int walId = tableSequencerAPI.getNextWalId(tableToken);
        this.walName = "wal" + walId;
        this.walId = walId;
        this.path = new Path();
        this.path.of(configuration.getDbRoot());
        this.pathRootSize = this.path.size();
        this.path.concat(tableToken).concat(this.walName);
        this.pathSize = this.path.size();
        this.metrics = configuration.getMetrics();
        this.open = true;
        try {
            this.lockWal();
            this.mkWalDir();
            this.metadata = new WalWriterMetadata(this.ff);
            tableSequencerAPI.getTableMetadata(tableToken, this.metadata);
            this.tableToken = this.metadata.getTableToken();
            this.columnCount = this.metadata.getColumnCount();
            this.timestampIndex = this.metadata.getTimestampIndex();
            this.columns = new ObjList(this.columnCount * 2);
            this.nullSetters = new ObjList(this.columnCount);
            this.initialSymbolCounts = new AtomicIntList(this.columnCount);
            this.localSymbolIds = new IntList(this.columnCount);
            this.events = new WalEventWriter(configuration);
            this.events.of(this.symbolMaps, this.initialSymbolCounts, this.symbolMapNullFlags);
            this.configureColumns();
            this.openNewSegment();
            this.configureSymbolTable();
        }
        catch (Throwable e) {
            this.doClose(false);
            throw e;
        }
    }

    @Override
    public void addColumn(@NotNull CharSequence columnName, int columnType, SecurityContext securityContext) {
        this.addColumn(columnName, columnType, this.configuration.getDefaultSymbolCapacity(), this.configuration.getDefaultSymbolCacheFlag(), false, this.configuration.getIndexValueBlockSize(), false, securityContext);
    }

    @Override
    public void addColumn(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isDedupKey) {
        this.addColumn(columnName, columnType, symbolCapacity, symbolCacheFlag, isIndexed, indexValueBlockCapacity, isDedupKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long apply(AlterOperation alterOp, boolean contextAllowsAnyStructureChanges) throws AlterTableContextException {
        try {
            if (alterOp.isStructural()) {
                long l = this.applyStructural(alterOp);
                return l;
            }
            long l = this.applyNonStructural(alterOp, false);
            return l;
        }
        finally {
            alterOp.clearSecurityContext();
        }
    }

    @Override
    public long apply(UpdateOperation operation) {
        if (this.inTransaction()) {
            throw CairoException.critical(0).put("cannot update table with uncommitted inserts [table=").put(this.tableToken.getTableName()).put(']');
        }
        return this.applyNonStructural(operation, true);
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            try {
                if (!this.distressed) {
                    this.rollback();
                }
            }
            finally {
                this.doClose(this.walDirectoryPolicy.truncateFilesOnClose());
            }
        }
    }

    @Override
    public void commit() {
        this.commit0((byte)0, WalUtils.WAL_DEFAULT_BASE_TABLE_TXN, WalUtils.WAL_DEFAULT_LAST_REFRESH_TIMESTAMP, WalUtils.WAL_DEFAULT_LAST_PERIOD_HI, 0L, 0L, (byte)0);
    }

    public void commitMatView(long lastRefreshBaseTxn, long lastRefreshTimestamp, long lastPeriodHi, long lastReplaceRangeLowTs, long lastReplaceRangeHiTs) {
        assert (lastReplaceRangeLowTs < lastReplaceRangeHiTs);
        assert (this.txnMinTimestamp >= lastReplaceRangeLowTs);
        assert (this.txnMaxTimestamp <= lastReplaceRangeHiTs);
        this.commit0((byte)3, lastRefreshBaseTxn, lastRefreshTimestamp, lastPeriodHi, lastReplaceRangeLowTs, lastReplaceRangeHiTs, (byte)3);
    }

    public void commitWithParams(long replaceRangeLowTs, long replaceRangeHiTs, byte dedupMode) {
        this.commit0((byte)0, WalUtils.WAL_DEFAULT_BASE_TABLE_TXN, WalUtils.WAL_DEFAULT_LAST_REFRESH_TIMESTAMP, WalUtils.WAL_DEFAULT_LAST_PERIOD_HI, replaceRangeLowTs, replaceRangeHiTs, dedupMode);
    }

    public void doClose(boolean truncate) {
        if (this.open) {
            this.open = false;
            if (this.metadata != null) {
                this.metadata.close(truncate, (byte)1);
            }
            if (this.events != null) {
                this.events.close(truncate, (byte)1);
            }
            this.freeSymbolMapReaders();
            this.freeColumns(truncate);
            this.releaseSegmentLock(this.segmentId, this.segmentLockFd, this.lastSegmentTxn);
            try {
                this.releaseWalLock();
            }
            finally {
                Misc.free(this.path);
                LOG.info().$("closed [table=").$(this.tableToken).I$();
            }
        }
    }

    @Override
    public TableRecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public long getMetadataVersion() {
        return this.metadata.getMetadataVersion();
    }

    public long getSegmentRowCount() {
        return this.segmentRowCount;
    }

    @Override
    public int getSymbolCountWatermark(int columnIndex) {
        if (columnIndex > this.initialSymbolCounts.size() - 1) {
            return 0;
        }
        return this.initialSymbolCounts.get(columnIndex);
    }

    public SymbolMapReader getSymbolMapReader(int columnIndex) {
        return this.symbolMapReaders.getQuick(columnIndex);
    }

    @Override
    @NotNull
    public TableToken getTableToken() {
        return this.tableToken;
    }

    @Override
    public long getUncommittedRowCount() {
        return this.segmentRowCount - this.currentTxnStartRowNum;
    }

    public int getWalId() {
        return this.walId;
    }

    public String getWalName() {
        return this.walName;
    }

    public void goActive() {
        this.goActive(Long.MAX_VALUE);
    }

    public boolean goActive(long maxStructureVersion) {
        try {
            this.applyMetadataChangeLog(maxStructureVersion);
            return true;
        }
        catch (CairoException e) {
            LOG.critical().$("could not apply structure changes, WAL will be closed [table=").$(this.tableToken).$(", walId=").$(this.walId).$(", ex=").$(e).$(", errno=").$(e.getErrno()).I$();
            this.distressed = true;
            return false;
        }
    }

    @Override
    public void ic() {
        this.commit();
    }

    @Override
    public void ic(long o3MaxLag) {
        this.commit();
    }

    public boolean inTransaction() {
        return this.segmentRowCount > this.currentTxnStartRowNum;
    }

    public boolean isDistressed() {
        return this.distressed;
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public TableWriter.Row newRow() {
        return this.newRow(0L);
    }

    @Override
    public TableWriter.Row newRow(long timestamp) {
        this.checkDistressed();
        TableWriter.validateDesignatedTimestampBounds(timestamp);
        try {
            if (this.rollSegmentOnNextRow) {
                this.rollSegment();
                this.rollSegmentOnNextRow = false;
            }
            if (this.timestampIndex != -1) {
                this.row.setTimestamp(timestamp);
            }
            return this.row;
        }
        catch (Throwable e) {
            this.distressed = true;
            throw e;
        }
    }

    @Override
    public TableWriter.Row newRowDeferTimestamp() {
        this.checkDistressed();
        try {
            if (this.rollSegmentOnNextRow) {
                this.rollSegment();
                this.rollSegmentOnNextRow = false;
            }
            return this.row;
        }
        catch (Throwable e) {
            this.distressed = true;
            throw e;
        }
    }

    public long renameTable(@NotNull CharSequence oldName, String newTableName) {
        if (!Chars.equalsIgnoreCaseNc(oldName, this.tableToken.getTableName())) {
            throw CairoException.tableDoesNotExist(oldName);
        }
        this.alterOp.clear();
        this.alterOp.ofRenameTable(this.tableToken, newTableName);
        long txn = this.apply(this.alterOp, true);
        assert (Chars.equals(newTableName, this.tableToken.getTableName()));
        return txn;
    }

    public void resetMatViewState(long lastRefreshBaseTxn, long lastRefreshTimestamp, boolean invalid, @Nullable CharSequence invalidationReason, long lastPeriodHi, @Nullable LongList refreshIntervals, long refreshIntervalsBaseTxn) {
        try {
            this.lastSegmentTxn = this.events.appendMatViewInvalidate(lastRefreshBaseTxn, lastRefreshTimestamp, invalid, invalidationReason, lastPeriodHi, refreshIntervals, refreshIntervalsBaseTxn);
            this.getSequencerTxn();
        }
        catch (Throwable th) {
            this.rollback();
            throw th;
        }
    }

    public void rollSegment() {
        try {
            this.openNewSegment();
        }
        catch (Throwable e) {
            this.distressed = true;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollUncommittedToNewSegment(int convertColumnIndex, int convertToColumnType) {
        long uncommittedRows = this.getUncommittedRowCount();
        long oldLastSegmentTxn = this.lastSegmentTxn;
        long rowsRemainInCurrentSegment = this.currentTxnStartRowNum;
        if (uncommittedRows > 0L) {
            int oldSegmentId = this.segmentId;
            int newSegmentId = this.segmentId + 1;
            if (newSegmentId > 0x1FFFFFFE) {
                throw CairoException.critical(0).put("cannot roll over to new segment due to SEG_MAX_ID overflow [table=").put(this.tableToken).put(", walId=").put(this.walId).put(", segmentId=").put(newSegmentId).put(']');
            }
            long oldSegmentLockFd = this.segmentLockFd;
            this.segmentLockFd = -1L;
            try {
                this.createSegmentDir(newSegmentId);
                this.path.trimTo(this.pathSize);
                SegmentColumnRollSink columnRollSink = this.createSegmentColumnRollSink();
                this.rowValueIsNotNull.fill(0, this.columnCount, -1L);
                int columnsToRoll = convertColumnIndex == -1 ? this.columnCount : this.columnCount - 1;
                try {
                    int timestampIndex = this.metadata.getTimestampIndex();
                    if (convertColumnIndex < 0) {
                        LOG.info().$("rolling uncommitted rows to new segment [wal=").$(this.path).$(Files.SEPARATOR).$(oldSegmentId).$(", lastSegmentTxn=").$(this.lastSegmentTxn).$(", newSegmentId=").$(newSegmentId).$(", skipRows=").$(rowsRemainInCurrentSegment).$(", rowCount=").$(uncommittedRows).I$();
                    } else {
                        int existingType = this.metadata.getColumnType(convertColumnIndex);
                        LOG.info().$("rolling uncommitted rows to new segment with type conversion [wal=").$(this.path).$(Files.SEPARATOR).$(oldSegmentId).$(", lastSegmentTxn=").$(this.lastSegmentTxn).$(", newSegmentId=").$(newSegmentId).$(", skipRows=").$(rowsRemainInCurrentSegment).$(", rowCount=").$(uncommittedRows).$(", existingType=").$(ColumnType.nameOf(existingType)).$(", newType=").$(ColumnType.nameOf(convertToColumnType)).I$();
                    }
                    int commitMode = this.configuration.getCommitMode();
                    for (int columnIndex = 0; columnIndex < columnsToRoll; ++columnIndex) {
                        columnRollSink.nextColumn();
                        int columnType = this.metadata.getColumnType(columnIndex);
                        if (columnType > 0) {
                            MemoryMA primaryColumn = this.getDataColumn(columnIndex);
                            MemoryMA secondaryColumn = this.getAuxColumn(columnIndex);
                            String columnName = this.metadata.getColumnName(columnIndex);
                            SymbolMapWriterLite symbolMapWriter = null;
                            SymbolTable symbolTable = null;
                            if (columnIndex == convertColumnIndex) {
                                if (ColumnType.isSymbol(convertToColumnType)) {
                                    symbolMapWriter = this.getConversionSymbolMapWriter(this.columnCount - 1);
                                }
                                if (ColumnType.isSymbol(columnType)) {
                                    symbolTable = this.getConversionSymbolMapReader(columnIndex);
                                }
                            }
                            int colType = columnIndex == timestampIndex ? -columnType : columnType;
                            int newColumnType = columnIndex == convertColumnIndex ? convertToColumnType : colType;
                            CopyWalSegmentUtils.rollColumnToSegment(this.ff, this.configuration.getWriterFileOpenOpts(), primaryColumn, secondaryColumn, this.path, newSegmentId, columnName, colType, this.currentTxnStartRowNum, uncommittedRows, columnRollSink, commitMode, newColumnType, symbolTable, symbolMapWriter);
                            continue;
                        }
                        this.rowValueIsNotNull.setQuick(columnIndex, Long.MAX_VALUE);
                    }
                }
                catch (Throwable e) {
                    this.closeSegmentSwitchFiles(columnRollSink);
                    throw e;
                }
                this.switchColumnsToNewSegment(columnRollSink, columnsToRoll, convertColumnIndex);
                this.rollLastWalEventRecord(newSegmentId, uncommittedRows);
                this.segmentId = newSegmentId;
                this.segmentRowCount = uncommittedRows;
                this.currentTxnStartRowNum = 0L;
            }
            finally {
                this.releaseSegmentLock(oldSegmentId, oldSegmentLockFd, oldLastSegmentTxn);
            }
        }
        if (this.segmentRowCount > 0L && uncommittedRows == 0L) {
            this.rollSegmentOnNextRow = true;
        }
    }

    @Override
    public void rollback() {
        try {
            if (!this.isDistressed() && (this.inTransaction() || this.hasDirtyColumns(this.currentTxnStartRowNum))) {
                this.setAppendPosition(this.currentTxnStartRowNum);
                this.segmentRowCount = this.currentTxnStartRowNum;
                this.txnMinTimestamp = Long.MAX_VALUE;
                this.txnMaxTimestamp = -1L;
                this.txnOutOfOrder = false;
            }
        }
        catch (Throwable th) {
            this.distressed = true;
            throw th;
        }
    }

    public void setLegacyMatViewFormat(boolean legacyMatViewFormat) {
        this.events.setLegacyMatViewFormat(legacyMatViewFormat);
    }

    @Override
    public boolean supportsMultipleWriters() {
        return true;
    }

    public String toString() {
        return "WalWriter{name=" + this.walName + ", table=" + this.tableToken.getTableName() + "}";
    }

    @Override
    public void truncate() {
        throw new UnsupportedOperationException("cannot truncate symbol tables on WAL table");
    }

    @Override
    public void truncateSoft() {
        try {
            this.lastSegmentTxn = this.events.truncate();
            this.getSequencerTxn();
        }
        catch (Throwable th) {
            this.rollback();
            throw th;
        }
    }

    public void updateTableToken(TableToken ignoredTableToken) {
    }

    private static void configureNullSetters(ObjList<Runnable> nullers, int type, MemoryMA dataMem, MemoryMA auxMem) {
        short columnTag = ColumnType.tagOf(type);
        if (ColumnType.isVarSize(columnTag)) {
            ColumnTypeDriver typeDriver = ColumnType.getDriver(columnTag);
            nullers.add(() -> typeDriver.appendNull(auxMem, dataMem));
        } else {
            switch (columnTag) {
                case 1: 
                case 2: {
                    nullers.add(() -> dataMem.putByte((byte)0));
                    break;
                }
                case 10: {
                    nullers.add(() -> dataMem.putDouble(Double.NaN));
                    break;
                }
                case 9: {
                    nullers.add(() -> dataMem.putFloat(Float.NaN));
                    break;
                }
                case 5: {
                    nullers.add(() -> dataMem.putInt(Integer.MIN_VALUE));
                    break;
                }
                case 25: {
                    nullers.add(() -> dataMem.putInt(0));
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    nullers.add(() -> dataMem.putLong(Long.MIN_VALUE));
                    break;
                }
                case 13: {
                    nullers.add(() -> dataMem.putLong256(Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE));
                    break;
                }
                case 3: {
                    nullers.add(() -> dataMem.putShort((short)0));
                    break;
                }
                case 4: {
                    nullers.add(() -> dataMem.putChar('\u0000'));
                    break;
                }
                case 12: {
                    nullers.add(() -> dataMem.putInt(Integer.MIN_VALUE));
                    break;
                }
                case 14: {
                    nullers.add(() -> dataMem.putByte((byte)-1));
                    break;
                }
                case 15: {
                    nullers.add(() -> dataMem.putShort((short)-1));
                    break;
                }
                case 16: {
                    nullers.add(() -> dataMem.putInt(-1));
                    break;
                }
                case 17: {
                    nullers.add(() -> dataMem.putLong(-1L));
                    break;
                }
                case 19: 
                case 24: {
                    nullers.add(() -> dataMem.putLong128(Long.MIN_VALUE, Long.MIN_VALUE));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported column type: " + ColumnType.nameOf(type));
                }
            }
        }
    }

    private static void freeNullSetter(ObjList<Runnable> nullSetters, int columnIndex) {
        nullSetters.setQuick(columnIndex, NOOP);
    }

    private static int getAuxColumnOffset(int index) {
        return WalWriter.getDataColumnOffset(index) + 1;
    }

    private static int getDataColumnOffset(int columnIndex) {
        return columnIndex * 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long acquireSegmentLock() {
        int segmentPathLen = this.path.size();
        try {
            TableUtils.lockName(this.path);
            long segmentLockFd = TableUtils.lock(this.ff, this.path.$());
            if (segmentLockFd == -1L) {
                this.path.trimTo(segmentPathLen);
                throw CairoException.critical(this.ff.errno()).put("Cannot lock wal segment: ").put(this.path);
            }
            long l = segmentLockFd;
            return l;
        }
        finally {
            this.path.trimTo(segmentPathLen);
        }
    }

    private void addColumn(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isDedupKey, SecurityContext securityContext) {
        this.alterOp.clear();
        this.alterOp.ofAddColumn(this.getMetadata().getTableId(), this.tableToken, 0, columnName, 0, columnType, symbolCapacity, symbolCacheFlag, isIndexed, indexValueBlockCapacity, isDedupKey);
        this.alterOp.withSecurityContext(securityContext);
        this.apply(this.alterOp, true);
    }

    private void applyMetadataChangeLog(long structureVersionHi) {
        try (TableMetadataChangeLog log = this.sequencer.getMetadataChangeLog(this.tableToken, this.getColumnStructureVersion());){
            long structVer = this.getColumnStructureVersion();
            while (log.hasNext() && structVer < structureVersionHi) {
                TableMetadataChange chg = log.next();
                try {
                    chg.apply(this.metaWriterSvc, true);
                }
                catch (CairoException e) {
                    this.distressed = true;
                    throw e;
                }
                if (++structVer == this.getColumnStructureVersion()) continue;
                this.distressed = true;
                throw CairoException.critical(0).put("could not apply table definition changes to the current transaction, version unchanged");
            }
        }
    }

    private long applyNonStructural(AbstractOperation op, boolean verifyStructureVersion) {
        if (op.getSqlExecutionContext() == null) {
            throw CairoException.critical(0).put("failed to commit ALTER SQL to WAL, sql context is empty [table=").put(this.tableToken.getTableName()).put(']');
        }
        if (verifyStructureVersion && op.getTableVersion() != this.getColumnStructureVersion() || op.getTableId() != this.metadata.getTableId()) {
            throw TableReferenceOutOfDateException.of(this.tableToken, this.metadata.getTableId(), op.getTableId(), this.getColumnStructureVersion(), op.getTableVersion());
        }
        try {
            this.lastSegmentTxn = this.events.appendSql(op.getCmdType(), op.getSqlText(), op.getSqlExecutionContext());
            return this.getSequencerTxn();
        }
        catch (Throwable th) {
            this.distressed = true;
            throw th;
        }
    }

    private long applyStructural(AlterOperation alterOp) {
        long txn;
        do {
            boolean retry = true;
            try {
                this.metaValidatorSvc.startAlterValidation();
                alterOp.apply(this.metaValidatorSvc, true);
                if (this.metaValidatorSvc.structureVersion != this.getColumnStructureVersion() + 1L) {
                    retry = false;
                    throw CairoException.nonCritical().put("statement is either no-op,").put(" or contains multiple transactions, such as 'alter table add column col1, col2',").put(" and currently not supported for WAL tables [table=").put(this.tableToken.getTableName()).put(", oldStructureVersion=").put(this.getColumnStructureVersion()).put(", newStructureVersion=").put(this.metaValidatorSvc.structureVersion).put(']');
                }
            }
            catch (CairoException e) {
                if (retry) {
                    this.goActive();
                    alterOp.apply(this.metaValidatorSvc, true);
                }
                throw e;
            }
            try {
                txn = this.sequencer.nextStructureTxn(this.tableToken, this.getColumnStructureVersion(), alterOp);
                if (txn != Long.MIN_VALUE) continue;
                this.applyMetadataChangeLog(Long.MAX_VALUE);
            }
            catch (CairoException e) {
                this.distressed = true;
                throw e;
            }
        } while (txn == Long.MIN_VALUE);
        try {
            alterOp.apply(this.metaWriterSvc, true);
            LOG.info().$("committed structural metadata change [wal=").$(this.path).$(Files.SEPARATOR).$(this.segmentId).$(", segmentTxn=").$(this.lastSegmentTxn).$(", seqTxn=").$(txn).I$();
        }
        catch (Throwable th) {
            LOG.critical().$("Exception during alter [ex=").$(th).I$();
            this.distressed = true;
            throw th;
        }
        this.lastSeqTxn = txn;
        return this.lastSeqTxn;
    }

    private boolean breachedRolloverSizeThreshold() {
        long threshold = this.configuration.getWalSegmentRolloverSize();
        if (threshold == 0L) {
            return false;
        }
        if (this.avgRecordSize != 0L) {
            return this.segmentRowCount * this.avgRecordSize > threshold;
        }
        long tally = 0L;
        int colCount = this.columns.size();
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            MemoryMA column = this.columns.getQuick(colIndex);
            if (column == null || column instanceof NullMemory) continue;
            long columnSize = column.getAppendOffset();
            tally += columnSize;
        }
        tally += this.events.size();
        if (this.totalSegmentsRowCount + this.segmentRowCount > 1000L) {
            this.avgRecordSize = (this.totalSegmentsSize + tally) / (this.totalSegmentsRowCount + this.segmentRowCount);
        }
        return tally > threshold;
    }

    private void checkDistressed() {
        if (!this.distressed) {
            return;
        }
        throw CairoException.critical(0).put("WAL writer is distressed and cannot be used any more [table=").put(this.tableToken.getTableName()).put(", wal=").put(this.walId).put(']');
    }

    private void closeSegmentSwitchFiles(SegmentColumnRollSink newColumnFiles) {
        int commitMode = this.configuration.getCommitMode();
        int n = newColumnFiles.count();
        for (int columnIndex = 0; columnIndex < n; ++columnIndex) {
            long primaryFd = newColumnFiles.getDestPrimaryFd(columnIndex);
            if (commitMode != 2) {
                this.ff.fsyncAndClose(primaryFd);
            } else {
                this.ff.close(primaryFd);
            }
            long secondaryFd = newColumnFiles.getDestAuxFd(columnIndex);
            if (commitMode != 2) {
                this.ff.fsyncAndClose(secondaryFd);
                continue;
            }
            this.ff.close(secondaryFd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit0(byte txnType, long lastRefreshBaseTxn, long lastRefreshTimestamp, long lastPeriodHi, long replaceRangeLowTs, long replaceRangeHiTs, byte dedupMode) {
        block11: {
            this.checkDistressed();
            try {
                if (!this.inTransaction() && dedupMode != 3) break block11;
                long rowsToCommit = this.getUncommittedRowCount();
                this.isCommittingData = true;
                this.lastTxnType = txnType;
                this.lastReplaceRangeLowTs = replaceRangeLowTs;
                this.lastReplaceRangeHiTs = replaceRangeHiTs;
                this.lastDedupMode = dedupMode;
                this.lastMatViewRefreshBaseTxn = lastRefreshBaseTxn;
                this.lastMatViewRefreshTimestamp = lastRefreshTimestamp;
                this.lastMatViewPeriodHi = lastPeriodHi;
                this.lastSegmentTxn = this.events.appendData(txnType, this.currentTxnStartRowNum, this.segmentRowCount, this.txnMinTimestamp, this.txnMaxTimestamp, this.txnOutOfOrder, lastRefreshBaseTxn, lastRefreshTimestamp, lastPeriodHi, replaceRangeLowTs, replaceRangeHiTs, dedupMode);
                this.syncIfRequired();
                long seqTxn = this.getSequencerTxn();
                LogRecord logLine = LOG.info();
                try {
                    logLine.$("commit [wal=").$substr(this.pathRootSize, this.path).$(Files.SEPARATOR).$(this.segmentId).$(", segTxn=").$(this.lastSegmentTxn).$(", seqTxn=").$(seqTxn).$(", rowLo=").$(this.currentTxnStartRowNum).$(", rowHi=").$(this.segmentRowCount).$(", minTs=").$ts(this.txnMinTimestamp).$(", maxTs=").$ts(this.txnMaxTimestamp);
                    if (replaceRangeHiTs > replaceRangeLowTs) {
                        logLine.$(", replaceRangeLo=").$ts(replaceRangeLowTs).$(", replaceRangeHi=").$ts(replaceRangeHiTs);
                    }
                }
                finally {
                    logLine.I$();
                }
                this.resetDataTxnProperties();
                this.mayRollSegmentOnNextRow();
                this.metrics.walMetrics().addRowsWritten(rowsToCommit);
            }
            catch (CairoException ex) {
                this.distressed = true;
                throw ex;
            }
            catch (Throwable th) {
                if (!this.isDistressed()) {
                    this.rollback();
                }
                throw th;
            }
            finally {
                this.isCommittingData = false;
            }
        }
    }

    private void configureColumn(int columnIndex, int columnType) {
        int dataColumnOffset = WalWriter.getDataColumnOffset(columnIndex);
        if (columnType > 0) {
            MemoryMAR dataMem = Vm.getPMARInstance(this.configuration);
            MemoryMA auxMem = this.createAuxColumnMem(columnType);
            this.columns.extendAndSet(dataColumnOffset, dataMem);
            this.columns.extendAndSet(dataColumnOffset + 1, auxMem);
            WalWriter.configureNullSetters(this.nullSetters, columnType, dataMem, auxMem);
            this.rowValueIsNotNull.add(-1L);
        } else {
            this.columns.extendAndSet(dataColumnOffset, NullMemory.INSTANCE);
            this.columns.extendAndSet(dataColumnOffset + 1, NullMemory.INSTANCE);
            this.nullSetters.add(NOOP);
            this.rowValueIsNotNull.add(Long.MAX_VALUE);
        }
    }

    private void configureColumns() {
        for (int i = 0; i < this.columnCount; ++i) {
            this.configureColumn(i, this.metadata.getColumnType(i));
        }
    }

    private void configureEmptySymbol(int columnWriterIndex) {
        this.symbolMapReaders.extendAndSet(columnWriterIndex, EmptySymbolMapReader.INSTANCE);
        this.initialSymbolCounts.extendAndSet(columnWriterIndex, 0);
        this.localSymbolIds.extendAndSet(columnWriterIndex, 0);
        this.symbolMapNullFlags.extendAndSet(columnWriterIndex, false);
        this.symbolMaps.extendAndSet(columnWriterIndex, new CharSequenceIntHashMap(8, 0.5, -2));
        this.utf8SymbolMaps.extendAndSet(columnWriterIndex, new Utf8StringIntHashMap(8, 0.5, -2));
    }

    private void configureSymbolMapWriter(int columnWriterIndex, CharSequence columnName, int symbolCount, long columnNameTxn) {
        if (symbolCount == 0) {
            this.configureEmptySymbol(columnWriterIndex);
            return;
        }
        FilesFacade ff = this.configuration.getFilesFacade();
        Path tempPath = Path.PATH.get();
        tempPath.of(this.configuration.getDbRoot()).concat(this.tableToken);
        int tempPathTripLen = tempPath.size();
        this.path.trimTo(this.pathSize);
        TableUtils.offsetFileName(tempPath, columnName, columnNameTxn);
        TableUtils.offsetFileName(this.path, columnName, -1L);
        if (-1 == ff.hardLink(tempPath.$(), this.path.$())) {
            LOG.info().$("failed to link offset file [from=").$(tempPath).$(", to=").$(this.path).$(", errno=").$(ff.errno()).I$();
            this.configureEmptySymbol(columnWriterIndex);
            return;
        }
        tempPath.trimTo(tempPathTripLen);
        this.path.trimTo(this.pathSize);
        TableUtils.charFileName(tempPath, columnName, columnNameTxn);
        TableUtils.charFileName(this.path, columnName, -1L);
        if (-1 == ff.hardLink(tempPath.$(), this.path.$())) {
            LOG.info().$("failed to link char file [from=").$(tempPath).$(", to=").$(this.path).$(", errno=").$(ff.errno()).I$();
            this.removeSymbolFiles(this.path, this.pathSize, columnName);
            this.configureEmptySymbol(columnWriterIndex);
            return;
        }
        tempPath.trimTo(tempPathTripLen);
        this.path.trimTo(this.pathSize);
        BitmapIndexUtils.keyFileName(tempPath, columnName, columnNameTxn);
        BitmapIndexUtils.keyFileName(this.path, columnName, -1L);
        if (-1 == ff.hardLink(tempPath.$(), this.path.$())) {
            LOG.info().$("failed to link key file [from=").$(tempPath).$(", to=").$(this.path).$(", errno=").$(ff.errno()).I$();
            this.removeSymbolFiles(this.path, this.pathSize, columnName);
            this.configureEmptySymbol(columnWriterIndex);
            return;
        }
        tempPath.trimTo(tempPathTripLen);
        this.path.trimTo(this.pathSize);
        BitmapIndexUtils.valueFileName(tempPath, columnName, columnNameTxn);
        BitmapIndexUtils.valueFileName(this.path, columnName, -1L);
        if (-1 == ff.hardLink(tempPath.$(), this.path.$())) {
            LOG.info().$("failed to link value file [from=").$(tempPath).$(", to=").$(this.path).$(", errno=").$(ff.errno()).I$();
            this.removeSymbolFiles(this.path, this.pathSize, columnName);
            this.configureEmptySymbol(columnWriterIndex);
            return;
        }
        this.path.trimTo(this.pathSize);
        SymbolMapReaderImpl symbolMapReader = new SymbolMapReaderImpl(this.configuration, this.path, columnName, -1L, symbolCount);
        this.symbolMapReaders.extendAndSet(columnWriterIndex, symbolMapReader);
        this.symbolMaps.extendAndSet(columnWriterIndex, new CharSequenceIntHashMap(8, 0.5, -2));
        this.utf8SymbolMaps.extendAndSet(columnWriterIndex, new Utf8StringIntHashMap(8, 0.5, -2));
        this.initialSymbolCounts.extendAndSet(columnWriterIndex, symbolCount);
        this.localSymbolIds.extendAndSet(columnWriterIndex, 0);
        this.symbolMapNullFlags.extendAndSet(columnWriterIndex, symbolMapReader.containsNullValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureSymbolTable() {
        boolean initialized = false;
        try {
            int denseSymbolIndex = 0;
            for (int i = 0; i < this.columnCount; ++i) {
                int columnType = this.metadata.getColumnType(i);
                if (!ColumnType.isSymbol(columnType)) {
                    this.symbolMapReaders.extendAndSet(i, null);
                    this.symbolMaps.extendAndSet(i, null);
                    this.utf8SymbolMaps.extendAndSet(i, null);
                } else {
                    if (this.txReader == null) {
                        this.txReader = new TxReader(this.ff);
                        this.columnVersionReader = new ColumnVersionReader();
                    }
                    if (!initialized) {
                        MillisecondClock milliClock = this.configuration.getMillisecondClock();
                        long spinLockTimeout = this.configuration.getSpinLockTimeout();
                        Path path = Path.PATH2.get();
                        path.of(this.configuration.getDbRoot()).concat(this.tableToken).concat("_txn");
                        this.txReader.ofRO(path.$(), 0);
                        path.of(this.configuration.getDbRoot()).concat(this.tableToken).concat("_cv");
                        this.columnVersionReader.ofRO(this.ff, path.$());
                        initialized = true;
                        long structureVersion = this.getMetadataVersion();
                        do {
                            TableUtils.safeReadTxn(this.txReader, milliClock, spinLockTimeout);
                            if ((long)this.txReader.getColumnStructureVersion() != structureVersion) {
                                initialized = false;
                                break;
                            }
                            this.columnVersionReader.readSafe(milliClock, spinLockTimeout);
                        } while (this.txReader.getColumnVersion() != this.columnVersionReader.getVersion());
                    }
                    if (initialized) {
                        int symbolValueCount = this.txReader.getSymbolValueCount(denseSymbolIndex);
                        long columnNameTxn = this.columnVersionReader.getDefaultColumnNameTxn(i);
                        this.configureSymbolMapWriter(i, this.metadata.getColumnName(i), symbolValueCount, columnNameTxn);
                    } else {
                        this.configureSymbolMapWriter(i, this.metadata.getColumnName(i), 0, -1L);
                    }
                }
                if (columnType != 12) continue;
                ++denseSymbolIndex;
            }
        }
        finally {
            Misc.free(this.columnVersionReader);
            Misc.free(this.txReader);
        }
    }

    private MemoryMA createAuxColumnMem(int columnType) {
        return ColumnType.isVarSize(columnType) ? Vm.getPMARInstance(this.configuration) : null;
    }

    private SegmentColumnRollSink createSegmentColumnRollSink() {
        if (this.columnConversionSink == null) {
            this.columnConversionSink = new SegmentColumnRollSink();
        } else {
            this.columnConversionSink.clear();
        }
        return this.columnConversionSink;
    }

    private int createSegmentDir(int segmentId) {
        this.path.trimTo(this.pathSize);
        this.path.slash().put(segmentId);
        int segmentPathLen = this.path.size();
        this.segmentLockFd = this.acquireSegmentLock();
        if (this.ff.mkdirs(this.path.slash(), this.mkDirMode) != 0) {
            throw CairoException.critical(this.ff.errno()).put("Cannot create WAL segment directory: ").put(this.path);
        }
        this.walDirectoryPolicy.initDirectory(this.path);
        this.path.trimTo(segmentPathLen);
        return segmentPathLen;
    }

    private void freeAndRemoveColumnPair(ObjList<MemoryMA> columns, int pi, int si) {
        MemoryMA primaryColumn = columns.getAndSetQuick(pi, null);
        MemoryMA secondaryColumn = columns.getAndSetQuick(si, null);
        primaryColumn.close(this.isTruncateFilesOnClose(), (byte)1);
        if (secondaryColumn != null) {
            secondaryColumn.close(this.isTruncateFilesOnClose(), (byte)1);
        }
    }

    private void freeColumns(boolean truncate) {
        if (this.columns != null) {
            int n = this.columns.size();
            for (int i = 0; i < n; ++i) {
                MemoryMA m = this.columns.getQuick(i);
                if (m == null) continue;
                m.close(truncate, (byte)1);
            }
        }
    }

    private void freeSymbolMapReaders() {
        Misc.freeObjListIfCloseable(this.symbolMapReaders);
    }

    private MemoryMA getAuxColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(WalWriter.getAuxColumnOffset(column));
    }

    private long getColumnStructureVersion() {
        return this.metadata.getMetadataVersion();
    }

    private SymbolTable getConversionSymbolMapReader(int columnIndex) {
        if (this.conversionSymbolTable == null) {
            this.conversionSymbolTable = new ConversionSymbolTable();
        }
        this.conversionSymbolTable.of(this, columnIndex);
        return this.conversionSymbolTable;
    }

    private SymbolMapWriterLite getConversionSymbolMapWriter(int columnIndex) {
        if (this.conversionSymbolMap == null) {
            this.conversionSymbolMap = new ConversionSymbolMapWriter();
        }
        this.conversionSymbolMap.of(this, columnIndex);
        return this.conversionSymbolMap;
    }

    private long getDataAppendPageSize() {
        return this.tableToken.isSystem() ? this.configuration.getSystemWalDataAppendPageSize() : this.configuration.getWalDataAppendPageSize();
    }

    private MemoryMA getDataColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(WalWriter.getDataColumnOffset(column));
    }

    private long getSequencerTxn() {
        long seqTxn;
        do {
            if ((seqTxn = this.sequencer.nextTxn(this.tableToken, this.walId, this.getColumnStructureVersion(), this.segmentId, this.lastSegmentTxn, this.txnMinTimestamp, this.txnMaxTimestamp, this.segmentRowCount - this.currentTxnStartRowNum)) != Long.MIN_VALUE) continue;
            this.applyMetadataChangeLog(Long.MAX_VALUE);
        } while (seqTxn == Long.MIN_VALUE);
        this.lastSeqTxn = seqTxn;
        return this.lastSeqTxn;
    }

    private boolean hasDirtyColumns(long currentTxnStartRowNum) {
        for (int i = 0; i < this.columnCount; ++i) {
            long writtenCount = this.rowValueIsNotNull.getQuick(i);
            if (writtenCount < currentTxnStartRowNum || writtenCount == Long.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    private boolean isTruncateFilesOnClose() {
        return this.walDirectoryPolicy.truncateFilesOnClose();
    }

    private void lockWal() {
        try {
            TableUtils.lockName(this.path);
            this.walLockFd = TableUtils.lock(this.ff, this.path.$());
        }
        finally {
            this.path.trimTo(this.pathSize);
        }
        if (this.walLockFd == -1L) {
            throw CairoException.critical(this.ff.errno()).put("cannot lock table: ").put(this.path.$());
        }
    }

    private void markColumnRemoved(int columnIndex, int columnType) {
        if (ColumnType.isSymbol(columnType)) {
            this.removeSymbolMapReader(columnIndex);
        }
        int pi = WalWriter.getDataColumnOffset(columnIndex);
        int si = WalWriter.getAuxColumnOffset(columnIndex);
        WalWriter.freeNullSetter(this.nullSetters, columnIndex);
        this.freeAndRemoveColumnPair(this.columns, pi, si);
        this.rowValueIsNotNull.setQuick(columnIndex, Long.MAX_VALUE);
    }

    private void mayRollSegmentOnNextRow() {
        if (this.rollSegmentOnNextRow) {
            return;
        }
        this.rollSegmentOnNextRow = this.segmentRowCount >= this.configuration.getWalSegmentRolloverRowCount() || this.breachedRolloverSizeThreshold() || this.lastSegmentTxn > 0x7FFFFFFD;
    }

    private void mkWalDir() {
        int walDirLength = this.path.size();
        if (this.ff.mkdirs(this.path.slash(), this.mkDirMode) != 0) {
            throw CairoException.critical(this.ff.errno()).put("Cannot create WAL directory: ").put(this.path);
        }
        this.path.trimTo(walDirLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openColumnFiles(CharSequence columnName, int columnType, int columnIndex, int pathTrimToLen) {
        try {
            MemoryMA dataMem = this.getDataColumn(columnIndex);
            this.totalSegmentsSize += dataMem.getAppendOffset();
            dataMem.close(this.isTruncateFilesOnClose(), (byte)1);
            dataMem.of(this.ff, TableUtils.dFile(this.path.trimTo(pathTrimToLen), columnName), this.getDataAppendPageSize(), -1L, 11, this.configuration.getWriterFileOpenOpts(), Files.POSIX_MADV_RANDOM);
            MemoryMA auxMem = this.getAuxColumn(columnIndex);
            if (auxMem != null) {
                this.totalSegmentsSize += auxMem.getAppendOffset();
                auxMem.close(this.isTruncateFilesOnClose(), (byte)1);
                ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
                columnTypeDriver.configureAuxMemMA(this.ff, auxMem, TableUtils.iFile(this.path.trimTo(pathTrimToLen), columnName), this.getDataAppendPageSize(), 11, this.configuration.getWriterFileOpenOpts(), Files.POSIX_MADV_RANDOM);
            }
        }
        finally {
            this.path.trimTo(pathTrimToLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewSegment() {
        int oldSegmentId = this.segmentId;
        int newSegmentId = this.segmentId + 1;
        long oldSegmentLockFd = this.segmentLockFd;
        this.segmentLockFd = -1L;
        long oldLastSegmentTxn = this.lastSegmentTxn;
        try {
            this.totalSegmentsRowCount += Math.max(0L, this.segmentRowCount);
            this.currentTxnStartRowNum = 0L;
            this.rowValueIsNotNull.fill(0, this.columnCount, -1L);
            int segmentPathLen = this.createSegmentDir(newSegmentId);
            this.segmentId = newSegmentId;
            int commitMode = this.configuration.getCommitMode();
            long dirFd = Os.isWindows() || commitMode == 2 ? -1L : TableUtils.openRONoCache(this.ff, this.path.$(), LOG);
            for (int i = 0; i < this.columnCount; ++i) {
                int columnType = this.metadata.getColumnType(i);
                if (columnType > 0) {
                    String columnName = this.metadata.getColumnName(i);
                    this.openColumnFiles(columnName, columnType, i, segmentPathLen);
                    if (columnType != 12 || this.symbolMapReaders.size() <= 0) continue;
                    SymbolMapReader reader = this.symbolMapReaders.getQuick(i);
                    this.initialSymbolCounts.set(i, reader.getSymbolCount());
                    this.localSymbolIds.set(i, 0);
                    this.symbolMapNullFlags.set(i, reader.containsNullValue());
                    this.symbolMaps.getQuick(i).clear();
                    this.utf8SymbolMaps.getQuick(i).clear();
                    continue;
                }
                this.rowValueIsNotNull.setQuick(i, Long.MAX_VALUE);
            }
            this.segmentRowCount = 0L;
            this.metadata.switchTo(this.path, segmentPathLen, this.isTruncateFilesOnClose());
            this.totalSegmentsSize += this.events.size();
            this.events.openEventFile(this.path, segmentPathLen, this.isTruncateFilesOnClose(), this.tableToken.isSystem());
            if (commitMode != 2) {
                this.events.sync();
            }
            if (dirFd != -1L) {
                this.ff.fsyncAndClose(dirFd);
            }
            this.lastSegmentTxn = -1;
            LOG.info().$("opened WAL segment [path=").$substr(this.pathRootSize, this.path.parent()).I$();
        }
        finally {
            if (oldSegmentLockFd > -1L) {
                this.releaseSegmentLock(oldSegmentId, oldSegmentLockFd, oldLastSegmentTxn);
            }
            this.path.trimTo(this.pathSize);
        }
    }

    private void releaseSegmentLock(int segmentId, long segmentLockFd, long segmentTxn) {
        if (this.ff.close(segmentLockFd)) {
            if (segmentTxn >= 0L) {
                this.sequencer.notifySegmentClosed(this.tableToken, this.lastSeqTxn, this.walId, segmentId);
                LOG.debug().$("released segment lock [walId=").$(this.walId).$(", segmentId=").$(segmentId).$(", fd=").$(segmentLockFd).$(']').$();
            } else {
                this.path.trimTo(this.pathSize).slash().put(segmentId);
                this.walDirectoryPolicy.rollbackDirectory(this.path);
                this.path.trimTo(this.pathSize);
            }
        } else {
            LOG.error().$("cannot close segment lock fd [walId=").$(this.walId).$(", segmentId=").$(segmentId).$(", fd=").$(segmentLockFd).$(", errno=").$(this.ff.errno()).I$();
        }
    }

    private void releaseWalLock() {
        if (this.ff.close(this.walLockFd)) {
            this.walLockFd = -1L;
            LOG.debug().$("released WAL lock [walId=").$(this.walId).$(", fd=").$(this.walLockFd).$(']').$();
        } else {
            LOG.error().$("cannot close WAL lock fd [walId=").$(this.walId).$(", fd=").$(this.walLockFd).$(", errno=").$(this.ff.errno()).I$();
        }
    }

    private void removeSymbolFiles(Path path, int rootLen, CharSequence columnName) {
        path.trimTo(rootLen);
        BitmapIndexUtils.valueFileName(path, columnName, -1L);
        this.ff.removeQuiet(path.$());
        path.trimTo(rootLen);
        BitmapIndexUtils.keyFileName(path, columnName, -1L);
        this.ff.removeQuiet(path.$());
        path.trimTo(rootLen);
        TableUtils.charFileName(path, columnName, -1L);
        this.ff.removeQuiet(path.$());
        path.trimTo(rootLen);
        TableUtils.offsetFileName(path, columnName, -1L);
        this.ff.removeQuiet(path.$());
    }

    private void removeSymbolMapReader(int index) {
        Misc.freeIfCloseable(this.symbolMapReaders.getAndSetQuick(index, null));
        this.symbolMaps.setQuick(index, null);
        this.utf8SymbolMaps.setQuick(index, null);
        this.initialSymbolCounts.set(index, -1);
        this.localSymbolIds.set(index, 0);
        this.symbolMapNullFlags.set(index, false);
        this.removeSymbolFiles(this.path, this.pathSize, this.metadata.getColumnName(index));
    }

    private void renameColumnFiles(int columnType, CharSequence columnName, CharSequence newName) {
        this.path.trimTo(this.pathSize).slash().put(this.segmentId);
        Path tempPath = Path.PATH.get().of(this.path);
        if (ColumnType.isVarSize(columnType)) {
            int trimTo = this.path.size();
            TableUtils.iFile(this.path, columnName);
            TableUtils.iFile(tempPath, newName);
            if (this.ff.rename(this.path.$(), tempPath.$()) != 0) {
                throw CairoException.critical(this.ff.errno()).put("could not rename WAL column file [from=").put(this.path).put(", to=").put(tempPath).put(']');
            }
            this.path.trimTo(trimTo);
            tempPath.trimTo(trimTo);
        }
        TableUtils.dFile(this.path, columnName);
        TableUtils.dFile(tempPath, newName);
        if (this.ff.rename(this.path.$(), tempPath.$()) != 0) {
            throw CairoException.critical(this.ff.errno()).put("could not rename WAL column file [from=").put(this.path).put(", to=").put(tempPath).put(']');
        }
    }

    private void resetDataTxnProperties() {
        this.currentTxnStartRowNum = this.segmentRowCount;
        this.txnMinTimestamp = Long.MAX_VALUE;
        this.txnMaxTimestamp = -1L;
        this.txnOutOfOrder = false;
        this.resetSymbolMaps();
    }

    private void resetSymbolMaps() {
        int numOfColumns = this.symbolMaps.size();
        for (int i = 0; i < numOfColumns; ++i) {
            SymbolMapReader reader;
            Utf8StringIntHashMap dbcsSymbolMap;
            CharSequenceIntHashMap symbolMap = this.symbolMaps.getQuick(i);
            if (symbolMap != null) {
                symbolMap.clear();
            }
            if ((dbcsSymbolMap = this.utf8SymbolMaps.getQuick(i)) != null) {
                dbcsSymbolMap.clear();
            }
            if ((reader = this.symbolMapReaders.getQuick(i)) == null) continue;
            this.initialSymbolCounts.set(i, reader.getSymbolCount());
            this.localSymbolIds.set(i, 0);
            this.symbolMapNullFlags.set(i, reader.containsNullValue());
        }
    }

    private void rollLastWalEventRecord(int newSegmentId, long uncommittedRows) {
        if (this.isCommittingData) {
            this.events.rollback();
        }
        this.path.trimTo(this.pathSize).slash().put(newSegmentId);
        this.events.openEventFile(this.path, this.path.size(), this.isTruncateFilesOnClose(), this.tableToken.isSystem());
        this.lastSegmentTxn = -1;
        if (this.isCommittingData) {
            this.lastSegmentTxn = this.events.appendData(this.lastTxnType, 0L, uncommittedRows, this.txnMinTimestamp, this.txnMaxTimestamp, this.txnOutOfOrder, this.lastMatViewRefreshBaseTxn, this.lastMatViewRefreshTimestamp, this.lastMatViewPeriodHi, this.lastReplaceRangeLowTs, this.lastReplaceRangeHiTs, this.lastDedupMode);
        }
        this.events.sync();
    }

    private void rowAppend(ObjList<Runnable> activeNullSetters, long rowTimestamp) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.rowValueIsNotNull.getQuick(i) >= this.segmentRowCount) continue;
            activeNullSetters.getQuick(i).run();
        }
        if (rowTimestamp > this.txnMaxTimestamp) {
            this.txnMaxTimestamp = rowTimestamp;
        } else {
            this.txnOutOfOrder |= this.txnMaxTimestamp != rowTimestamp;
        }
        if (rowTimestamp < this.txnMinTimestamp) {
            this.txnMinTimestamp = rowTimestamp;
        }
        ++this.segmentRowCount;
    }

    private void setAppendPosition(long segmentRowCount) {
        for (int i = 0; i < this.columnCount; ++i) {
            int type = this.metadata.getColumnType(i);
            if (type <= 0) continue;
            this.setAppendPosition0(i, segmentRowCount);
            this.rowValueIsNotNull.setQuick(i, segmentRowCount - 1L);
        }
    }

    private void setAppendPosition0(int columnIndex, long segmentRowCount) {
        MemoryMA dataMem = this.getDataColumn(columnIndex);
        MemoryMA auxMem = this.getAuxColumn(columnIndex);
        int columnType = this.metadata.getColumnType(columnIndex);
        if (columnType > 0) {
            long dataMemOffset;
            long rowCount = Math.max(0L, segmentRowCount);
            if (ColumnType.isVarSize(columnType)) {
                assert (auxMem != null);
                dataMemOffset = ColumnType.getDriver(columnType).setAppendAuxMemAppendPosition(auxMem, dataMem, columnType, rowCount);
            } else {
                dataMemOffset = rowCount << ColumnType.getWalDataColumnShl(columnType, columnIndex == this.metadata.getTimestampIndex());
            }
            dataMem.jumpTo(dataMemOffset);
        }
    }

    private void setColumnNull(int columnType, int columnIndex, long rowCount, int commitMode) {
        if (ColumnType.isVarSize(columnType)) {
            ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
            this.setVarColumnDataFileNull(columnTypeDriver, columnIndex, rowCount, commitMode);
            this.setVarColumnAuxFileNull(columnTypeDriver, columnIndex, rowCount, commitMode);
        } else {
            this.setFixColumnNulls(columnType, columnIndex, rowCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFixColumnNulls(int type, int columnIndex, long rowCount) {
        MemoryMA fixedSizeColumn = this.getDataColumn(columnIndex);
        long columnFileSize = rowCount * (long)ColumnType.sizeOf(type);
        fixedSizeColumn.jumpTo(columnFileSize);
        if (columnFileSize > 0L) {
            long address = TableUtils.mapRW(this.ff, fixedSizeColumn.getFd(), columnFileSize, 11);
            try {
                TableUtils.setNull(type, address, rowCount);
            }
            finally {
                this.ff.munmap(address, columnFileSize, 11);
            }
            this.ff.fsync(fixedSizeColumn.getFd());
        }
    }

    private void setRowValueNotNull(int columnIndex) {
        assert (this.rowValueIsNotNull.getQuick(columnIndex) != this.segmentRowCount);
        this.rowValueIsNotNull.setQuick(columnIndex, this.segmentRowCount);
    }

    private void setVarColumnAuxFileNull(ColumnTypeDriver columnTypeDriver, int columnIndex, long rowCount, int commitMode) {
        MemoryMA auxMem = this.getAuxColumn(columnIndex);
        long auxMemSize = columnTypeDriver.getAuxVectorSize(rowCount);
        auxMem.jumpTo(auxMemSize);
        if (rowCount > 0L) {
            long auxMemAddr = TableUtils.mapRW(this.ff, auxMem.getFd(), auxMemSize, 11);
            columnTypeDriver.setFullAuxVectorNull(auxMemAddr, rowCount);
            if (commitMode != 2) {
                this.ff.msync(auxMemAddr, auxMemSize, commitMode == 0);
            }
            this.ff.munmap(auxMemAddr, auxMemSize, 11);
        }
    }

    private void setVarColumnDataFileNull(ColumnTypeDriver columnTypeDriver, int columnIndex, long rowCount, int commitMode) {
        MemoryMA dataMem = this.getDataColumn(columnIndex);
        long varColSize = rowCount * columnTypeDriver.getDataVectorMinEntrySize();
        dataMem.jumpTo(varColSize);
        if (rowCount > 0L && varColSize > 0L) {
            long dataMemAddr = TableUtils.mapRW(this.ff, dataMem.getFd(), varColSize, 11);
            columnTypeDriver.setDataVectorEntriesToNull(dataMemAddr, rowCount);
            if (commitMode != 2) {
                this.ff.msync(dataMemAddr, varColSize, commitMode == 0);
            }
            this.ff.munmap(dataMemAddr, varColSize, 11);
        }
    }

    private void switchColumnsToNewSegment(SegmentColumnRollSink rollSink, int columnsToRoll, int convertColumnIndex) {
        for (int i = 0; i < columnsToRoll; ++i) {
            int columnType = this.metadata.getColumnType(i);
            if (columnType <= 0) continue;
            if (i != convertColumnIndex) {
                this.switchColumnsToNewSegmentRollColumn(rollSink, i, i);
                continue;
            }
            this.switchColumnsToNewSegmentRollColumn(rollSink, i, this.columnCount - 1);
        }
    }

    private void switchColumnsToNewSegmentRollColumn(SegmentColumnRollSink rollSink, int srcColumnIndex, int destColumnIndex) {
        long currentOffset = rollSink.getSrcPrimaryOffset(srcColumnIndex);
        MemoryMA primaryColumnFile = this.getDataColumn(srcColumnIndex);
        primaryColumnFile.jumpTo(currentOffset);
        primaryColumnFile.close(this.isTruncateFilesOnClose());
        MemoryMA auxColumn = this.getAuxColumn(srcColumnIndex);
        if (auxColumn != null) {
            long auxOffset = rollSink.getSrcAuxOffset(srcColumnIndex);
            auxColumn.jumpTo(auxOffset);
            auxColumn.close(this.isTruncateFilesOnClose());
        }
        long newSize = rollSink.getDestPrimarySize(srcColumnIndex);
        long newPrimaryFd = rollSink.getDestPrimaryFd(srcColumnIndex);
        MemoryMA destPrimeCol = this.getDataColumn(destColumnIndex);
        destPrimeCol.switchTo(this.ff, newPrimaryFd, this.getDataAppendPageSize(), newSize, this.isTruncateFilesOnClose(), (byte)1);
        long newSecondaryFd = rollSink.getDestAuxFd(srcColumnIndex);
        if (newSecondaryFd > -1L) {
            long secondarySize = rollSink.getDestAuxSize(srcColumnIndex);
            MemoryMA destAuxColumn = this.getAuxColumn(destColumnIndex);
            destAuxColumn.switchTo(this.ff, newSecondaryFd, this.getDataAppendPageSize(), secondarySize, this.isTruncateFilesOnClose(), (byte)1);
        }
    }

    private void syncIfRequired() {
        int commitMode = this.configuration.getCommitMode();
        if (commitMode != 2) {
            boolean async = commitMode == 0;
            int n = this.columns.size();
            for (int i = 0; i < n; ++i) {
                MemoryMA column = this.columns.getQuick(i);
                if (column == null) continue;
                column.sync(async);
            }
            this.events.sync();
        }
    }

    private class MetadataValidatorService
    implements MetadataServiceStub {
        public long structureVersion;

        private MetadataValidatorService() {
        }

        @Override
        public void addColumn(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isSequential, boolean isDedupKey, SecurityContext securityContext) {
            this.validateNewColumnName(columnName);
            this.validateNewColumnType(columnType);
            ++this.structureVersion;
        }

        @Override
        public void changeColumnType(CharSequence columnName, int newType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isSequential, SecurityContext securityContext) {
            int columnIndex = this.validateExistingColumnName(columnName, "cannot change type");
            this.validateNewColumnType(newType);
            int existingType = WalWriter.this.metadata.getColumnType(columnIndex);
            if (existingType == newType) {
                throw CairoException.nonCritical().put("column '").put(columnName).put("' type is already '").put(ColumnType.nameOf(newType)).put('\'');
            }
            ++this.structureVersion;
        }

        @Override
        public void disableDeduplication() {
            ++this.structureVersion;
        }

        @Override
        public boolean enableDeduplicationWithUpsertKeys(LongList columnsIndexes) {
            boolean isSubsetOfOldKeys = true;
            int n = columnsIndexes.size();
            for (int i = 0; i < n; ++i) {
                int columnIndex = (int)columnsIndexes.get(i);
                int columnType = WalWriter.this.metadata.getColumnType(columnIndex);
                if (columnType < 0) {
                    throw CairoException.nonCritical().put("cannot use dropped column for deduplication [column=").put(WalWriter.this.metadata.getColumnName(columnIndex)).put(']');
                }
                isSubsetOfOldKeys &= WalWriter.this.metadata.isDedupKey(columnIndex);
            }
            ++this.structureVersion;
            return isSubsetOfOldKeys;
        }

        @Override
        public TableRecordMetadata getMetadata() {
            return WalWriter.this.metadata;
        }

        @Override
        public TableToken getTableToken() {
            return WalWriter.this.tableToken;
        }

        @Override
        public void removeColumn(@NotNull CharSequence columnName) {
            this.validateExistingColumnName(columnName, "cannot remove");
            ++this.structureVersion;
        }

        @Override
        public void renameColumn(@NotNull CharSequence columnName, @NotNull CharSequence newName, SecurityContext securityContext) {
            this.validateExistingColumnName(columnName, "cannot rename");
            int columnIndexNew = WalWriter.this.metadata.getColumnIndexQuiet(newName);
            if (columnIndexNew > -1) {
                throw CairoException.nonCritical().put("cannot rename, column with the name already exists [table=").put(WalWriter.this.tableToken.getTableName()).put(", newName=").put(newName).put(']');
            }
            if (!TableUtils.isValidColumnName(newName, newName.length())) {
                throw CairoException.nonCritical().put("invalid column name: ").put(newName);
            }
            ++this.structureVersion;
        }

        @Override
        public void renameTable(@NotNull CharSequence fromNameTable, @NotNull CharSequence toTableName) {
            if (!Chars.equalsIgnoreCaseNc(fromNameTable, WalWriter.this.metadata.getTableToken().getTableName())) {
                throw CairoException.tableDoesNotExist(fromNameTable);
            }
            ++this.structureVersion;
        }

        public void startAlterValidation() {
            this.structureVersion = WalWriter.this.getColumnStructureVersion();
        }

        private int validateExistingColumnName(CharSequence columnName, String errorPrefix) {
            int columnIndex = WalWriter.this.metadata.getColumnIndexQuiet(columnName);
            if (columnIndex < 0) {
                throw CairoException.nonCritical().put(errorPrefix).put(", column does not exist [table=").put(WalWriter.this.tableToken.getTableName()).put(", column=").put(columnName).put(']');
            }
            if (columnIndex == WalWriter.this.metadata.getTimestampIndex()) {
                throw CairoException.nonCritical().put(errorPrefix).put(" designated timestamp column [table=").put(WalWriter.this.tableToken.getTableName()).put(", column=").put(columnName).put(']');
            }
            return columnIndex;
        }

        private void validateNewColumnName(CharSequence columnName) {
            if (!TableUtils.isValidColumnName(columnName, columnName.length())) {
                throw CairoException.nonCritical().put("invalid column name: ").put(columnName);
            }
            if (WalWriter.this.metadata.getColumnIndexQuiet(columnName) > -1) {
                throw CairoException.duplicateColumn(columnName);
            }
        }

        private void validateNewColumnType(int columnType) {
            if (columnType <= 0) {
                throw CairoException.nonCritical().put("invalid column type: ").put(columnType);
            }
        }
    }

    private class MetadataWriterService
    implements MetadataServiceStub {
        private MetadataWriterService() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void addColumn(CharSequence columnName, int columnType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isSequential, boolean isDedupKey, SecurityContext securityContext) {
            int columnIndex = WalWriter.this.metadata.getColumnIndexQuiet(columnName);
            if (columnIndex < 0 || WalWriter.this.metadata.getColumnType(columnIndex) < 0) {
                long uncommittedRows = WalWriter.this.getUncommittedRowCount();
                if (WalWriter.this.currentTxnStartRowNum > 0L) {
                    WalWriter.this.rollUncommittedToNewSegment(-1, -1);
                }
                if (WalWriter.this.currentTxnStartRowNum != 0L && WalWriter.this.segmentRowCount != WalWriter.this.currentTxnStartRowNum) throw CairoException.critical(0).put("column '").put(columnName).put("' was added, cannot apply commit because of concurrent table definition change");
                long segmentRowCount = WalWriter.this.getUncommittedRowCount();
                WalWriter.this.metadata.addColumn(columnName, columnType, isDedupKey, symbolCacheFlag, symbolCapacity);
                WalWriter.this.columnCount = WalWriter.this.metadata.getColumnCount();
                columnIndex = WalWriter.this.columnCount - 1;
                WalWriter.this.configureColumn(columnIndex, columnType);
                if (ColumnType.isSymbol(columnType)) {
                    WalWriter.this.configureSymbolMapWriter(columnIndex, columnName, 0, -1L);
                }
                if (!WalWriter.this.rollSegmentOnNextRow) {
                    WalWriter.this.path.trimTo(WalWriter.this.pathSize).slash().put(WalWriter.this.segmentId);
                    WalWriter.this.metadata.switchTo(WalWriter.this.path, WalWriter.this.path.size(), WalWriter.this.isTruncateFilesOnClose());
                    WalWriter.this.openColumnFiles(columnName, columnType, columnIndex, WalWriter.this.path.size());
                    WalWriter.this.path.trimTo(WalWriter.this.pathSize);
                }
                if (uncommittedRows > 0L) {
                    WalWriter.this.setColumnNull(columnType, columnIndex, segmentRowCount, WalWriter.this.configuration.getCommitMode());
                }
                if (securityContext != null) {
                    WalWriter.this.ddlListener.onColumnAdded(securityContext, WalWriter.this.metadata.getTableToken(), columnName);
                }
                LOG.info().$("added column to WAL [path=").$substr(WalWriter.this.pathRootSize, WalWriter.this.path).$(", columnName=").$safe(columnName).$(", type=").$(ColumnType.nameOf(columnType)).I$();
                return;
            } else {
                if (WalWriter.this.metadata.getColumnType(columnIndex) != columnType) throw CairoException.nonCritical().put("column '").put(columnName).put("' already exists");
                LOG.info().$("column has already been added by another WAL [path=").$substr(WalWriter.this.pathRootSize, WalWriter.this.path).$(", columnName=").$safe(columnName).I$();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void changeColumnType(CharSequence columnNameSeq, int newType, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isSequential, SecurityContext securityContext) {
            int existingColumnIndex = WalWriter.this.metadata.getColumnIndexQuiet(columnNameSeq);
            if (existingColumnIndex <= -1) throw CairoException.nonCritical().put("column '").put(columnNameSeq).put("' does not exist");
            String columnName = WalWriter.this.metadata.getColumnName(existingColumnIndex);
            int existingColumnType = WalWriter.this.metadata.getColumnType(existingColumnIndex);
            if (existingColumnType <= 0) return;
            if (existingColumnType == newType) throw CairoException.nonCritical().put("column '").put(columnName).put("' type is already '").put(ColumnType.nameOf(newType)).put('\'');
            int newColumnIndex = WalWriter.this.columnCount;
            WalWriter.this.configureColumn(newColumnIndex, newType);
            if (ColumnType.isSymbol(newType)) {
                WalWriter.this.configureSymbolMapWriter(newColumnIndex, columnName, 0, -1L);
            }
            ++WalWriter.this.columnCount;
            long rowsRemainInCurrentSegment = WalWriter.this.currentTxnStartRowNum;
            WalWriter.this.rollUncommittedToNewSegment(existingColumnIndex, newType);
            if (WalWriter.this.currentTxnStartRowNum != 0L && WalWriter.this.segmentRowCount != WalWriter.this.currentTxnStartRowNum) throw CairoException.critical(0).put("column '").put(columnName).put("' was removed, cannot apply commit because of concurrent table definition change");
            WalWriter.this.metadata.changeColumnType(columnName, newType, symbolCapacity, symbolCacheFlag, isIndexed, indexValueBlockCapacity);
            WalWriter.this.path.trimTo(WalWriter.this.pathSize).slash().put(WalWriter.this.segmentId);
            WalWriter.this.markColumnRemoved(existingColumnIndex, existingColumnType);
            if (!WalWriter.this.rollSegmentOnNextRow) {
                WalWriter.this.path.trimTo(WalWriter.this.pathSize).slash().put(WalWriter.this.segmentId);
                WalWriter.this.metadata.switchTo(WalWriter.this.path, WalWriter.this.path.size(), WalWriter.this.isTruncateFilesOnClose());
                if (WalWriter.this.segmentRowCount == 0L) {
                    WalWriter.this.openColumnFiles(columnName, newType, newColumnIndex, WalWriter.this.path.size());
                }
            }
            if (rowsRemainInCurrentSegment == 0L && ColumnType.isVarSize(existingColumnType) && !ColumnType.isVarSize(newType)) {
                WalWriter.this.path.trimTo(WalWriter.this.pathSize).slash().put(WalWriter.this.segmentId);
                LPSZ lpsz = TableUtils.iFile(WalWriter.this.path, columnName);
                if (WalWriter.this.ff.exists(lpsz)) {
                    WalWriter.this.ff.remove(lpsz);
                }
            }
            WalWriter.this.path.trimTo(WalWriter.this.pathSize);
        }

        @Override
        public void disableDeduplication() {
            WalWriter.this.metadata.disableDeduplicate();
        }

        @Override
        public boolean enableDeduplicationWithUpsertKeys(LongList columnsIndexes) {
            return WalWriter.this.metadata.enableDeduplicationWithUpsertKeys();
        }

        @Override
        public TableRecordMetadata getMetadata() {
            return WalWriter.this.metadata;
        }

        @Override
        public TableToken getTableToken() {
            return WalWriter.this.tableToken;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void removeColumn(@NotNull CharSequence columnNameSeq) {
            int columnIndex = WalWriter.this.metadata.getColumnIndexQuiet(columnNameSeq);
            if (columnIndex <= -1) throw CairoException.nonCritical().put("column does not exist [column=").put(columnNameSeq).put(']');
            String columnName = WalWriter.this.metadata.getColumnName(columnIndex);
            int type = WalWriter.this.metadata.getColumnType(columnIndex);
            if (type <= 0) return;
            if (WalWriter.this.currentTxnStartRowNum > 0L) {
                WalWriter.this.rollUncommittedToNewSegment(-1, -1);
            }
            if (WalWriter.this.currentTxnStartRowNum != 0L && WalWriter.this.segmentRowCount != WalWriter.this.currentTxnStartRowNum) throw CairoException.critical(0).put("column was removed, cannot apply commit because of concurrent table definition change").put(" [column=").put(columnName).put(']');
            int index = WalWriter.this.metadata.getColumnIndex(columnName);
            WalWriter.this.metadata.removeColumn(columnName);
            WalWriter.this.columnCount = WalWriter.this.metadata.getColumnCount();
            if (!WalWriter.this.rollSegmentOnNextRow) {
                WalWriter.this.path.trimTo(WalWriter.this.pathSize).slash().put(WalWriter.this.segmentId);
                WalWriter.this.metadata.switchTo(WalWriter.this.path, WalWriter.this.path.size(), WalWriter.this.isTruncateFilesOnClose());
            }
            WalWriter.this.markColumnRemoved(index, type);
            WalWriter.this.path.trimTo(WalWriter.this.pathSize);
            LOG.info().$("removed column from WAL [path=").$substr(WalWriter.this.pathRootSize, WalWriter.this.path).$(Files.SEPARATOR).$(WalWriter.this.segmentId).$(", columnName=").$safe(columnName).I$();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void renameColumn(@NotNull CharSequence columnNameSeq, @NotNull CharSequence newColumnName, SecurityContext securityContext) {
            int columnIndex = WalWriter.this.metadata.getColumnIndexQuiet(columnNameSeq);
            if (columnIndex <= -1) throw CairoException.nonCritical().put("column does not exist [column=").put(columnNameSeq).put(']');
            String columnName = WalWriter.this.metadata.getColumnName(columnIndex);
            int columnType = WalWriter.this.metadata.getColumnType(columnIndex);
            if (columnType <= 0) return;
            if (WalWriter.this.currentTxnStartRowNum > 0L) {
                WalWriter.this.rollUncommittedToNewSegment(-1, -1);
            }
            if (WalWriter.this.currentTxnStartRowNum != 0L && WalWriter.this.segmentRowCount != WalWriter.this.currentTxnStartRowNum) throw CairoException.critical(0).put("column was removed, cannot apply commit because of concurrent table definition change").put(" [column=").put(columnName).put(']');
            WalWriter.this.metadata.renameColumn(columnName, newColumnName);
            if (!WalWriter.this.rollSegmentOnNextRow) {
                WalWriter.this.path.trimTo(WalWriter.this.pathSize).slash().put(WalWriter.this.segmentId);
                WalWriter.this.metadata.switchTo(WalWriter.this.path, WalWriter.this.path.size(), WalWriter.this.isTruncateFilesOnClose());
                WalWriter.this.renameColumnFiles(columnType, columnName, newColumnName);
            }
            if (securityContext != null) {
                WalWriter.this.ddlListener.onColumnRenamed(securityContext, WalWriter.this.metadata.getTableToken(), columnName, newColumnName);
            }
            WalWriter.this.path.trimTo(WalWriter.this.pathSize);
            LOG.info().$("renamed column in WAL [path=").$substr(WalWriter.this.pathRootSize, WalWriter.this.path).$(Files.SEPARATOR).$(WalWriter.this.segmentId).$(", columnName=").$safe(columnName).$(", newColumnName=").$safe(newColumnName).I$();
        }

        @Override
        public void renameTable(@NotNull CharSequence fromNameTable, @NotNull CharSequence toTableName) {
            WalWriter.this.tableToken = WalWriter.this.metadata.getTableToken().renamed(Chars.toString(toTableName));
            WalWriter.this.metadata.renameTable(WalWriter.this.tableToken);
        }
    }

    private class RowImpl
    implements TableWriter.Row {
        private final StringSink tempSink = new StringSink();
        private final Utf8StringSink tempUtf8Sink = new Utf8StringSink();
        private long timestamp;

        private RowImpl() {
        }

        @Override
        public void append() {
            WalWriter.this.rowAppend(WalWriter.this.nullSetters, this.timestamp);
        }

        @Override
        public void cancel() {
            WalWriter.this.setAppendPosition(WalWriter.this.segmentRowCount);
        }

        @Override
        public void putArray(int columnIndex, @NotNull ArrayView arrayView) {
            ArrayTypeDriver.appendValue(this.getSecondaryColumn(columnIndex), this.getPrimaryColumn(columnIndex), arrayView);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putBin(int columnIndex, long address, long len) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putBin(address, len));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putBin(int columnIndex, BinarySequence sequence) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putBin(sequence));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putBool(int columnIndex, boolean value) {
            this.getPrimaryColumn(columnIndex).putBool(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putByte(int columnIndex, byte value) {
            this.getPrimaryColumn(columnIndex).putByte(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putChar(int columnIndex, char value) {
            this.getPrimaryColumn(columnIndex).putChar(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putDate(int columnIndex, long value) {
            this.putLong(columnIndex, value);
        }

        @Override
        public void putDouble(int columnIndex, double value) {
            this.getPrimaryColumn(columnIndex).putDouble(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putFloat(int columnIndex, float value) {
            this.getPrimaryColumn(columnIndex).putFloat(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putGeoHash(int columnIndex, long value) {
            int type = WalWriter.this.metadata.getColumnType(columnIndex);
            WriterRowUtils.putGeoHash(columnIndex, value, type, this);
        }

        @Override
        public void putGeoHashDeg(int columnIndex, double lat, double lon) {
            int type = WalWriter.this.metadata.getColumnType(columnIndex);
            WriterRowUtils.putGeoHash(columnIndex, GeoHashes.fromCoordinatesDegUnsafe(lat, lon, ColumnType.getGeoHashBits(type)), type, this);
        }

        @Override
        public void putGeoStr(int columnIndex, CharSequence hash) {
            int type = WalWriter.this.metadata.getColumnType(columnIndex);
            WriterRowUtils.putGeoStr(columnIndex, hash, type, this);
        }

        @Override
        public void putGeoVarchar(int columnIndex, Utf8Sequence hash) {
            int type = WalWriter.this.metadata.getColumnType(columnIndex);
            WriterRowUtils.putGeoVarchar(columnIndex, hash, type, this);
        }

        @Override
        public void putIPv4(int columnIndex, int value) {
            this.putInt(columnIndex, value);
        }

        @Override
        public void putInt(int columnIndex, int value) {
            this.getPrimaryColumn(columnIndex).putInt(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong(int columnIndex, long value) {
            this.getPrimaryColumn(columnIndex).putLong(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong128(int columnIndex, long lo, long hi) {
            MemoryMA primaryColumn = this.getPrimaryColumn(columnIndex);
            primaryColumn.putLong(lo);
            primaryColumn.putLong(hi);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, long l0, long l1, long l2, long l3) {
            this.getPrimaryColumn(columnIndex).putLong256(l0, l1, l2, l3);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, Long256 value) {
            this.getPrimaryColumn(columnIndex).putLong256(value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, CharSequence hexString) {
            this.getPrimaryColumn(columnIndex).putLong256(hexString);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256(int columnIndex, @NotNull CharSequence hexString, int start, int end) {
            this.getPrimaryColumn(columnIndex).putLong256(hexString, start, end);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putLong256Utf8(int columnIndex, DirectUtf8Sequence hexString) {
            this.getPrimaryColumn(columnIndex).putLong256Utf8(hexString);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putShort(int columnIndex, short value) {
            this.getPrimaryColumn(columnIndex).putShort(value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, CharSequence value) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, char value) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStr(int columnIndex, CharSequence value, int pos, int len) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStr(value, pos, len));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putStrUtf8(int columnIndex, DirectUtf8Sequence value) {
            this.getSecondaryColumn(columnIndex).putLong(this.getPrimaryColumn(columnIndex).putStrUtf8(value));
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putSym(int columnIndex, CharSequence value) {
            SymbolMapReader symbolMapReader = WalWriter.this.symbolMapReaders.getQuick(columnIndex);
            if (symbolMapReader == null) {
                throw new UnsupportedOperationException();
            }
            this.putSym0(columnIndex, value, symbolMapReader);
        }

        @Override
        public void putSym(int columnIndex, char value) {
            CharSequence str = SingleCharCharSequence.get(value);
            this.putSym(columnIndex, str);
        }

        @Override
        public void putSymIndex(int columnIndex, int key) {
            this.putInt(columnIndex, key);
        }

        @Override
        public void putSymUtf8(int columnIndex, DirectUtf8Sequence value) {
            SymbolMapReader symbolMapReader = WalWriter.this.symbolMapReaders.getQuick(columnIndex);
            if (symbolMapReader != null) {
                Utf8StringIntHashMap utf8Map = WalWriter.this.utf8SymbolMaps.getQuick(columnIndex);
                int index = utf8Map.keyIndex(value);
                if (index < 0) {
                    this.getPrimaryColumn(columnIndex).putInt(utf8Map.valueAt(index));
                    WalWriter.this.setRowValueNotNull(columnIndex);
                } else {
                    utf8Map.putAt(index, Utf8String.newInstance(value), this.putSymUtf8Slow(columnIndex, value, symbolMapReader));
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public void putTimestamp(int columnIndex, long value) {
            if (columnIndex == WalWriter.this.timestampIndex) {
                this.setTimestamp(value);
            } else {
                this.putLong(columnIndex, value);
            }
        }

        @Override
        public void putUuid(int columnIndex, CharSequence uuidStr) {
            SqlUtil.implicitCastStrAsUuid(uuidStr, WalWriter.this.uuid);
            this.putLong128(columnIndex, WalWriter.this.uuid.getLo(), WalWriter.this.uuid.getHi());
        }

        @Override
        public void putUuidUtf8(int columnIndex, Utf8Sequence uuidStr) {
            SqlUtil.implicitCastStrAsUuid(uuidStr, WalWriter.this.uuid);
            this.putLong128(columnIndex, WalWriter.this.uuid.getLo(), WalWriter.this.uuid.getHi());
        }

        @Override
        public void putVarchar(int columnIndex, char value) {
            this.tempUtf8Sink.clear();
            this.tempUtf8Sink.put(value);
            VarcharTypeDriver.appendValue(this.getSecondaryColumn(columnIndex), this.getPrimaryColumn(columnIndex), this.tempUtf8Sink);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        @Override
        public void putVarchar(int columnIndex, Utf8Sequence value) {
            VarcharTypeDriver.appendValue(this.getSecondaryColumn(columnIndex), this.getPrimaryColumn(columnIndex), value);
            WalWriter.this.setRowValueNotNull(columnIndex);
        }

        private MemoryMA getPrimaryColumn(int columnIndex) {
            return WalWriter.this.columns.getQuick(WalWriter.getDataColumnOffset(columnIndex));
        }

        private MemoryMA getSecondaryColumn(int columnIndex) {
            return WalWriter.this.columns.getQuick(WalWriter.getAuxColumnOffset(columnIndex));
        }

        private int putSym0(int columnIndex, CharSequence utf16Value, SymbolMapReader symbolMapReader) {
            int key;
            if (utf16Value != null) {
                CharSequenceIntHashMap utf16Map = WalWriter.this.symbolMaps.getQuick(columnIndex);
                int index = utf16Map.keyIndex(utf16Value);
                if (index > -1) {
                    key = symbolMapReader.keyOf(utf16Value);
                    if (key == -2) {
                        int initialSymCount = WalWriter.this.initialSymbolCounts.get(columnIndex);
                        key = initialSymCount + WalWriter.this.localSymbolIds.postIncrement(columnIndex);
                    }
                    utf16Map.putAt(index, Chars.toString(utf16Value), key);
                } else {
                    key = utf16Map.valueAt(index);
                }
            } else {
                key = Integer.MIN_VALUE;
                WalWriter.this.symbolMapNullFlags.set(columnIndex, true);
            }
            this.getPrimaryColumn(columnIndex).putInt(key);
            WalWriter.this.setRowValueNotNull(columnIndex);
            return key;
        }

        private int putSymUtf8Slow(int columnIndex, DirectUtf8Sequence utf8Value, SymbolMapReader symbolMapReader) {
            return this.putSym0(columnIndex, Utf8s.directUtf8ToUtf16(utf8Value, this.tempSink), symbolMapReader);
        }

        private void setTimestamp(long value) {
            this.getPrimaryColumn(WalWriter.this.timestampIndex).putLong128(value, WalWriter.this.segmentRowCount);
            WalWriter.this.setRowValueNotNull(WalWriter.this.timestampIndex);
            this.timestamp = value;
        }
    }

    private static class ConversionSymbolTable
    implements SymbolTable {
        private final IntList symbols = new IntList();
        private int symbolCountWatermark;
        private CharSequenceIntHashMap symbolHashMap;
        private SymbolMapReader symbolMapReader;

        private ConversionSymbolTable() {
        }

        @Override
        public CharSequence valueBOf(int key) {
            return this.valueOf(key);
        }

        @Override
        public CharSequence valueOf(int key) {
            if (key == Integer.MIN_VALUE) {
                return null;
            }
            if (key < this.symbolCountWatermark) {
                return this.symbolMapReader.valueOf(key);
            }
            int keyIndex = this.symbols.get(key - this.symbolCountWatermark);
            return this.symbolHashMap.keys().get(keyIndex);
        }

        void of(WalWriter writer, int columnIndex) {
            this.symbolMapReader = writer.getSymbolMapReader(columnIndex);
            this.symbolCountWatermark = writer.getSymbolCountWatermark(columnIndex);
            this.symbols.clear();
            this.symbolHashMap = writer.symbolMaps.getQuick(columnIndex);
            int remapSize = writer.localSymbolIds.get(columnIndex);
            if (remapSize > 0) {
                this.symbols.setPos(remapSize);
                int n = this.symbolHashMap.size();
                for (int i = 0; i < n; ++i) {
                    CharSequence symbolValue = this.symbolHashMap.keys().get(i);
                    int index = this.symbolHashMap.get(symbolValue);
                    if (index < this.symbolCountWatermark) continue;
                    this.symbols.extendAndSet(index - this.symbolCountWatermark, i);
                }
            }
        }
    }

    private static class ConversionSymbolMapWriter
    implements SymbolMapWriterLite {
        private int columnIndex;
        private IntList localSymbolIds;
        private CharSequenceIntHashMap symbolHashMap;
        private SymbolMapReader symbolMapReader;

        private ConversionSymbolMapWriter() {
        }

        @Override
        public int resolveSymbol(CharSequence value) {
            return this.putSym0(this.columnIndex, value, this.symbolMapReader);
        }

        private int putSym0(int columnIndex, CharSequence utf16Value, SymbolMapReader symbolMapReader) {
            int key;
            if (utf16Value != null) {
                CharSequenceIntHashMap utf16Map = this.symbolHashMap;
                int index = utf16Map.keyIndex(utf16Value);
                if (index > -1) {
                    key = symbolMapReader.keyOf(utf16Value);
                    if (key == -2) {
                        key = this.localSymbolIds.postIncrement(columnIndex);
                    }
                    utf16Map.putAt(index, Chars.toString(utf16Value), key);
                } else {
                    key = utf16Map.valueAt(index);
                }
            } else {
                key = Integer.MIN_VALUE;
            }
            return key;
        }

        void of(WalWriter writer, int columnIndex) {
            this.columnIndex = columnIndex;
            this.symbolMapReader = writer.getSymbolMapReader(columnIndex);
            this.symbolHashMap = writer.symbolMaps.getQuick(columnIndex);
            this.localSymbolIds = writer.localSymbolIds;
        }
    }
}

