/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypeConverter;
import io.questdb.cairo.ColumnTypeDriver;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.wal.SegmentColumnRollSink;
import io.questdb.griffin.SymbolMapWriterLite;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;
import org.jetbrains.annotations.Nullable;

public class CopyWalSegmentUtils {
    private static final Log LOG = LogFactory.getLog(CopyWalSegmentUtils.class);
    private static final int MEMORY_TAG = 11;

    public static void rollColumnToSegment(FilesFacade ff, int options, MemoryMA primaryColumn, MemoryMA secondaryColumn, Path walPath, int newSegment, CharSequence columnName, int columnType, long startRowNumber, long rowCount, SegmentColumnRollSink columnRollSink, int commitMode, int newColumnType, @Nullable SymbolTable symbolTable, @Nullable SymbolMapWriterLite symbolMapWriter) {
        boolean success;
        Path newSegPath = Path.PATH.get().of(walPath).slash().put(newSegment);
        int setPathRoot = newSegPath.size();
        long primaryFd = TableUtils.openRW(ff, TableUtils.dFile(newSegPath, columnName, -1L), LOG, options);
        columnRollSink.setDestPrimaryFd(primaryFd);
        long secondaryFd = ColumnType.isVarSize(newColumnType) ? TableUtils.openRW(ff, TableUtils.iFile(newSegPath.trimTo(setPathRoot), columnName, -1L), LOG, options) : -1L;
        columnRollSink.setDestSecondaryFd(secondaryFd);
        if (columnType == newColumnType) {
            success = ColumnType.isVarSize(columnType) ? CopyWalSegmentUtils.copyVarSizeFiles(ff, columnType, primaryColumn, secondaryColumn, primaryFd, secondaryFd, startRowNumber, rowCount, columnRollSink, commitMode) : (columnType > 0 ? CopyWalSegmentUtils.copyFixLenFile(ff, primaryColumn, primaryFd, startRowNumber, rowCount, columnType, columnRollSink, commitMode) : CopyWalSegmentUtils.copyTimestampFile(ff, primaryColumn, primaryFd, startRowNumber, rowCount, columnRollSink, commitMode));
        } else {
            try {
                long dstVarFd;
                long dstFixFd;
                long srcVarFd;
                long srcFixFd;
                if (ColumnType.isVarSize(columnType)) {
                    srcFixFd = secondaryColumn.getFd();
                    srcVarFd = primaryColumn.getFd();
                } else {
                    srcFixFd = primaryColumn.getFd();
                    srcVarFd = -1L;
                }
                if (ColumnType.isVarSize(newColumnType)) {
                    dstFixFd = secondaryFd;
                    dstVarFd = primaryFd;
                } else {
                    dstFixFd = primaryFd;
                    dstVarFd = -1L;
                }
                success = ColumnTypeConverter.convertColumn(startRowNumber, rowCount, columnType, srcFixFd, srcVarFd, symbolTable, newColumnType, dstFixFd, dstVarFd, symbolMapWriter, ff, primaryColumn.getExtendSegmentSize(), columnRollSink);
                if (commitMode != 2) {
                    ff.fsync(srcFixFd);
                    ff.fsync(srcVarFd);
                    ff.fsync(dstFixFd);
                    ff.fsync(dstVarFd);
                }
            }
            catch (Throwable th) {
                LOG.critical().$("Failed to convert column [name=").$(newSegPath).$(", error=").$(th).I$();
                success = false;
            }
        }
        if (!success) {
            throw CairoException.critical(ff.errno()).put("failed to copy column file to new segment [path=").put(newSegPath).put(", column=").put(columnName).put(", errno=").put(ff.errno()).put(", startRowNumber=").put(startRowNumber).put(", rowCount=").put(rowCount).put(", columnType=").put(columnType).put(", newColumnType=").put(newColumnType).put("]");
        }
    }

    private static boolean copyFixLenFile(FilesFacade ff, MemoryMA primaryColumn, long primaryFd, long rowOffset, long rowCount, int columnType, SegmentColumnRollSink columnRollSink, int commitMode) {
        boolean success;
        int shl = ColumnType.pow2SizeOf(columnType);
        assert (shl > -1);
        long offset = rowOffset << shl;
        long length = rowCount << shl;
        boolean bl = success = ff.copyData(primaryColumn.getFd(), primaryFd, offset, length) == length;
        if (success) {
            columnRollSink.setSrcOffsets(offset, -1L);
            columnRollSink.setDestSizes(length, -1L);
            if (commitMode != 2) {
                ff.fsync(primaryFd);
            }
        }
        return success;
    }

    private static boolean copyTimestampFile(FilesFacade ff, MemoryMA primaryColumn, long primaryFd, long rowOffset, long rowCount, SegmentColumnRollSink columnRollSink, int commitMode) {
        if (!CopyWalSegmentUtils.copyFixLenFile(ff, primaryColumn, primaryFd, rowOffset, rowCount, 24, columnRollSink, commitMode)) {
            return false;
        }
        long size = rowCount << 4;
        long srcDataTimestampAddr = TableUtils.mapRW(ff, primaryFd, size, 11);
        Vect.flattenIndex(srcDataTimestampAddr, rowCount);
        if (commitMode != 2) {
            ff.msync(srcDataTimestampAddr, size, commitMode == 0);
        }
        ff.munmap(srcDataTimestampAddr, size, 11);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyVarSizeFiles(FilesFacade ff, int columnType, MemoryMA dataMem, MemoryMA auxMem, long primaryFd, long secondaryFd, long startRowNumber, long rowCount, SegmentColumnRollSink columnRollSink, int commitMode) {
        ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
        long auxMemSize = columnTypeDriver.getAuxVectorSize(startRowNumber + rowCount);
        long auxMemAddr = TableUtils.mapRW(ff, auxMem.getFd(), auxMemSize, 11);
        try {
            boolean success;
            long dataStartOffset = columnTypeDriver.getDataVectorOffset(auxMemAddr, startRowNumber);
            assert (dataStartOffset >= 0L);
            long dataSize = columnTypeDriver.getDataVectorSize(auxMemAddr, startRowNumber, startRowNumber + rowCount - 1L);
            boolean bl = success = dataSize == 0L || ff.copyData(dataMem.getFd(), primaryFd, dataStartOffset, dataSize) == dataSize;
            if (!success) {
                boolean bl2 = false;
                return bl2;
            }
            if (commitMode != 2) {
                ff.fsync(primaryFd);
            }
            long newAuxMemSize = columnTypeDriver.getAuxVectorSize(rowCount);
            long newAuxMemAddr = TableUtils.mapRW(ff, secondaryFd, newAuxMemSize, 11);
            ff.madvise(newAuxMemAddr, newAuxMemSize, Files.POSIX_MADV_RANDOM);
            columnTypeDriver.shiftCopyAuxVector(dataStartOffset, auxMemAddr, startRowNumber, startRowNumber + rowCount - 1L, newAuxMemAddr, newAuxMemSize);
            columnRollSink.setSrcOffsets(dataStartOffset, columnTypeDriver.getAuxVectorSize(startRowNumber));
            columnRollSink.setDestSizes(dataSize, newAuxMemSize);
            if (commitMode != 2) {
                ff.msync(newAuxMemAddr, newAuxMemSize, commitMode == 0);
            }
            ff.munmap(newAuxMemAddr, newAuxMemSize, 11);
            boolean bl3 = true;
            return bl3;
        }
        finally {
            ff.munmap(auxMemAddr, auxMemSize, 11);
        }
    }
}

