/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql.async;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.PageFrameAddressCache;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.PageFrameMemoryPool;
import io.questdb.cairo.sql.StatefulAtom;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.std.DirectLongList;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.QuietCloseable;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.NotNull;

public class PageFrameReduceTask
implements QuietCloseable,
Mutable {
    public static final byte TYPE_FILTER = 0;
    public static final byte TYPE_GROUP_BY = 1;
    public static final byte TYPE_GROUP_BY_NOT_KEYED = 2;
    public static final byte TYPE_TOP_K = 3;
    private static final String exceptionMessage = "unexpected filter error";
    private final DirectLongList auxAddresses;
    private final DirectLongList dataAddresses;
    private final StringSink errorMsg = new StringSink();
    private final DirectLongList filteredRows;
    private final PageFrameMemoryPool frameMemoryPool;
    private final long frameQueueCapacity;
    private int errorMessagePosition;
    private int frameIndex = Integer.MAX_VALUE;
    private PageFrameMemory frameMemory;
    private PageFrameSequence<?> frameSequence;
    private long frameSequenceId;
    private boolean isCancelled;
    private boolean isOutOfMemory;
    private byte taskType;

    public PageFrameReduceTask(CairoConfiguration configuration, int memoryTag) {
        try {
            this.frameQueueCapacity = configuration.getPageFrameReduceQueueCapacity();
            this.filteredRows = new DirectLongList(configuration.getPageFrameReduceRowIdListCapacity(), memoryTag);
            this.dataAddresses = new DirectLongList(configuration.getPageFrameReduceColumnListCapacity(), memoryTag);
            this.auxAddresses = new DirectLongList(configuration.getPageFrameReduceColumnListCapacity(), memoryTag);
            this.frameMemoryPool = new PageFrameMemoryPool(1);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void clear() {
        this.filteredRows.resetCapacity();
        this.dataAddresses.resetCapacity();
        this.auxAddresses.resetCapacity();
        this.frameMemoryPool.clear();
    }

    @Override
    public void close() {
        Misc.free(this.frameMemoryPool);
        Misc.free(this.filteredRows);
        Misc.free(this.dataAddresses);
        Misc.free(this.auxAddresses);
    }

    public DirectLongList getAuxAddresses() {
        return this.auxAddresses;
    }

    public DirectLongList getDataAddresses() {
        return this.dataAddresses;
    }

    public int getErrorMessagePosition() {
        return this.errorMessagePosition;
    }

    public CharSequence getErrorMsg() {
        return this.errorMsg;
    }

    public DirectLongList getFilteredRows() {
        return this.filteredRows;
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public PageFrameMemory getFrameMemory() {
        return this.frameMemory;
    }

    public long getFrameRowCount() {
        return this.frameSequence.getFrameRowCount(this.frameIndex);
    }

    public PageFrameSequence<?> getFrameSequence() {
        return this.frameSequence;
    }

    public <T extends StatefulAtom> PageFrameSequence<T> getFrameSequence(Class<T> unused) {
        return this.frameSequence;
    }

    public long getFrameSequenceId() {
        return this.frameSequenceId;
    }

    public byte getTaskType() {
        return this.taskType;
    }

    public boolean hasError() {
        return this.errorMsg.length() > 0;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public boolean isOutOfMemory() {
        return this.isOutOfMemory;
    }

    public void of(PageFrameSequence<?> frameSequence, int frameIndex) {
        this.frameSequence = frameSequence;
        this.frameSequenceId = frameSequence.getId();
        this.taskType = frameSequence.getTaskType();
        this.frameIndex = frameIndex;
        if (this.taskType != 3) {
            this.frameMemoryPool.of(frameSequence.getPageFrameAddressCache());
        }
        this.frameMemory = null;
        this.filteredRows.clear();
        this.errorMsg.clear();
        this.isCancelled = false;
        this.isOutOfMemory = false;
    }

    public PageFrameMemory populateFrameMemory() {
        assert (this.taskType != 3);
        this.frameMemory = this.frameMemoryPool.navigateTo(this.frameIndex);
        return this.frameMemory;
    }

    public void populateJitData() {
        this.populateJitData(this.frameMemory);
    }

    public void populateJitData(@NotNull PageFrameMemory frameMemory) {
        assert (frameMemory.getFrameIndex() == this.frameIndex);
        PageFrameAddressCache pageAddressCache = this.frameSequence.getPageFrameAddressCache();
        long columnCount = pageAddressCache.getColumnCount();
        this.dataAddresses.clear();
        int columnIndex = 0;
        while ((long)columnIndex < columnCount) {
            this.dataAddresses.add(frameMemory.getPageAddress(columnIndex));
            ++columnIndex;
        }
        this.auxAddresses.clear();
        columnIndex = 0;
        while ((long)columnIndex < columnCount) {
            this.auxAddresses.add(pageAddressCache.isVarSizeColumn(columnIndex) ? frameMemory.getAuxPageAddress(columnIndex) : 0L);
            ++columnIndex;
        }
        long rowCount = this.getFrameRowCount();
        if (this.filteredRows.getCapacity() < rowCount) {
            this.filteredRows.setCapacity(rowCount);
        }
    }

    public void releaseFrameMemory() {
        Misc.free(this.frameMemoryPool);
        this.frameMemory = null;
    }

    public void reset() {
        this.clear();
        this.releaseFrameMemory();
    }

    public void setErrorMsg(Throwable th) {
        if (th instanceof FlyweightMessageContainer) {
            this.errorMsg.put(((FlyweightMessageContainer)((Object)th)).getFlyweightMessage());
        } else {
            String msg = th.getMessage();
            this.errorMsg.put(msg != null ? msg : exceptionMessage);
        }
        if (th instanceof CairoException) {
            CairoException ce = (CairoException)th;
            this.isCancelled = ce.isCancellation();
            this.isOutOfMemory = ce.isOutOfMemory();
            this.errorMessagePosition = ce.getPosition();
        }
    }

    public void setTaskType(byte taskType) {
        this.taskType = taskType;
    }

    void collected() {
        this.collected(false);
    }

    void collected(boolean forceCollect) {
        long frameCount = this.frameSequence.getFrameCount();
        if ((long)(this.frameIndex + 1) == frameCount) {
            this.frameSequence.reset();
        }
        this.frameSequence = null;
        this.frameMemory = null;
        if (forceCollect || (long)this.frameIndex >= frameCount - this.frameQueueCapacity) {
            this.reset();
        }
    }
}

