/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.OrderedMap;
import io.questdb.cairo.map.OrderedMapCursor;
import io.questdb.cairo.map.OrderedMapVarSizeRecord;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.std.DirectLongLongSortedList;
import io.questdb.std.Unsafe;
import io.questdb.std.bytes.Bytes;

class OrderedMapVarSizeCursor
implements OrderedMapCursor {
    private final OrderedMapVarSizeRecord recordA;
    private final OrderedMapVarSizeRecord recordB;
    private final long valueSize;
    private long heapAddr;
    private long heapStart;
    private int remaining;
    private int size;

    OrderedMapVarSizeCursor(OrderedMapVarSizeRecord record, OrderedMap map) {
        assert (map.keySize() == -1L);
        this.recordA = record;
        this.recordB = record.clone();
        this.valueSize = map.valueSize();
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        if (this.remaining > 0) {
            counter.add(this.remaining);
            this.remaining = 0;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public MapRecord getRecord() {
        return this.recordA;
    }

    @Override
    public MapRecord getRecordB() {
        return this.recordB;
    }

    @Override
    public boolean hasNext() {
        if (this.remaining > 0) {
            this.recordA.of(this.heapAddr);
            int keySize = Unsafe.getUnsafe().getInt(this.heapAddr);
            this.heapAddr = Bytes.align8b(this.heapAddr + 4L + (long)keySize + this.valueSize);
            --this.remaining;
            return true;
        }
        return false;
    }

    @Override
    public OrderedMapVarSizeCursor init(long heapStart, long heapLimit, int size) {
        this.heapAddr = this.heapStart = heapStart;
        this.remaining = this.size = size;
        this.recordA.setLimit(heapLimit);
        this.recordB.setLimit(heapLimit);
        return this;
    }

    @Override
    public void longTopK(DirectLongLongSortedList list, Function recordFunction) {
        long addr = this.heapStart;
        for (int i = 0; i < this.size; ++i) {
            this.recordA.of(addr);
            long v = recordFunction.getLong(this.recordA);
            list.add(addr, v);
            addr += Bytes.align8b(4L + (long)this.recordA.keySize() + this.valueSize);
        }
    }

    @Override
    public long preComputedStateSize() {
        return 0L;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        ((OrderedMapVarSizeRecord)record).of(atRowId);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void toTop() {
        this.heapAddr = this.heapStart;
        this.remaining = this.size;
    }
}

